/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.context;

import java.awt.Color;
import java.io.IOException;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import org.apache.myfaces.trinidad.change.ChangeManager;
import org.apache.myfaces.trinidad.config.RegionManager;
import org.apache.myfaces.trinidad.context.AccessibilityProfile;
import org.apache.myfaces.trinidad.context.Agent;
import org.apache.myfaces.trinidad.context.ComponentContextManager;
import org.apache.myfaces.trinidad.context.ComponentContextManagerImpl;
import org.apache.myfaces.trinidad.context.DialogService;
import org.apache.myfaces.trinidad.context.PageFlowScopeProvider;
import org.apache.myfaces.trinidad.context.PageResolver;
import org.apache.myfaces.trinidad.context.Window;
import org.apache.myfaces.trinidad.context.WindowManager;
import org.apache.myfaces.trinidad.context.WindowManagerFactory;
import org.apache.myfaces.trinidad.event.WindowLifecycleListener;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.ArrayMap;
import org.apache.myfaces.trinidad.util.ClassLoaderUtils;
import org.apache.myfaces.trinidad.webapp.UploadedFileProcessor;

public abstract class RequestContext {
    public static final String VARIABLE_NAME = "requestContext";
    private static final WindowManagerFactory _STUB_WINDOW_MANAGER_FACTORY = new StubWindowManagerFactory();
    private static final String _WINDOW_MANAGER_FACTORY_CLASS_NAME = WindowManagerFactory.class.getName();
    private static final ConcurrentMap<ClassLoader, ConcurrentMap<String, Object>> _APPLICATION_MAPS = new ConcurrentHashMap<ClassLoader, ConcurrentMap<String, Object>>();
    private static final ThreadLocal<RequestContext> _CURRENT_CONTEXT = new ThreadLocal();
    private static final String _CURRENT_COMPONENT_BINDING_CONTEXT_KEY = RequestContext.class.getName() + ".CCBCK";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(RequestContext.class);
    private ComponentContextManager _componentContextManager;
    private TagExecution _tagExecution = TagExecution.FULL;
    private WindowManager _windowManager;

    public static RequestContext getCurrentInstance() {
        return _CURRENT_CONTEXT.get();
    }

    protected RequestContext() {
    }

    public abstract Map<String, Object> getPageFlowScope();

    @Deprecated
    public final Map<String, Object> getProcessScope() {
        return this.getPageFlowScope();
    }

    public abstract Map<String, Object> getViewMap();

    public abstract Map<String, Object> getViewMap(boolean var1);

    public Map<String, Object> getWindowMap() {
        ExternalContext extContext;
        WindowManager wm = this.getWindowManager();
        Window window = wm.getCurrentWindow(extContext = FacesContext.getCurrentInstance().getExternalContext());
        if (window != null) {
            return window.getWindowMap();
        }
        return extContext.getSessionMap();
    }

    public abstract void returnFromDialog(Object var1, Map<Object, Object> var2);

    public abstract DialogService getDialogService();

    public abstract void launchDialog(UIViewRoot var1, Map<String, Object> var2, UIComponent var3, boolean var4, Map<String, Object> var5);

    public abstract boolean isPostback();

    public abstract boolean isPartialRequest(FacesContext var1);

    public abstract boolean isDebugOutput();

    public abstract boolean isClientValidationDisabled();

    public abstract String getOutputMode();

    public OutputMode getOutputModeEnum() {
        return OutputMode.fromId(this.getOutputMode());
    }

    public abstract String getSkinFamily();

    public String getSkinVersion() {
        return null;
    }

    public abstract boolean isInternalViewRequest(FacesContext var1);

    public abstract Accessibility getAccessibilityMode();

    public abstract AccessibilityProfile getAccessibilityProfile();

    public abstract ClientValidation getClientValidation();

    public abstract boolean isAnimationEnabled();

    public abstract boolean isRightToLeft();

    public abstract Locale getFormattingLocale();

    public abstract char getNumberGroupingSeparator();

    public abstract char getDecimalSeparator();

    public abstract String getCurrencyCode();

    public void tagExecutionSkipped() {
        this._tagExecution = TagExecution.NONE;
    }

    public TagExecution getTagExecutionStatus() {
        return this._tagExecution;
    }

    public abstract int getTwoDigitYearStart();

    public abstract String getOracleHelpServletUrl();

    public abstract Map<String, Object> getHelpTopic();

    public abstract Map<String, Object> getHelpSystem();

    public abstract TimeZone getTimeZone();

    public abstract ChangeManager getChangeManager();

    public ConcurrentMap<String, Object> getApplicationScopedConcurrentMap() {
        ClassLoader cl = RequestContext._getClassLoader();
        ConcurrentHashMap classMap = (ConcurrentHashMap)_APPLICATION_MAPS.get(cl);
        if (classMap == null) {
            ConcurrentHashMap newClassMap = new ConcurrentHashMap();
            ConcurrentHashMap oldClassMap = _APPLICATION_MAPS.putIfAbsent(cl, newClassMap);
            ConcurrentHashMap concurrentHashMap = classMap = oldClassMap != null ? oldClassMap : newClassMap;
            assert (classMap != null);
        }
        return classMap;
    }

    public abstract PageFlowScopeProvider getPageFlowScopeProvider();

    public abstract PageResolver getPageResolver();

    public abstract RegionManager getRegionManager();

    public RoundingMode getRoundingMode() {
        return null;
    }

    public abstract void addPartialTarget(UIComponent var1);

    public abstract void addPartialTargets(UIComponent var1, String ... var2);

    public abstract Set<UIComponent> getPartialTargets(UIComponent var1);

    public abstract void addPartialTriggerListeners(UIComponent var1, String[] var2);

    public abstract void partialUpdateNotify(UIComponent var1);

    public static void pushComponentBindingContext(FacesContext context) {
        ExternalContext ec = context.getExternalContext();
        if (null != ec) {
            Map reqMap = ec.getRequestMap();
            Integer value = (Integer)reqMap.get(_CURRENT_COMPONENT_BINDING_CONTEXT_KEY);
            int val = 0;
            val = value == null ? 1 : value + 1;
            reqMap.put(_CURRENT_COMPONENT_BINDING_CONTEXT_KEY, val);
        }
    }

    public static void popComponentBindingContext(FacesContext context) {
        ExternalContext ec = context.getExternalContext();
        if (null != ec) {
            Map reqMap = ec.getRequestMap();
            Integer value = (Integer)reqMap.get(_CURRENT_COMPONENT_BINDING_CONTEXT_KEY);
            int val = 0;
            if (value == null) {
                _LOG.warning("POP_COMPONENT_BINDING_CONTEXT_FAILED");
            } else {
                val = value - 1;
            }
            if (val > 0) {
                reqMap.put(_CURRENT_COMPONENT_BINDING_CONTEXT_KEY, val);
            } else {
                reqMap.put(_CURRENT_COMPONENT_BINDING_CONTEXT_KEY, null);
            }
        }
    }

    public static boolean isInComponentBindingContext(FacesContext context) {
        Map reqMap;
        Integer value;
        ExternalContext ec = context.getExternalContext();
        return null != ec && (value = (Integer)(reqMap = ec.getRequestMap()).get(_CURRENT_COMPONENT_BINDING_CONTEXT_KEY)) != null && value > 0;
    }

    public final VisitContext createVisitContext(FacesContext context, Collection<String> ids, Set<VisitHint> hints, PhaseId phaseId) {
        return VisitContext.createVisitContext((FacesContext)context, ids, hints);
    }

    public abstract UploadedFileProcessor getUploadedFileProcessor();

    public abstract Long getUploadedFileMaxMemory();

    public abstract Long getUploadedFileMaxDiskSpace();

    public Long getUploadedFileMaxFileSize() {
        return -1L;
    }

    public Long getUploadedFileMaxChunkSize() {
        return 2000000000L;
    }

    public abstract String getUploadedFileTempDir();

    public abstract Map<String, List<Color>> getColorPalette();

    public abstract Map<Object, Map<Object, String>> getFormatter();

    public abstract Agent getAgent();

    public abstract Object saveComponent(UIComponent var1);

    public abstract UIComponent restoreComponent(Object var1) throws ClassNotFoundException, InstantiationException, IllegalAccessException;

    public WindowManager getWindowManager() {
        FacesContext context;
        WindowManager windowManager = this._windowManager;
        if (windowManager == null && (context = FacesContext.getCurrentInstance()) != null) {
            List windowManagerFactories;
            WindowManagerFactory oldWindowManagerFactory;
            ExternalContext extContext = context.getExternalContext();
            ConcurrentMap<String, Object> concurrentAppMap = this.getApplicationScopedConcurrentMap();
            WindowManagerFactory windowManagerFactory = (WindowManagerFactory)concurrentAppMap.get(_WINDOW_MANAGER_FACTORY_CLASS_NAME);
            if (windowManagerFactory == null && (oldWindowManagerFactory = (WindowManagerFactory)concurrentAppMap.putIfAbsent(_WINDOW_MANAGER_FACTORY_CLASS_NAME, windowManagerFactory = (windowManagerFactories = ClassLoaderUtils.getServices(_WINDOW_MANAGER_FACTORY_CLASS_NAME)).isEmpty() ? _STUB_WINDOW_MANAGER_FACTORY : (WindowManagerFactory)windowManagerFactories.get(0))) != null) {
                windowManagerFactory = oldWindowManagerFactory;
            }
            this._windowManager = windowManager = windowManagerFactory.getWindowManager(extContext);
        }
        return windowManager;
    }

    public ComponentContextManager getComponentContextManager() {
        if (this._componentContextManager == null) {
            this._componentContextManager = new ComponentContextManagerImpl();
        }
        return this._componentContextManager;
    }

    public void pushCurrentComponent(FacesContext context, UIComponent component) {
    }

    public void popCurrentComponent(FacesContext context, UIComponent component) {
    }

    public UIComponent getCurrentComponent() {
        return null;
    }

    public void release() {
        RequestContext o;
        if (_LOG.isFinest()) {
            _LOG.finest("RequestContext released.", new RuntimeException("This is not an error. This trace is for debugging."));
        }
        if ((o = _CURRENT_CONTEXT.get()) == null) {
            throw new IllegalStateException(RequestContext._addHelp("RequestContext was already released or had never been attached."));
        }
        if (o != this) {
            throw new IllegalStateException(_LOG.getMessage("RELEASE_DIFFERENT_REQUESTCONTEXT_THAN_CURRENT_ONE"));
        }
        _CURRENT_CONTEXT.remove();
    }

    public static void releaseApplicationState() {
        _APPLICATION_MAPS.remove(RequestContext._getClassLoader());
    }

    public void attach() {
        RequestContext o;
        if (_LOG.isFinest()) {
            _LOG.finest("RequestContext attached.", new RuntimeException(_LOG.getMessage("DEBUGGING_TRACE_NOT_ERROR")));
        }
        if ((o = _CURRENT_CONTEXT.get()) != null) {
            throw new IllegalStateException(RequestContext._addHelp("Trying to attach RequestContext to a thread that already had one."));
        }
        _CURRENT_CONTEXT.set(this);
    }

    private static String _addHelp(String error) {
        if (!_LOG.isFinest()) {
            error = error + " To enable stack traces of each RequestContext attach/release call, enable Level.FINEST logging for the " + RequestContext.class;
        }
        return error;
    }

    private static ClassLoader _getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private static final class StubWindowManager
    extends WindowManager {
        private StubWindowManager() {
        }

        @Override
        public Window getCurrentWindow(ExternalContext extContext) {
            return null;
        }

        public Map<String, Window> getWindows(ExternalContext extContext) {
            return Collections.emptyMap();
        }

        @Override
        public void addWindowLifecycleListener(ExternalContext extContext, WindowLifecycleListener windowListener) {
        }

        @Override
        public void removeWindowLifecycleListener(ExternalContext extContext, WindowLifecycleListener windowListener) {
        }

        @Override
        public void writeState(FacesContext context) throws IOException {
        }
    }

    private static final class StubWindowManagerFactory
    extends WindowManagerFactory {
        private static final WindowManager _STUB_WINDOW_MANAGER = new StubWindowManager();

        private StubWindowManagerFactory() {
        }

        @Override
        public WindowManager getWindowManager(ExternalContext extContext) {
            return _STUB_WINDOW_MANAGER;
        }
    }

    public static enum TagExecution {
        FULL,
        NONE;

    }

    public static enum ClientValidation {
        ALERT("alert"),
        INLINE("inline"),
        DISABLED("disabled");

        private final String _name;

        private ClientValidation(String name) {
            this._name = name;
        }

        public String toString() {
            return this._name;
        }
    }

    public static enum Accessibility {
        DEFAULT("default"),
        INACCESSIBLE("inaccessible"),
        SCREEN_READER("screenReader");

        private final String _displayName;
        private static final Map<String, Accessibility> _displayNameMap;

        private Accessibility(String displayName) {
            this._displayName = displayName;
        }

        public String toString() {
            return this.displayName();
        }

        public String displayName() {
            return this._displayName;
        }

        public static Accessibility valueOfDisplayName(String displayName) {
            if (displayName == null) {
                throw new NullPointerException();
            }
            Accessibility accessibility = _displayNameMap.get(displayName);
            if (accessibility == null) {
                String message = _LOG.getMessage("ILLEGAL_ENUM_VALUE", new Object[]{Accessibility.class.getName(), displayName});
                throw new IllegalArgumentException(message);
            }
            return accessibility;
        }

        static {
            ArrayMap<String, Accessibility> displayNameMap = new ArrayMap<String, Accessibility>(3);
            for (Accessibility accessibility : Accessibility.values()) {
                displayNameMap.put(accessibility.displayName(), accessibility);
            }
            _displayNameMap = Collections.unmodifiableMap(displayNameMap);
        }
    }

    public static enum OutputMode {
        DEFAULT("default"),
        PORTLET("portlet"),
        PRINTABLE("printable"),
        EMAIL("email"),
        ATTACHMENT("attachment"),
        WEB_CRAWLER("webcrawler");

        private static final Map<String, OutputMode> ID_TO_OUTPUT_MODE;
        private final String _id;

        private OutputMode(String id) {
            if (id == null) {
                throw new NullPointerException();
            }
            this._id = id;
        }

        public String id() {
            return this._id;
        }

        public String toString() {
            return this._id;
        }

        public static OutputMode fromId(String id) {
            if (id == null) {
                throw new NullPointerException();
            }
            OutputMode outputMode = ID_TO_OUTPUT_MODE.get(id);
            if (outputMode == null) {
                throw new IllegalArgumentException();
            }
            return outputMode;
        }

        static {
            ID_TO_OUTPUT_MODE = new HashMap<String, OutputMode>();
            OutputMode[] instances = (OutputMode[])OutputMode.class.getEnumConstants();
            for (int i = 0; i < instances.length; ++i) {
                ID_TO_OUTPUT_MODE.put(instances[i].toString(), instances[i]);
            }
        }
    }
}

