/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.core.input.CoreInputNumberSpinbox;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.skin.Icon;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.SimpleInputListOfValuesRenderer;

public class SimpleInputNumberSpinboxRenderer
extends SimpleInputListOfValuesRenderer {
    private PropertyKey _minimumKey;
    private PropertyKey _maximumKey;
    private PropertyKey _stepSizeKey;
    private static String _SPINBOX_REPEAT_JS = "_spinboxRepeat";
    private static String _CLEAR_SPINBOX_JS = "_clearSpinbox();";
    private static Integer _DEFAULT_COLUMNS = 1;

    public SimpleInputNumberSpinboxRenderer() {
        this(CoreInputNumberSpinbox.TYPE);
    }

    public SimpleInputNumberSpinboxRenderer(FacesBean.Type type) {
        super(type);
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._minimumKey = type.findKey("minimum");
        this._maximumKey = type.findKey("maximum");
        this._stepSizeKey = type.findKey("stepSize");
    }

    @Override
    public boolean isTextArea(UIComponent component, FacesBean bean) {
        return false;
    }

    @Override
    protected boolean getSecret(UIComponent component, FacesBean bean) {
        return false;
    }

    @Override
    protected Number getMaximumLength(UIComponent component, FacesBean bean) {
        return null;
    }

    @Override
    protected boolean shouldRenderInputOnclick() {
        return false;
    }

    @Override
    protected String getRootStyleClass(UIComponent component, FacesBean bean) {
        return "af|inputNumberSpinbox";
    }

    @Override
    protected String getContentStyleClass(UIComponent component, FacesBean bean) {
        return "af|inputNumberSpinbox::content";
    }

    @Override
    protected Integer getDefaultColumns(RenderingContext rc, UIComponent component, FacesBean bean) {
        return _DEFAULT_COLUMNS;
    }

    @Override
    protected void renderTextField(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        ResponseWriter rw = context.getResponseWriter();
        rw.startElement("table", component);
        OutputUtils.renderLayoutTableAttributes(context, rc, "0", "0", "0", null);
        rw.startElement("tr", component);
        rw.startElement("td", component);
        super.renderTextField(context, rc, component, bean);
        rw.endElement("td");
    }

    @Override
    protected void renderAfterTextField(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        ResponseWriter rw = context.getResponseWriter();
        rw.startElement("td", component);
        rw.writeAttribute("align", (Object)"center", null);
        rw.writeAttribute("valign", (Object)"middle", null);
        SimpleInputNumberSpinboxRenderer.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)"af|inputNumberSpinbox::spinbox-cell");
        this.renderIcon(context, rc, component, bean);
        rw.endElement("td");
        rw.endElement("tr");
        rw.endElement("table");
    }

    @Override
    protected void renderIcon(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        ResponseWriter rw = context.getResponseWriter();
        rw.startElement("div", component);
        this._renderSpinboxIcon(context, rc, component, bean, rw, true);
        rw.endElement("div");
        rw.startElement("div", component);
        this._renderSpinboxIcon(context, rc, component, bean, rw, false);
        rw.endElement("div");
    }

    private void _renderSpinboxIcon(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean, ResponseWriter rw, boolean increment) throws IOException {
        boolean disabled = this.getDisabled(component, bean);
        String styleClass = increment ? "af|inputNumberSpinbox::increment-cell" : "af|inputNumberSpinbox::decrement-cell";
        SimpleInputNumberSpinboxRenderer.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)styleClass);
        String iconName = !disabled ? (increment ? "af|inputNumberSpinbox::increment-icon" : "af|inputNumberSpinbox::decrement-icon") : (increment ? "af|inputNumberSpinbox::increment-disabled-icon" : "af|inputNumberSpinbox::decrement-disabled-icon");
        Icon icon = rc.getIcon(iconName);
        if (icon != null && !icon.isNull()) {
            if (!disabled) {
                rw.startElement("a", component);
                rw.writeURIAttribute("href", (Object)"#", null);
                rw.writeAttribute("onclick", (Object)"return false;", null);
                String mouseDownScript = this._getSpinboxScript(context, component, bean, increment);
                rw.writeAttribute("onmousedown", (Object)mouseDownScript, null);
                rw.writeAttribute("onmouseup", (Object)_CLEAR_SPINBOX_JS, null);
                rw.writeAttribute("onmouseout", (Object)_CLEAR_SPINBOX_JS, null);
            }
            String altText = !disabled ? (increment ? "increment" : "decrement") : (increment ? "increment disabled" : "decrement disabled");
            OutputUtils.renderIcon(context, rc, icon, altText, null);
            if (!disabled) {
                rw.endElement("a");
            }
        }
    }

    private String _getSpinboxScript(FacesContext context, UIComponent component, FacesBean bean, boolean increment) {
        StringBuffer js = new StringBuffer();
        js.append(_SPINBOX_REPEAT_JS);
        js.append("('");
        js.append(component.getClientId(context));
        js.append("',");
        js.append(increment);
        js.append(",");
        js.append(this._getStepSizeOrDefault(component, bean));
        js.append(",");
        js.append(this._getMinimumOrDefault(component, bean));
        js.append(",");
        js.append(this._getMaximumOrDefault(component, bean));
        js.append(");");
        return js.toString();
    }

    private int _getMinimumOrDefault(UIComponent component, FacesBean bean) {
        Number minimum = (Number)bean.getProperty(this._minimumKey);
        if (minimum == null) {
            minimum = (Number)this._minimumKey.getDefault();
        }
        assert (minimum != null);
        return minimum.intValue();
    }

    private int _getMaximumOrDefault(UIComponent component, FacesBean bean) {
        Number maximum = (Number)bean.getProperty(this._maximumKey);
        if (maximum == null) {
            maximum = (Number)this._maximumKey.getDefault();
        }
        assert (maximum != null);
        return maximum.intValue();
    }

    private int _getStepSizeOrDefault(UIComponent component, FacesBean bean) {
        Number stepSize = (Number)bean.getProperty(this._stepSizeKey);
        if (stepSize == null) {
            stepSize = (Number)this._stepSizeKey.getDefault();
        }
        assert (stepSize != null);
        return stepSize.intValue();
    }
}

