/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller;

import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.PrimaryNodeOnly;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.TriggerSerially;
import org.apache.nifi.annotation.behavior.TriggerWhenAnyDestinationAvailable;
import org.apache.nifi.annotation.behavior.TriggerWhenEmpty;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.controller.LoggableComponent;
import org.apache.nifi.controller.TerminationAwareLogger;
import org.apache.nifi.processor.Processor;

public class ProcessorDetails {
    private final Processor processor;
    private final Class<?> procClass;
    private final boolean triggerWhenEmpty;
    private final boolean sideEffectFree;
    private final boolean triggeredSerially;
    private final boolean triggerWhenAnyDestinationAvailable;
    private final boolean eventDrivenSupported;
    private final boolean batchSupported;
    private final boolean executionNodeRestricted;
    private final InputRequirement.Requirement inputRequirement;
    private final TerminationAwareLogger componentLog;
    private final BundleCoordinate bundleCoordinate;

    public ProcessorDetails(LoggableComponent<Processor> processor) {
        this.processor = (Processor)processor.getComponent();
        this.componentLog = processor.getLogger();
        this.bundleCoordinate = processor.getBundleCoordinate();
        this.procClass = this.processor.getClass();
        this.triggerWhenEmpty = this.procClass.isAnnotationPresent(TriggerWhenEmpty.class);
        this.sideEffectFree = this.procClass.isAnnotationPresent(SideEffectFree.class);
        this.batchSupported = this.procClass.isAnnotationPresent(SupportsBatching.class);
        this.triggeredSerially = this.procClass.isAnnotationPresent(TriggerSerially.class);
        this.triggerWhenAnyDestinationAvailable = this.procClass.isAnnotationPresent(TriggerWhenAnyDestinationAvailable.class);
        this.eventDrivenSupported = this.procClass.isAnnotationPresent(EventDriven.class) && !this.triggeredSerially && !this.triggerWhenEmpty;
        this.executionNodeRestricted = this.procClass.isAnnotationPresent(PrimaryNodeOnly.class);
        boolean inputRequirementPresent = this.procClass.isAnnotationPresent(InputRequirement.class);
        this.inputRequirement = inputRequirementPresent ? this.procClass.getAnnotation(InputRequirement.class).value() : InputRequirement.Requirement.INPUT_ALLOWED;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public Class<?> getProcClass() {
        return this.procClass;
    }

    public boolean isTriggerWhenEmpty() {
        return this.triggerWhenEmpty;
    }

    public boolean isSideEffectFree() {
        return this.sideEffectFree;
    }

    public boolean isTriggeredSerially() {
        return this.triggeredSerially;
    }

    public boolean isTriggerWhenAnyDestinationAvailable() {
        return this.triggerWhenAnyDestinationAvailable;
    }

    public boolean isEventDrivenSupported() {
        return this.eventDrivenSupported;
    }

    public boolean isBatchSupported() {
        return this.batchSupported;
    }

    public boolean isExecutionNodeRestricted() {
        return this.executionNodeRestricted;
    }

    public InputRequirement.Requirement getInputRequirement() {
        return this.inputRequirement;
    }

    public TerminationAwareLogger getComponentLog() {
        return this.componentLog;
    }

    public BundleCoordinate getBundleCoordinate() {
        return this.bundleCoordinate;
    }
}

