/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote.protocol.socket;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.events.EventReporter;
import org.apache.nifi.remote.Peer;
import org.apache.nifi.remote.PeerDescription;
import org.apache.nifi.remote.PeerStatus;
import org.apache.nifi.remote.RemoteDestination;
import org.apache.nifi.remote.RemoteResourceInitiator;
import org.apache.nifi.remote.StandardVersionNegotiator;
import org.apache.nifi.remote.Transaction;
import org.apache.nifi.remote.TransferDirection;
import org.apache.nifi.remote.VersionNegotiator;
import org.apache.nifi.remote.codec.FlowFileCodec;
import org.apache.nifi.remote.codec.StandardFlowFileCodec;
import org.apache.nifi.remote.exception.HandshakeException;
import org.apache.nifi.remote.exception.ProtocolException;
import org.apache.nifi.remote.protocol.ClientProtocol;
import org.apache.nifi.remote.protocol.CommunicationsSession;
import org.apache.nifi.remote.protocol.HandshakeProperty;
import org.apache.nifi.remote.protocol.RequestType;
import org.apache.nifi.remote.protocol.Response;
import org.apache.nifi.remote.protocol.ResponseCode;
import org.apache.nifi.remote.protocol.socket.SocketClientTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketClientProtocol
implements ClientProtocol {
    private final VersionNegotiator versionNegotiator = new StandardVersionNegotiator(new int[]{6, 5, 4, 3, 2, 1});
    private RemoteDestination destination;
    private boolean useCompression = false;
    private String commsIdentifier;
    private boolean handshakeComplete = false;
    private final Logger logger = LoggerFactory.getLogger(SocketClientProtocol.class);
    private Response handshakeResponse = null;
    private boolean readyForFileTransfer = false;
    private String transitUriPrefix = null;
    private int timeoutMillis = 30000;
    private int batchCount;
    private long batchSize;
    private long batchMillis;
    private EventReporter eventReporter;

    public void setPreferredBatchCount(int count) {
        this.batchCount = count;
    }

    public void setPreferredBatchSize(long bytes) {
        this.batchSize = bytes;
    }

    public void setPreferredBatchDuration(long millis) {
        this.batchMillis = millis;
    }

    public void setEventReporter(EventReporter eventReporter) {
        this.eventReporter = eventReporter;
    }

    public void setDestination(RemoteDestination destination) {
        this.destination = destination;
        this.useCompression = destination.isUseCompression();
    }

    public void setTimeout(int timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
    }

    @Override
    public void handshake(Peer peer) throws IOException {
        this.handshake(peer, this.destination.getIdentifier());
    }

    public void handshake(Peer peer, String destinationId) throws IOException {
        if (this.handshakeComplete) {
            throw new IllegalStateException("Handshake has already been completed");
        }
        this.commsIdentifier = UUID.randomUUID().toString();
        this.logger.debug("{} handshaking with {}", (Object)this, (Object)peer);
        HashMap<HandshakeProperty, String> properties = new HashMap<HandshakeProperty, String>();
        properties.put(HandshakeProperty.GZIP, String.valueOf(this.useCompression));
        if (destinationId != null) {
            properties.put(HandshakeProperty.PORT_IDENTIFIER, destinationId);
        }
        properties.put(HandshakeProperty.REQUEST_EXPIRATION_MILLIS, String.valueOf(this.timeoutMillis));
        if (this.versionNegotiator.getVersion() >= 5) {
            if (this.batchCount > 0) {
                properties.put(HandshakeProperty.BATCH_COUNT, String.valueOf(this.batchCount));
            }
            if (this.batchSize > 0L) {
                properties.put(HandshakeProperty.BATCH_SIZE, String.valueOf(this.batchSize));
            }
            if (this.batchMillis > 0L) {
                properties.put(HandshakeProperty.BATCH_DURATION, String.valueOf(this.batchMillis));
            }
        }
        CommunicationsSession commsSession = peer.getCommunicationsSession();
        commsSession.setTimeout(this.timeoutMillis);
        DataInputStream dis = new DataInputStream(commsSession.getInput().getInputStream());
        DataOutputStream dos = new DataOutputStream(commsSession.getOutput().getOutputStream());
        dos.writeUTF(this.commsIdentifier);
        if (this.versionNegotiator.getVersion() >= 3) {
            dos.writeUTF(peer.getUrl());
            this.transitUriPrefix = peer.getUrl();
            if (!this.transitUriPrefix.endsWith("/")) {
                this.transitUriPrefix = this.transitUriPrefix + "/";
            }
        }
        this.logger.debug("Handshaking with properties {}", properties);
        dos.writeInt(properties.size());
        for (Map.Entry entry : properties.entrySet()) {
            dos.writeUTF(((HandshakeProperty)((Object)entry.getKey())).name());
            dos.writeUTF((String)entry.getValue());
        }
        dos.flush();
        try {
            this.handshakeResponse = Response.read(dis);
        }
        catch (ProtocolException e) {
            throw new HandshakeException(e);
        }
        switch (this.handshakeResponse.getCode()) {
            case PORT_NOT_IN_VALID_STATE: 
            case UNKNOWN_PORT: 
            case PORTS_DESTINATION_FULL: {
                break;
            }
            case PROPERTIES_OK: {
                this.readyForFileTransfer = true;
                break;
            }
            default: {
                this.logger.error("{} received unexpected response {} from {} when negotiating Codec", new Object[]{this, this.handshakeResponse, peer});
                peer.close();
                throw new HandshakeException("Received unexpected response " + this.handshakeResponse);
            }
        }
        this.logger.debug("{} Finished handshake with {}", (Object)this, (Object)peer);
        this.handshakeComplete = true;
    }

    @Override
    public boolean isPortInvalid() {
        if (!this.handshakeComplete) {
            throw new IllegalStateException("Handshake has not completed successfully");
        }
        return this.handshakeResponse.getCode() == ResponseCode.PORT_NOT_IN_VALID_STATE;
    }

    @Override
    public boolean isPortUnknown() {
        if (!this.handshakeComplete) {
            throw new IllegalStateException("Handshake has not completed successfully");
        }
        return this.handshakeResponse.getCode() == ResponseCode.UNKNOWN_PORT;
    }

    @Override
    public boolean isDestinationFull() {
        if (!this.handshakeComplete) {
            throw new IllegalStateException("Handshake has not completed successfully");
        }
        return this.handshakeResponse.getCode() == ResponseCode.PORTS_DESTINATION_FULL;
    }

    @Override
    public Set<PeerStatus> getPeerStatuses(Peer peer) throws IOException {
        if (!this.handshakeComplete) {
            throw new IllegalStateException("Handshake has not been performed");
        }
        this.logger.debug("{} Get Peer Statuses from {}", (Object)this, (Object)peer);
        CommunicationsSession commsSession = peer.getCommunicationsSession();
        DataInputStream dis = new DataInputStream(commsSession.getInput().getInputStream());
        DataOutputStream dos = new DataOutputStream(commsSession.getOutput().getOutputStream());
        boolean queryPeersForOtherPeers = this.getVersionNegotiator().getVersion() >= 6;
        RequestType.REQUEST_PEER_LIST.writeRequestType(dos);
        dos.flush();
        int numPeers = dis.readInt();
        HashSet<PeerStatus> peers = new HashSet<PeerStatus>(numPeers);
        for (int i = 0; i < numPeers; ++i) {
            String hostname = dis.readUTF();
            int port = dis.readInt();
            boolean secure = dis.readBoolean();
            int flowFileCount = dis.readInt();
            peers.add(new PeerStatus(new PeerDescription(hostname, port, secure), flowFileCount, queryPeersForOtherPeers));
        }
        this.logger.debug("{} Received {} Peer Statuses from {}", new Object[]{this, peers.size(), peer});
        return peers;
    }

    @Override
    public FlowFileCodec negotiateCodec(Peer peer) throws IOException {
        if (!this.handshakeComplete) {
            throw new IllegalStateException("Handshake has not been performed");
        }
        this.logger.debug("{} Negotiating Codec with {}", (Object)this, (Object)peer);
        CommunicationsSession commsSession = peer.getCommunicationsSession();
        DataInputStream dis = new DataInputStream(commsSession.getInput().getInputStream());
        DataOutputStream dos = new DataOutputStream(commsSession.getOutput().getOutputStream());
        RequestType.NEGOTIATE_FLOWFILE_CODEC.writeRequestType(dos);
        FlowFileCodec codec = new StandardFlowFileCodec();
        try {
            codec = (FlowFileCodec)RemoteResourceInitiator.initiateResourceNegotiation(codec, dis, dos);
        }
        catch (HandshakeException e) {
            throw new ProtocolException(e.toString());
        }
        this.logger.debug("{} negotiated FlowFileCodec {} with {}", new Object[]{this, codec, commsSession});
        return codec;
    }

    @Override
    public Transaction startTransaction(Peer peer, FlowFileCodec codec, TransferDirection direction) throws IOException {
        if (!this.handshakeComplete) {
            throw new IllegalStateException("Handshake has not been performed");
        }
        if (!this.readyForFileTransfer) {
            throw new IllegalStateException("Cannot start transaction; handshake resolution was " + this.handshakeResponse);
        }
        return new SocketClientTransaction(this.versionNegotiator.getVersion(), this.destination.getIdentifier(), peer, codec, direction, this.useCompression, (int)this.destination.getYieldPeriod(TimeUnit.MILLISECONDS), this.eventReporter);
    }

    @Override
    public VersionNegotiator getVersionNegotiator() {
        return this.versionNegotiator;
    }

    @Override
    public void shutdown(Peer peer) throws IOException {
        this.readyForFileTransfer = false;
        CommunicationsSession commsSession = peer.getCommunicationsSession();
        DataOutputStream dos = new DataOutputStream(commsSession.getOutput().getOutputStream());
        this.logger.debug("{} Shutting down with {}", (Object)this, (Object)peer);
        RequestType.SHUTDOWN.writeRequestType(dos);
        dos.flush();
    }

    @Override
    public String getResourceName() {
        return "SocketFlowFileProtocol";
    }

    public String toString() {
        return "SocketClientProtocol[CommsID=" + this.commsIdentifier + "]";
    }
}

