/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.status.history.storage.questdb;

import io.questdb.cairo.sql.Record;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.nifi.controller.status.history.ComponentDetailsStorage;
import org.apache.nifi.controller.status.history.MetricDescriptor;
import org.apache.nifi.controller.status.history.StandardStatusHistory;
import org.apache.nifi.controller.status.history.StatusHistory;
import org.apache.nifi.controller.status.history.StatusSnapshot;
import org.apache.nifi.controller.status.history.questdb.QuestDbContext;
import org.apache.nifi.controller.status.history.questdb.QuestDbEntityReadingTemplate;
import org.apache.nifi.controller.status.history.questdb.QuestDbEntityWritingTemplate;
import org.apache.nifi.controller.status.history.questdb.QuestDbStatusSnapshotMapper;
import org.apache.nifi.controller.status.history.storage.ComponentStatusStorage;

abstract class QuestDbComponentStatusStorage<T>
implements ComponentStatusStorage<T> {
    private final QuestDbEntityWritingTemplate<T> writingTemplate = new QuestDbEntityWritingTemplate<Object>(this.getTableName(), (statusEntry, row) -> {
        row.putSym(1, (CharSequence)this.extractId(statusEntry));
        this.getMetrics().keySet().forEach(ordinal -> row.putLong(ordinal.intValue(), this.getMetrics().get(ordinal).getValueFunction().getValue(statusEntry).longValue()));
    });
    private final Function<Record, StatusSnapshot> statusSnapshotMapper = new QuestDbStatusSnapshotMapper<T>(this.getMetrics());
    private final QuestDbEntityReadingTemplate<StatusSnapshot, List<StatusSnapshot>> readingTemplate = new QuestDbEntityReadingTemplate<StatusSnapshot, List>("SELECT * FROM %s WHERE componentId = '%s' AND capturedAt > to_timestamp('%s', 'yyyy-MM-dd:HH:mm:ss Z') AND capturedAt < to_timestamp('%s', 'yyyy-MM-dd:HH:mm:ss Z') ORDER BY capturedAt ASC", this.statusSnapshotMapper, e -> e, e -> Collections.emptyList());
    private final QuestDbContext dbContext;
    private final ComponentDetailsStorage componentDetailsStorage;

    protected QuestDbComponentStatusStorage(QuestDbContext dbContext, ComponentDetailsStorage componentDetailsStorage) {
        this.dbContext = dbContext;
        this.componentDetailsStorage = componentDetailsStorage;
    }

    protected abstract String extractId(T var1);

    protected abstract Map<Integer, MetricDescriptor<T>> getMetrics();

    protected abstract String getTableName();

    @Override
    public StatusHistory read(String componentId, Instant start, Instant end, int preferredDataPoints) {
        List snapshots = (List)this.readingTemplate.read(this.dbContext.getEngine(), this.dbContext.getSqlExecutionContext(), Arrays.asList(this.getTableName(), componentId, DATE_FORMATTER.format(start), DATE_FORMATTER.format(end)));
        return new StandardStatusHistory(snapshots.subList(Math.max(snapshots.size() - preferredDataPoints, 0), snapshots.size()), this.componentDetailsStorage.getDetails(componentId), new Date());
    }

    @Override
    public void store(List<Pair<Instant, T>> statusEntries) {
        this.writingTemplate.insert(this.dbContext.getEngine(), this.dbContext.getSqlExecutionContext(), statusEntries);
    }
}

