/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.test;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import java.util.concurrent.atomic.AtomicInteger;

public class TestMatchFunctionFactory
implements FunctionFactory {
    private static final String SIGNATURE = "test_match()";
    private static final AtomicInteger closeCount = new AtomicInteger();
    private static final AtomicInteger openCounter = new AtomicInteger();
    private static final AtomicInteger topCounter = new AtomicInteger();

    public static boolean assertAPI(SqlExecutionContext executionContext) {
        return openCounter.get() > 0 && openCounter.get() >= closeCount.get() && topCounter.get() > 0 && (closeCount.get() == 1 || closeCount.get() == executionContext.getWorkerCount() + 1);
    }

    public static void clear() {
        openCounter.set(0);
        topCounter.set(0);
        closeCount.set(0);
    }

    public static boolean isClosed() {
        return closeCount.get() == 1;
    }

    @Override
    public String getSignature() {
        return SIGNATURE;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new TestMatchFunction();
    }

    private static class TestMatchFunction
    extends BooleanFunction {
        private TestMatchFunction() {
        }

        @Override
        public void close() {
            closeCount.incrementAndGet();
        }

        @Override
        public boolean getBool(Record rec) {
            return true;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext sqlExecutionContext) {
            openCounter.incrementAndGet();
        }

        @Override
        public boolean isConstant() {
            return false;
        }

        @Override
        public boolean isReadThreadSafe() {
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(TestMatchFunctionFactory.SIGNATURE);
        }

        @Override
        public void toTop() {
            assert (openCounter.get() > 0);
            topCounter.incrementAndGet();
        }
    }
}

