/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository.schema;

import org.apache.nifi.controller.repository.FlowFileRecord;
import org.apache.nifi.controller.repository.SerializedRepositoryRecord;
import org.apache.nifi.controller.repository.schema.ContentClaimFieldMap;
import org.apache.nifi.repository.schema.Record;
import org.apache.nifi.repository.schema.RecordSchema;

public class RepositoryRecordFieldMap
implements Record {
    private final SerializedRepositoryRecord record;
    private final FlowFileRecord flowFile;
    private final RecordSchema schema;
    private final RecordSchema contentClaimSchema;

    public RepositoryRecordFieldMap(SerializedRepositoryRecord record, RecordSchema repoRecordSchema, RecordSchema contentClaimSchema) {
        this.schema = repoRecordSchema;
        this.contentClaimSchema = contentClaimSchema;
        this.record = record;
        this.flowFile = record.getFlowFileRecord();
    }

    public Object getFieldValue(String fieldName) {
        switch (fieldName) {
            case "Action": {
                return this.record.getType().name();
            }
            case "Record ID": {
                return this.record.getFlowFileRecord().getId();
            }
            case "Swap Location": {
                return this.record.getSwapLocation();
            }
            case "Attributes": {
                return this.flowFile.getAttributes();
            }
            case "Entry Date": {
                return this.flowFile.getEntryDate();
            }
            case "FlowFile Size": {
                return this.flowFile.getSize();
            }
            case "Lineage Start Date": {
                return this.flowFile.getLineageStartDate();
            }
            case "Lineage Start Index": {
                return this.flowFile.getLineageStartIndex();
            }
            case "Queued Date": {
                return this.flowFile.getLastQueueDate();
            }
            case "Queued Date Index": {
                return this.flowFile.getQueueDateIndex();
            }
            case "Content Claim": {
                ContentClaimFieldMap contentClaimFieldMap = this.record.getContentClaim() == null ? null : new ContentClaimFieldMap(this.record.getContentClaim(), this.record.getClaimOffset(), this.contentClaimSchema);
                return contentClaimFieldMap;
            }
            case "Queue Identifier": {
                return this.record.getQueueIdentifier();
            }
        }
        return null;
    }

    public RecordSchema getSchema() {
        return this.schema;
    }

    public String toString() {
        return "RepositoryRecordFieldMap[" + this.record + "]";
    }
}

