/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.models;

import com.azure.security.keyvault.keys.models.CreateKeyOptions;
import com.azure.security.keyvault.keys.models.KeyOperation;
import com.azure.security.keyvault.keys.models.KeyReleasePolicy;
import com.azure.security.keyvault.keys.models.KeyType;
import java.time.OffsetDateTime;
import java.util.Map;

public class CreateOctKeyOptions
extends CreateKeyOptions {
    private Integer keySize;
    private boolean hardwareProtected;

    public CreateOctKeyOptions(String name) {
        super(name, KeyType.OCT);
    }

    public CreateOctKeyOptions setKeySize(Integer keySize) {
        this.keySize = keySize;
        return this;
    }

    public Integer getKeySize() {
        return this.keySize;
    }

    public CreateOctKeyOptions setHardwareProtected(Boolean hardwareProtected) {
        this.hardwareProtected = hardwareProtected;
        KeyType keyType = hardwareProtected != false ? KeyType.OCT_HSM : KeyType.OCT;
        this.setKeyType(keyType);
        return this;
    }

    public Boolean isHardwareProtected() {
        return this.hardwareProtected;
    }

    @Override
    public CreateOctKeyOptions setKeyOperations(KeyOperation ... keyOperations) {
        super.setKeyOperations(keyOperations);
        return this;
    }

    @Override
    public CreateOctKeyOptions setNotBefore(OffsetDateTime notBefore) {
        super.setNotBefore(notBefore);
        return this;
    }

    @Override
    public CreateOctKeyOptions setExpiresOn(OffsetDateTime expiresOn) {
        super.setExpiresOn(expiresOn);
        return this;
    }

    @Override
    public CreateOctKeyOptions setTags(Map<String, String> tags) {
        super.setTags(tags);
        return this;
    }

    @Override
    public CreateOctKeyOptions setEnabled(Boolean enabled) {
        super.setEnabled(enabled);
        return this;
    }

    @Override
    public CreateOctKeyOptions setExportable(Boolean exportable) {
        super.setExportable(exportable);
        return this;
    }

    @Override
    public CreateOctKeyOptions setReleasePolicy(KeyReleasePolicy releasePolicy) {
        super.setReleasePolicy(releasePolicy);
        return this;
    }
}

