/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.bootstrap.command;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Optional;
import org.apache.nifi.bootstrap.command.ApplicationProcessStatusBootstrapCommand;
import org.apache.nifi.bootstrap.command.BootstrapCommand;
import org.apache.nifi.bootstrap.command.BootstrapCommandProvider;
import org.apache.nifi.bootstrap.command.GetRunCommandBootstrapCommand;
import org.apache.nifi.bootstrap.command.ManagementServerBootstrapCommand;
import org.apache.nifi.bootstrap.command.RunBootstrapCommand;
import org.apache.nifi.bootstrap.command.SequenceBootstrapCommand;
import org.apache.nifi.bootstrap.command.StartBootstrapCommand;
import org.apache.nifi.bootstrap.command.StopBootstrapCommand;
import org.apache.nifi.bootstrap.command.UnknownBootstrapCommand;
import org.apache.nifi.bootstrap.command.io.BootstrapArgument;
import org.apache.nifi.bootstrap.command.io.BootstrapArgumentParser;
import org.apache.nifi.bootstrap.command.io.FileResponseStreamHandler;
import org.apache.nifi.bootstrap.command.io.HttpRequestMethod;
import org.apache.nifi.bootstrap.command.io.LoggerResponseStreamHandler;
import org.apache.nifi.bootstrap.command.io.ResponseStreamHandler;
import org.apache.nifi.bootstrap.command.io.StandardBootstrapArgumentParser;
import org.apache.nifi.bootstrap.command.process.ProcessHandleProvider;
import org.apache.nifi.bootstrap.command.process.StandardProcessHandleProvider;
import org.apache.nifi.bootstrap.configuration.ApplicationClassName;
import org.apache.nifi.bootstrap.configuration.ManagementServerPath;
import org.apache.nifi.bootstrap.configuration.StandardConfigurationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardBootstrapCommandProvider
implements BootstrapCommandProvider {
    private static final String SHUTDOWN_REQUESTED = "--shutdown=true";
    private static final String VERBOSE_REQUESTED = "--verbose";
    private static final String VERBOSE_QUERY = "verbose=true";
    private static final String DAYS_QUERY = "days=%d";
    private static final String EMPTY_QUERY = null;
    private static final int FIRST_ARGUMENT = 1;
    private static final int SECOND_ARGUMENT = 2;
    private static final int PATH_ARGUMENTS = 2;
    private static final int DAYS_PATH_ARGUMENTS = 3;
    private static final int DAYS_REQUESTED_DEFAULT = 1;
    private static final Duration START_WATCH_DELAY = Duration.ofSeconds(60L);
    private static final BootstrapArgumentParser bootstrapArgumentParser = new StandardBootstrapArgumentParser();
    private static final Logger commandLogger = LoggerFactory.getLogger((String)ApplicationClassName.BOOTSTRAP_COMMAND.getName());

    @Override
    public BootstrapCommand getBootstrapCommand(String[] arguments) {
        BootstrapCommand bootstrapCommand;
        Optional<BootstrapArgument> bootstrapArgumentFound = bootstrapArgumentParser.getBootstrapArgument(arguments);
        if (bootstrapArgumentFound.isPresent()) {
            BootstrapArgument bootstrapArgument = bootstrapArgumentFound.get();
            bootstrapCommand = this.getBootstrapCommand(bootstrapArgument, arguments);
        } else {
            bootstrapCommand = new UnknownBootstrapCommand();
        }
        return bootstrapCommand;
    }

    private BootstrapCommand getBootstrapCommand(BootstrapArgument bootstrapArgument, String[] arguments) {
        BootstrapCommand bootstrapCommand;
        StandardConfigurationProvider configurationProvider = new StandardConfigurationProvider(System.getenv(), System.getProperties());
        StandardProcessHandleProvider processHandleProvider = new StandardProcessHandleProvider(configurationProvider);
        LoggerResponseStreamHandler commandLoggerStreamHandler = new LoggerResponseStreamHandler(commandLogger);
        StopBootstrapCommand stopBootstrapCommand = new StopBootstrapCommand(processHandleProvider, configurationProvider);
        if (BootstrapArgument.CLUSTER_STATUS == bootstrapArgument) {
            bootstrapCommand = new ManagementServerBootstrapCommand(processHandleProvider, ManagementServerPath.HEALTH_CLUSTER, commandLoggerStreamHandler);
        } else if (BootstrapArgument.DECOMMISSION == bootstrapArgument) {
            bootstrapCommand = this.getDecommissionCommand(processHandleProvider, stopBootstrapCommand, arguments);
        } else if (BootstrapArgument.DIAGNOSTICS == bootstrapArgument) {
            bootstrapCommand = this.getDiagnosticsCommand(processHandleProvider, arguments);
        } else if (BootstrapArgument.GET_RUN_COMMAND == bootstrapArgument) {
            bootstrapCommand = new GetRunCommandBootstrapCommand(configurationProvider, processHandleProvider, System.out);
        } else if (BootstrapArgument.START == bootstrapArgument) {
            RunBootstrapCommand runBootstrapCommand = new RunBootstrapCommand(configurationProvider, processHandleProvider);
            ProcessHandle currentProcessHandle = ProcessHandle.current();
            ApplicationProcessStatusBootstrapCommand statusBootstrapCommand = new ApplicationProcessStatusBootstrapCommand(currentProcessHandle);
            bootstrapCommand = new StartBootstrapCommand(runBootstrapCommand, statusBootstrapCommand, START_WATCH_DELAY);
        } else {
            bootstrapCommand = BootstrapArgument.STATUS == bootstrapArgument ? new ManagementServerBootstrapCommand(processHandleProvider, ManagementServerPath.HEALTH, commandLoggerStreamHandler) : (BootstrapArgument.STATUS_HISTORY == bootstrapArgument ? this.getStatusHistoryCommand(processHandleProvider, arguments) : (BootstrapArgument.STOP == bootstrapArgument ? stopBootstrapCommand : new UnknownBootstrapCommand()));
        }
        return bootstrapCommand;
    }

    private BootstrapCommand getDecommissionCommand(ProcessHandleProvider processHandleProvider, BootstrapCommand stopBootstrapCommand, String[] arguments) {
        LoggerResponseStreamHandler responseStreamHandler = new LoggerResponseStreamHandler(commandLogger);
        ArrayList<BootstrapCommand> bootstrapCommands = new ArrayList<BootstrapCommand>();
        ManagementServerBootstrapCommand decommissionCommand = new ManagementServerBootstrapCommand(processHandleProvider, HttpRequestMethod.DELETE, ManagementServerPath.HEALTH_CLUSTER, EMPTY_QUERY, 202, responseStreamHandler);
        bootstrapCommands.add(decommissionCommand);
        if (this.isShutdownRequested(arguments)) {
            bootstrapCommands.add(stopBootstrapCommand);
        }
        return new SequenceBootstrapCommand(bootstrapCommands);
    }

    private BootstrapCommand getDiagnosticsCommand(ProcessHandleProvider processHandleProvider, String[] arguments) {
        String verboseQuery = this.getVerboseQuery(arguments);
        ResponseStreamHandler responseStreamHandler = this.getDiagnosticsResponseStreamHandler(arguments);
        return new ManagementServerBootstrapCommand(processHandleProvider, HttpRequestMethod.GET, ManagementServerPath.HEALTH_DIAGNOSTICS, verboseQuery, 200, responseStreamHandler);
    }

    private ResponseStreamHandler getDiagnosticsResponseStreamHandler(String[] arguments) {
        ResponseStreamHandler responseStreamHandler;
        if (arguments.length == 2) {
            String outputPathArgument = arguments[1];
            Path outputPath = Paths.get(outputPathArgument, new String[0]);
            responseStreamHandler = new FileResponseStreamHandler(outputPath);
        } else {
            Logger logger = LoggerFactory.getLogger(StandardBootstrapCommandProvider.class);
            responseStreamHandler = new LoggerResponseStreamHandler(logger);
        }
        return responseStreamHandler;
    }

    private BootstrapCommand getStatusHistoryCommand(ProcessHandleProvider processHandleProvider, String[] arguments) {
        String daysQuery = this.getStatusHistoryDaysQuery(arguments);
        ResponseStreamHandler responseStreamHandler = this.getStatusHistoryResponseStreamHandler(arguments);
        return new ManagementServerBootstrapCommand(processHandleProvider, HttpRequestMethod.GET, ManagementServerPath.HEALTH_STATUS_HISTORY, daysQuery, 200, responseStreamHandler);
    }

    private boolean isShutdownRequested(String[] arguments) {
        boolean shutdownRequested = false;
        for (String argument : arguments) {
            if (!SHUTDOWN_REQUESTED.contentEquals(argument)) continue;
            shutdownRequested = true;
            break;
        }
        return shutdownRequested;
    }

    private String getVerboseQuery(String[] arguments) {
        String query = null;
        for (String argument : arguments) {
            if (!VERBOSE_REQUESTED.contentEquals(argument)) continue;
            query = VERBOSE_QUERY;
            break;
        }
        return query;
    }

    private String getStatusHistoryDaysQuery(String[] arguments) {
        int daysRequested;
        if (arguments.length == 3) {
            String daysRequestArgument = arguments[1];
            daysRequested = this.getStatusHistoryDaysRequested(daysRequestArgument);
        } else {
            daysRequested = 1;
        }
        return DAYS_QUERY.formatted(daysRequested);
    }

    private int getStatusHistoryDaysRequested(String daysRequestArgument) {
        int daysRequested;
        try {
            daysRequested = Integer.parseInt(daysRequestArgument);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Status History Days requested not valid");
        }
        return daysRequested;
    }

    private ResponseStreamHandler getStatusHistoryResponseStreamHandler(String[] arguments) {
        ResponseStreamHandler responseStreamHandler;
        if (arguments.length == 2) {
            String outputPathArgument = arguments[1];
            Path outputPath = Paths.get(outputPathArgument, new String[0]);
            responseStreamHandler = new FileResponseStreamHandler(outputPath);
        } else if (arguments.length == 3) {
            String outputPathArgument = arguments[2];
            Path outputPath = Paths.get(outputPathArgument, new String[0]);
            responseStreamHandler = new FileResponseStreamHandler(outputPath);
        } else {
            Logger logger = LoggerFactory.getLogger(StandardBootstrapCommandProvider.class);
            responseStreamHandler = new LoggerResponseStreamHandler(logger);
        }
        return responseStreamHandler;
    }
}

