/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.client.nifi.impl;

import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MediaType;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ParamProviderClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.RequestConfig;
import org.apache.nifi.toolkit.cli.impl.client.nifi.impl.AbstractJerseyClient;
import org.apache.nifi.web.api.entity.ParameterProviderApplyParametersRequestEntity;
import org.apache.nifi.web.api.entity.ParameterProviderEntity;
import org.apache.nifi.web.api.entity.ParameterProviderParameterApplicationEntity;
import org.apache.nifi.web.api.entity.ParameterProviderParameterFetchEntity;
import org.apache.nifi.web.api.entity.VerifyConfigRequestEntity;

public class JerseyParamProviderClient
extends AbstractJerseyClient
implements ParamProviderClient {
    private final WebTarget paramProviderTarget;

    public JerseyParamProviderClient(WebTarget baseTarget) {
        this(baseTarget, null);
    }

    public JerseyParamProviderClient(WebTarget baseTarget, RequestConfig requestConfig) {
        super(requestConfig);
        this.paramProviderTarget = baseTarget.path("/parameter-providers");
    }

    @Override
    public ParameterProviderEntity getParamProvider(String id) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new IllegalArgumentException("Parameter provider id cannot be null or blank");
        }
        return this.executeAction("Error retrieving parameter provider", () -> {
            WebTarget target = this.paramProviderTarget.path("{id}").resolveTemplate("id", (Object)id);
            return (ParameterProviderEntity)this.getRequestBuilder(target).get(ParameterProviderEntity.class);
        });
    }

    @Override
    public ParameterProviderEntity updateParamProvider(ParameterProviderEntity entity) throws NiFiClientException, IOException {
        if (entity == null) {
            throw new IllegalArgumentException("Parameter provider entity cannot be null");
        }
        return this.executeAction("Error updating parameter provider", () -> {
            WebTarget target = this.paramProviderTarget.path("{id}").resolveTemplate("id", (Object)entity.getId());
            return (ParameterProviderEntity)this.getRequestBuilder(target).put(Entity.entity((Object)entity, (MediaType)MediaType.APPLICATION_JSON_TYPE), ParameterProviderEntity.class);
        });
    }

    @Override
    public ParameterProviderEntity deleteParamProvider(String id, String version) throws NiFiClientException, IOException {
        return this.deleteParamProvider(id, version, false);
    }

    @Override
    public ParameterProviderEntity deleteParamProvider(String id, String version, boolean disconnectedNodeAcknowledged) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new IllegalArgumentException("Parameter provider id cannot be null or blank");
        }
        if (StringUtils.isBlank((CharSequence)version)) {
            throw new IllegalArgumentException("Version cannot be null or blank");
        }
        return this.executeAction("Error deleting parameter provider", () -> {
            WebTarget target = this.paramProviderTarget.path("{id}").resolveTemplate("id", (Object)id).queryParam("version", new Object[]{version});
            if (disconnectedNodeAcknowledged) {
                target = target.queryParam("disconnectedNodeAcknowledged", new Object[]{"true"});
            }
            return (ParameterProviderEntity)this.getRequestBuilder(target).delete(ParameterProviderEntity.class);
        });
    }

    @Override
    public ParameterProviderEntity fetchParameters(ParameterProviderParameterFetchEntity parameterFetchEntity) throws NiFiClientException, IOException {
        if (parameterFetchEntity == null) {
            throw new IllegalArgumentException("Parameter fetch entity cannot be null");
        }
        if (parameterFetchEntity.getRevision() == null) {
            throw new IllegalArgumentException("Parameter provider revision cannot be null");
        }
        String paramProviderId = parameterFetchEntity.getId();
        if (StringUtils.isBlank((CharSequence)paramProviderId)) {
            throw new IllegalArgumentException("Parameter provider id cannot be null or blank");
        }
        return this.executeAction("Error fetching parameters", () -> {
            WebTarget target = this.paramProviderTarget.path("{id}/parameters/fetch-requests").resolveTemplate("id", (Object)paramProviderId);
            return (ParameterProviderEntity)this.getRequestBuilder(target).post(Entity.entity((Object)parameterFetchEntity, (String)"application/json"), ParameterProviderEntity.class);
        });
    }

    @Override
    public ParameterProviderApplyParametersRequestEntity applyParameters(ParameterProviderParameterApplicationEntity providerParameterApplicationEntity) throws NiFiClientException, IOException {
        if (providerParameterApplicationEntity == null) {
            throw new IllegalArgumentException("Parameter application entity cannot be null");
        }
        if (providerParameterApplicationEntity.getRevision() == null) {
            throw new IllegalArgumentException("Parameter provider revision cannot be null");
        }
        String paramProviderId = providerParameterApplicationEntity.getId();
        if (StringUtils.isBlank((CharSequence)paramProviderId)) {
            throw new IllegalArgumentException("Parameter provider id cannot be null or blank");
        }
        return this.executeAction("Error creating parameter provider application request", () -> {
            WebTarget target = this.paramProviderTarget.path("{id}/apply-parameters-requests").resolveTemplate("id", (Object)paramProviderId);
            return (ParameterProviderApplyParametersRequestEntity)this.getRequestBuilder(target).post(Entity.entity((Object)providerParameterApplicationEntity, (String)"application/json"), ParameterProviderApplyParametersRequestEntity.class);
        });
    }

    @Override
    public ParameterProviderApplyParametersRequestEntity getParamProviderApplyParametersRequest(String providerId, String applyParametersRequestId) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)applyParametersRequestId)) {
            throw new IllegalArgumentException("Parameter provider apply parameters request id cannot be null or blank");
        }
        return this.executeAction("Error retrieving parameter provider", () -> {
            WebTarget target = this.paramProviderTarget.path("{provider-id}/apply-parameters-requests/{request-id}").resolveTemplate("provider-id", (Object)providerId).resolveTemplate("request-id", (Object)applyParametersRequestId);
            return (ParameterProviderApplyParametersRequestEntity)this.getRequestBuilder(target).get(ParameterProviderApplyParametersRequestEntity.class);
        });
    }

    @Override
    public ParameterProviderApplyParametersRequestEntity deleteParamProviderApplyParametersRequest(String providerId, String updateRequestId) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)updateRequestId)) {
            throw new IllegalArgumentException("Parameter provider apply parameters request id cannot be null or blank");
        }
        return this.executeAction("Error deleting parameter provider apply parameters request", () -> {
            WebTarget target = this.paramProviderTarget.path("{provider-id}/apply-parameters-requests/{request-id}").resolveTemplate("provider-id", (Object)providerId).resolveTemplate("request-id", (Object)updateRequestId);
            return (ParameterProviderApplyParametersRequestEntity)this.getRequestBuilder(target).delete(ParameterProviderApplyParametersRequestEntity.class);
        });
    }

    @Override
    public VerifyConfigRequestEntity submitConfigVerificationRequest(VerifyConfigRequestEntity configRequestEntity) throws NiFiClientException, IOException {
        if (configRequestEntity == null) {
            throw new IllegalArgumentException("Config Request Entity cannot be null");
        }
        if (configRequestEntity.getRequest() == null) {
            throw new IllegalArgumentException("Config Request DTO cannot be null");
        }
        if (configRequestEntity.getRequest().getComponentId() == null) {
            throw new IllegalArgumentException("Parameter Provider ID cannot be null");
        }
        if (configRequestEntity.getRequest().getProperties() == null) {
            throw new IllegalArgumentException("Parameter Provider properties cannot be null");
        }
        return this.executeAction("Error submitting Config Verification Request", () -> {
            WebTarget target = this.paramProviderTarget.path("{id}/config/verification-requests").resolveTemplate("id", (Object)configRequestEntity.getRequest().getComponentId());
            return (VerifyConfigRequestEntity)this.getRequestBuilder(target).post(Entity.entity((Object)configRequestEntity, (MediaType)MediaType.APPLICATION_JSON_TYPE), VerifyConfigRequestEntity.class);
        });
    }

    @Override
    public VerifyConfigRequestEntity getConfigVerificationRequest(String taskId, String verificationRequestId) throws NiFiClientException, IOException {
        if (verificationRequestId == null) {
            throw new IllegalArgumentException("Verification Request ID cannot be null");
        }
        return this.executeAction("Error retrieving Config Verification Request", () -> {
            WebTarget target = this.paramProviderTarget.path("{id}/config/verification-requests/{requestId}").resolveTemplate("id", (Object)taskId).resolveTemplate("requestId", (Object)verificationRequestId);
            return (VerifyConfigRequestEntity)this.getRequestBuilder(target).get(VerifyConfigRequestEntity.class);
        });
    }

    @Override
    public VerifyConfigRequestEntity deleteConfigVerificationRequest(String taskId, String verificationRequestId) throws NiFiClientException, IOException {
        if (verificationRequestId == null) {
            throw new IllegalArgumentException("Verification Request ID cannot be null");
        }
        return this.executeAction("Error deleting Config Verification Request", () -> {
            WebTarget target = this.paramProviderTarget.path("{id}/config/verification-requests/{requestId}").resolveTemplate("id", (Object)taskId).resolveTemplate("requestId", (Object)verificationRequestId);
            return (VerifyConfigRequestEntity)this.getRequestBuilder(target).delete(VerifyConfigRequestEntity.class);
        });
    }
}

