/****************************************************************************
 * arch/arm/src/gd32f4/hardware/gd32f450_pinmap.h
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.  The
 * ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 ****************************************************************************/

#ifndef __ARCH_ARM_SRC_GD32F4_HARDWARE_GD32F450_PINMAP_H
#define __ARCH_ARM_SRC_GD32F4_HARDWARE_GD32F450_PINMAP_H

/****************************************************************************
 * Included Files
 ****************************************************************************/

#include <nuttx/config.h>

#include "gd32f4xx_gpio.h"

/****************************************************************************
 * Pre-processor Definitions
 ****************************************************************************/

/* Alternate Pin Functions.
 *
 * Alternative pin selections are provided with a numeric suffix like _1, _2,
 * etc. Drivers, however, will use the pin selection without the numeric
 * suffix. Additional definitions are required in the board.h file.  For
 * example, if USART0_TX connects via PA9 on some board, then the following
 * definitions should appear in the board.h header file for that board:
 *
 * #define GPIO_USART0_TX GPIO_USART0_TX_1
 *
 * The driver will then automatically configure PA9 as the USART0_TX pin.
 */

/* General GPIO output */
#define GPIO_PIN0_OUTPUT       (GPIO_CFG_MODE_OUTPUT|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_PIN_0)
#define GPIO_PIN1_OUTPUT       (GPIO_CFG_MODE_OUTPUT|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_PIN_1)
#define GPIO_PIN2_OUTPUT       (GPIO_CFG_MODE_OUTPUT|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_PIN_2)
#define GPIO_PIN3_OUTPUT       (GPIO_CFG_MODE_OUTPUT|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_PIN_3)
#define GPIO_PIN4_OUTPUT       (GPIO_CFG_MODE_OUTPUT|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_PIN_4)
#define GPIO_PIN5_OUTPUT       (GPIO_CFG_MODE_OUTPUT|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_PIN_5)
#define GPIO_PIN6_OUTPUT       (GPIO_CFG_MODE_OUTPUT|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_PIN_6)
#define GPIO_PIN7_OUTPUT       (GPIO_CFG_MODE_OUTPUT|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_PIN_7)
#define GPIO_PIN8_OUTPUT       (GPIO_CFG_MODE_OUTPUT|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_PIN_8)
#define GPIO_PIN9_OUTPUT       (GPIO_CFG_MODE_OUTPUT|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_PIN_9)
#define GPIO_PIN10_OUTPUT      (GPIO_CFG_MODE_OUTPUT|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_PIN_10)
#define GPIO_PIN11_OUTPUT      (GPIO_CFG_MODE_OUTPUT|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_PIN_11)
#define GPIO_PIN12_OUTPUT      (GPIO_CFG_MODE_OUTPUT|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_PIN_12)
#define GPIO_PIN13_OUTPUT      (GPIO_CFG_MODE_OUTPUT|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_PIN_13)
#define GPIO_PIN14_OUTPUT      (GPIO_CFG_MODE_OUTPUT|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_PIN_14)
#define GPIO_PIN15_OUTPUT      (GPIO_CFG_MODE_OUTPUT|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_PIN_15)

/* General GPIO input */
#define GPIO_PIN0_INPUT        (GPIO_CFG_MODE_INPUT|GPIO_CFG_PUPD_NONE|GPIO_CFG_PIN_0)
#define GPIO_PIN1_INPUT        (GPIO_CFG_MODE_INPUT|GPIO_CFG_PUPD_NONE|GPIO_CFG_PIN_1)
#define GPIO_PIN2_INPUT        (GPIO_CFG_MODE_INPUT|GPIO_CFG_PUPD_NONE|GPIO_CFG_PIN_2)
#define GPIO_PIN3_INPUT        (GPIO_CFG_MODE_INPUT|GPIO_CFG_PUPD_NONE|GPIO_CFG_PIN_3)
#define GPIO_PIN4_INPUT        (GPIO_CFG_MODE_INPUT|GPIO_CFG_PUPD_NONE|GPIO_CFG_PIN_4)
#define GPIO_PIN5_INPUT        (GPIO_CFG_MODE_INPUT|GPIO_CFG_PUPD_NONE|GPIO_CFG_PIN_5)
#define GPIO_PIN6_INPUT        (GPIO_CFG_MODE_INPUT|GPIO_CFG_PUPD_NONE|GPIO_CFG_PIN_6)
#define GPIO_PIN7_INPUT        (GPIO_CFG_MODE_INPUT|GPIO_CFG_PUPD_NONE|GPIO_CFG_PIN_7)
#define GPIO_PIN8_INPUT        (GPIO_CFG_MODE_INPUT|GPIO_CFG_PUPD_NONE|GPIO_CFG_PIN_8)
#define GPIO_PIN9_INPUT        (GPIO_CFG_MODE_INPUT|GPIO_CFG_PUPD_NONE|GPIO_CFG_PIN_9)
#define GPIO_PIN10_INPUT       (GPIO_CFG_MODE_INPUT|GPIO_CFG_PUPD_NONE|GPIO_CFG_PIN_10)
#define GPIO_PIN11_INPUT       (GPIO_CFG_MODE_INPUT|GPIO_CFG_PUPD_NONE|GPIO_CFG_PIN_11)
#define GPIO_PIN12_INPUT       (GPIO_CFG_MODE_INPUT|GPIO_CFG_PUPD_NONE|GPIO_CFG_PIN_12)
#define GPIO_PIN13_INPUT       (GPIO_CFG_MODE_INPUT|GPIO_CFG_PUPD_NONE|GPIO_CFG_PIN_13)
#define GPIO_PIN14_INPUT       (GPIO_CFG_MODE_INPUT|GPIO_CFG_PUPD_NONE|GPIO_CFG_PIN_14)
#define GPIO_PIN15_INPUT       (GPIO_CFG_MODE_INPUT|GPIO_CFG_PUPD_NONE|GPIO_CFG_PIN_15)

/* Analog-to-digital converter (ADC) */

#define GPIO_ADC0_IN0          (GPIO_CFG_MODE_ANALOG|GPIO_CFG_PUPD_NONE|GPIO_CFG_PORT_A|GPIO_CFG_PIN_0)
#define GPIO_ADC0_IN1          (GPIO_CFG_MODE_ANALOG|GPIO_CFG_PUPD_NONE|GPIO_CFG_PORT_A|GPIO_CFG_PIN_1)
#define GPIO_ADC0_IN2          (GPIO_CFG_MODE_ANALOG|GPIO_CFG_PUPD_NONE|GPIO_CFG_PORT_A|GPIO_CFG_PIN_2)
#define GPIO_ADC0_IN3          (GPIO_CFG_MODE_ANALOG|GPIO_CFG_PUPD_NONE|GPIO_CFG_PORT_A|GPIO_CFG_PIN_3)
#define GPIO_ADC0_IN4          (GPIO_CFG_MODE_ANALOG|GPIO_CFG_PUPD_NONE|GPIO_CFG_PORT_A|GPIO_CFG_PIN_4)
#define GPIO_ADC0_IN5          (GPIO_CFG_MODE_ANALOG|GPIO_CFG_PUPD_NONE|GPIO_CFG_PORT_A|GPIO_CFG_PIN_5)
#define GPIO_ADC0_IN6          (GPIO_CFG_MODE_ANALOG|GPIO_CFG_PUPD_NONE|GPIO_CFG_PORT_A|GPIO_CFG_PIN_6)
#define GPIO_ADC0_IN7          (GPIO_CFG_MODE_ANALOG|GPIO_CFG_PUPD_NONE|GPIO_CFG_PORT_A|GPIO_CFG_PIN_7)
#define GPIO_ADC0_IN8          (GPIO_CFG_MODE_ANALOG|GPIO_CFG_PUPD_NONE|GPIO_CFG_PORT_B|GPIO_CFG_PIN_0)
#define GPIO_ADC0_IN9          (GPIO_CFG_MODE_ANALOG|GPIO_CFG_PUPD_NONE|GPIO_CFG_PORT_B|GPIO_CFG_PIN_1)
#define GPIO_ADC0_IN10         (GPIO_CFG_MODE_ANALOG|GPIO_CFG_PUPD_NONE|GPIO_CFG_PORT_C|GPIO_CFG_PIN_0)
#define GPIO_ADC0_IN11         (GPIO_CFG_MODE_ANALOG|GPIO_CFG_PUPD_NONE|GPIO_CFG_PORT_C|GPIO_CFG_PIN_1)
#define GPIO_ADC0_IN12         (GPIO_CFG_MODE_ANALOG|GPIO_CFG_PUPD_NONE|GPIO_CFG_PORT_C|GPIO_CFG_PIN_2)
#define GPIO_ADC0_IN13         (GPIO_CFG_MODE_ANALOG|GPIO_CFG_PUPD_NONE|GPIO_CFG_PORT_C|GPIO_CFG_PIN_3)
#define GPIO_ADC0_IN14         (GPIO_CFG_MODE_ANALOG|GPIO_CFG_PUPD_NONE|GPIO_CFG_PORT_C|GPIO_CFG_PIN_4)
#define GPIO_ADC0_IN15         (GPIO_CFG_MODE_ANALOG|GPIO_CFG_PUPD_NONE|GPIO_CFG_PORT_C|GPIO_CFG_PIN_5)

#define GPIO_ADC1_IN0          (GPIO_CFG_MODE_ANALOG|GPIO_CFG_PUPD_NONE|GPIO_CFG_PORT_A|GPIO_CFG_PIN_0)
#define GPIO_ADC1_IN1          (GPIO_CFG_MODE_ANALOG|GPIO_CFG_PUPD_NONE|GPIO_CFG_PORT_A|GPIO_CFG_PIN_1)
#define GPIO_ADC1_IN2          (GPIO_CFG_MODE_ANALOG|GPIO_CFG_PUPD_NONE|GPIO_CFG_PORT_A|GPIO_CFG_PIN_2)
#define GPIO_ADC1_IN3          (GPIO_CFG_MODE_ANALOG|GPIO_CFG_PUPD_NONE|GPIO_CFG_PORT_A|GPIO_CFG_PIN_3)
#define GPIO_ADC1_IN4          (GPIO_CFG_MODE_ANALOG|GPIO_CFG_PUPD_NONE|GPIO_CFG_PORT_A|GPIO_CFG_PIN_4)
#define GPIO_ADC1_IN5          (GPIO_CFG_MODE_ANALOG|GPIO_CFG_PUPD_NONE|GPIO_CFG_PORT_A|GPIO_CFG_PIN_5)
#define GPIO_ADC1_IN6          (GPIO_CFG_MODE_ANALOG|GPIO_CFG_PUPD_NONE|GPIO_CFG_PORT_A|GPIO_CFG_PIN_6)
#define GPIO_ADC1_IN7          (GPIO_CFG_MODE_ANALOG|GPIO_CFG_PUPD_NONE|GPIO_CFG_PORT_A|GPIO_CFG_PIN_7)
#define GPIO_ADC1_IN8          (GPIO_CFG_MODE_ANALOG|GPIO_CFG_PUPD_NONE|GPIO_CFG_PORT_B|GPIO_CFG_PIN_0)
#define GPIO_ADC1_IN9          (GPIO_CFG_MODE_ANALOG|GPIO_CFG_PUPD_NONE|GPIO_CFG_PORT_B|GPIO_CFG_PIN_1)
#define GPIO_ADC1_IN10         (GPIO_CFG_MODE_ANALOG|GPIO_CFG_PUPD_NONE|GPIO_CFG_PORT_C|GPIO_CFG_PIN_0)
#define GPIO_ADC1_IN11         (GPIO_CFG_MODE_ANALOG|GPIO_CFG_PUPD_NONE|GPIO_CFG_PORT_C|GPIO_CFG_PIN_1)
#define GPIO_ADC1_IN12         (GPIO_CFG_MODE_ANALOG|GPIO_CFG_PUPD_NONE|GPIO_CFG_PORT_C|GPIO_CFG_PIN_2)
#define GPIO_ADC1_IN13         (GPIO_CFG_MODE_ANALOG|GPIO_CFG_PUPD_NONE|GPIO_CFG_PORT_C|GPIO_CFG_PIN_3)
#define GPIO_ADC1_IN14         (GPIO_CFG_MODE_ANALOG|GPIO_CFG_PUPD_NONE|GPIO_CFG_PORT_C|GPIO_CFG_PIN_4)
#define GPIO_ADC1_IN15         (GPIO_CFG_MODE_ANALOG|GPIO_CFG_PUPD_NONE|GPIO_CFG_PORT_C|GPIO_CFG_PIN_5)

#define GPIO_ADC2_IN0          (GPIO_CFG_MODE_ANALOG|GPIO_CFG_PUPD_NONE|GPIO_CFG_PORT_A|GPIO_CFG_PIN_0)
#define GPIO_ADC2_IN1          (GPIO_CFG_MODE_ANALOG|GPIO_CFG_PUPD_NONE|GPIO_CFG_PORT_A|GPIO_CFG_PIN_1)
#define GPIO_ADC2_IN2          (GPIO_CFG_MODE_ANALOG|GPIO_CFG_PUPD_NONE|GPIO_CFG_PORT_A|GPIO_CFG_PIN_2)
#define GPIO_ADC2_IN3          (GPIO_CFG_MODE_ANALOG|GPIO_CFG_PUPD_NONE|GPIO_CFG_PORT_A|GPIO_CFG_PIN_3)
#define GPIO_ADC2_IN4          (GPIO_CFG_MODE_ANALOG|GPIO_CFG_PUPD_NONE|GPIO_CFG_PORT_F|GPIO_CFG_PIN_6)
#define GPIO_ADC2_IN5          (GPIO_CFG_MODE_ANALOG|GPIO_CFG_PUPD_NONE|GPIO_CFG_PORT_F|GPIO_CFG_PIN_7)
#define GPIO_ADC2_IN6          (GPIO_CFG_MODE_ANALOG|GPIO_CFG_PUPD_NONE|GPIO_CFG_PORT_F|GPIO_CFG_PIN_8)
#define GPIO_ADC2_IN7          (GPIO_CFG_MODE_ANALOG|GPIO_CFG_PUPD_NONE|GPIO_CFG_PORT_F|GPIO_CFG_PIN_9)
#define GPIO_ADC2_IN8          (GPIO_CFG_MODE_ANALOG|GPIO_CFG_PUPD_NONE|GPIO_CFG_PORT_F|GPIO_CFG_PIN_10)
#define GPIO_ADC2_IN9          (GPIO_CFG_MODE_ANALOG|GPIO_CFG_PUPD_NONE|GPIO_CFG_PORT_F|GPIO_CFG_PIN_3)
#define GPIO_ADC2_IN10         (GPIO_CFG_MODE_ANALOG|GPIO_CFG_PUPD_NONE|GPIO_CFG_PORT_C|GPIO_CFG_PIN_0)
#define GPIO_ADC2_IN11         (GPIO_CFG_MODE_ANALOG|GPIO_CFG_PUPD_NONE|GPIO_CFG_PORT_C|GPIO_CFG_PIN_1)
#define GPIO_ADC2_IN12         (GPIO_CFG_MODE_ANALOG|GPIO_CFG_PUPD_NONE|GPIO_CFG_PORT_C|GPIO_CFG_PIN_2)
#define GPIO_ADC2_IN13         (GPIO_CFG_MODE_ANALOG|GPIO_CFG_PUPD_NONE|GPIO_CFG_PORT_C|GPIO_CFG_PIN_3)
#define GPIO_ADC2_IN14         (GPIO_CFG_MODE_ANALOG|GPIO_CFG_PUPD_NONE|GPIO_CFG_PORT_F|GPIO_CFG_PIN_4)
#define GPIO_ADC2_IN15         (GPIO_CFG_MODE_ANALOG|GPIO_CFG_PUPD_NONE|GPIO_CFG_PORT_F|GPIO_CFG_PIN_5)

/* Controller area network (CAN) */

#define GPIO_CAN0_RX_1         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_9|GPIO_CFG_PORT_A|GPIO_CFG_PIN_11)
#define GPIO_CAN0_RX_2         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_9|GPIO_CFG_PORT_B|GPIO_CFG_PIN_8)
#define GPIO_CAN0_RX_3         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_9|GPIO_CFG_PORT_D|GPIO_CFG_PIN_0)
#define GPIO_CAN0_RX_4         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_9|GPIO_CFG_PORT_I|GPIO_CFG_PIN_9)
#define GPIO_CAN0_TX_1         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_9|GPIO_CFG_PORT_A|GPIO_CFG_PIN_12)
#define GPIO_CAN0_TX_2         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_9|GPIO_CFG_PORT_B|GPIO_CFG_PIN_9)
#define GPIO_CAN0_TX_3         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_9|GPIO_CFG_PORT_D|GPIO_CFG_PIN_1)
#define GPIO_CAN0_TX_4         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_9|GPIO_CFG_PORT_H|GPIO_CFG_PIN_13)

#define GPIO_CAN1_RX_1         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_9|GPIO_CFG_PORT_B|GPIO_CFG_PIN_12)
#define GPIO_CAN1_RX_2         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_9|GPIO_CFG_PORT_B|GPIO_CFG_PIN_5)
#define GPIO_CAN1_TX_1         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_9|GPIO_CFG_PORT_B|GPIO_CFG_PIN_13)
#define GPIO_CAN1_TX_2         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_9|GPIO_CFG_PORT_B|GPIO_CFG_PIN_6)

/* Clock output */

#define GPIO_CKOUT0            (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_0|GPIO_CFG_PORT_A|GPIO_CFG_PIN_8)
#define GPIO_CKOUT1            (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_0|GPIO_CFG_PORT_C|GPIO_CFG_PIN_9)

/* Digital-to-analog converter (DAC) */

#define GPIO_DAC_OUT1          (GPIO_CFG_MODE_ANALOG|GPIO_CFG_PUPD_NONE|GPIO_CFG_PORT_A|GPIO_CFG_PIN_4)
#define GPIO_DAC_OUT2          (GPIO_CFG_MODE_ANALOG|GPIO_CFG_PUPD_NONE|GPIO_CFG_PORT_A|GPIO_CFG_PIN_5)

/* Digital camera interface (DCI) */

#define GPIO_DCI_D0_1          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_13|GPIO_CFG_PORT_A|GPIO_CFG_PIN_9)
#define GPIO_DCI_D0_2          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_13|GPIO_CFG_PORT_C|GPIO_CFG_PIN_6)
#define GPIO_DCI_D0_3          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_13|GPIO_CFG_PORT_H|GPIO_CFG_PIN_9)
#define GPIO_DCI_D1_1          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_13|GPIO_CFG_PORT_A|GPIO_CFG_PIN_10)
#define GPIO_DCI_D1_2          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_13|GPIO_CFG_PORT_C|GPIO_CFG_PIN_7)
#define GPIO_DCI_D1_3          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_13|GPIO_CFG_PORT_H|GPIO_CFG_PIN_10)
#define GPIO_DCI_D2_1          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_13|GPIO_CFG_PORT_C|GPIO_CFG_PIN_8)
#define GPIO_DCI_D2_2          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_13|GPIO_CFG_PORT_E|GPIO_CFG_PIN_0)
#define GPIO_DCI_D2_3          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_13|GPIO_CFG_PORT_G|GPIO_CFG_PIN_10)
#define GPIO_DCI_D2_4          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_13|GPIO_CFG_PORT_H|GPIO_CFG_PIN_11)
#define GPIO_DCI_D3_1          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_13|GPIO_CFG_PORT_C|GPIO_CFG_PIN_9)
#define GPIO_DCI_D3_2          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_13|GPIO_CFG_PORT_E|GPIO_CFG_PIN_1)
#define GPIO_DCI_D3_3          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_13|GPIO_CFG_PORT_G|GPIO_CFG_PIN_11)
#define GPIO_DCI_D3_4          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_13|GPIO_CFG_PORT_H|GPIO_CFG_PIN_12)
#define GPIO_DCI_D4_1          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_13|GPIO_CFG_PORT_C|GPIO_CFG_PIN_11)
#define GPIO_DCI_D4_2          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_13|GPIO_CFG_PORT_E|GPIO_CFG_PIN_4)
#define GPIO_DCI_D4_3          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_13|GPIO_CFG_PORT_H|GPIO_CFG_PIN_14)
#define GPIO_DCI_D5_1          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_13|GPIO_CFG_PORT_B|GPIO_CFG_PIN_6)
#define GPIO_DCI_D5_2          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_13|GPIO_CFG_PORT_D|GPIO_CFG_PIN_3)
#define GPIO_DCI_D5_3          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_13|GPIO_CFG_PORT_I|GPIO_CFG_PIN_4)
#define GPIO_DCI_D6_1          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_13|GPIO_CFG_PORT_B|GPIO_CFG_PIN_8)
#define GPIO_DCI_D6_2          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_13|GPIO_CFG_PORT_E|GPIO_CFG_PIN_5)
#define GPIO_DCI_D6_3          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_13|GPIO_CFG_PORT_I|GPIO_CFG_PIN_6)
#define GPIO_DCI_D7_1          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_13|GPIO_CFG_PORT_B|GPIO_CFG_PIN_9)
#define GPIO_DCI_D7_2          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_13|GPIO_CFG_PORT_E|GPIO_CFG_PIN_6)
#define GPIO_DCI_D7_3          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_13|GPIO_CFG_PORT_I|GPIO_CFG_PIN_7)
#define GPIO_DCI_D8_1          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_13|GPIO_CFG_PORT_C|GPIO_CFG_PIN_10)
#define GPIO_DCI_D8_2          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_13|GPIO_CFG_PORT_H|GPIO_CFG_PIN_6)
#define GPIO_DCI_D8_3          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_13|GPIO_CFG_PORT_I|GPIO_CFG_PIN_1)
#define GPIO_DCI_D9_1          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_13|GPIO_CFG_PORT_C|GPIO_CFG_PIN_12)
#define GPIO_DCI_D9_2          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_13|GPIO_CFG_PORT_H|GPIO_CFG_PIN_7)
#define GPIO_DCI_D9_3          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_13|GPIO_CFG_PORT_I|GPIO_CFG_PIN_2)
#define GPIO_DCI_D10_1         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_13|GPIO_CFG_PORT_B|GPIO_CFG_PIN_5)
#define GPIO_DCI_D10_2         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_13|GPIO_CFG_PORT_D|GPIO_CFG_PIN_6)
#define GPIO_DCI_D10_3         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_13|GPIO_CFG_PORT_I|GPIO_CFG_PIN_3)
#define GPIO_DCI_D11_1         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_13|GPIO_CFG_PORT_D|GPIO_CFG_PIN_2)
#define GPIO_DCI_D11_2         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_13|GPIO_CFG_PORT_F|GPIO_CFG_PIN_10)
#define GPIO_DCI_D11_3         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_13|GPIO_CFG_PORT_H|GPIO_CFG_PIN_15)
#define GPIO_DCI_D12_1         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_13|GPIO_CFG_PORT_F|GPIO_CFG_PIN_11)
#define GPIO_DCI_D12_2         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_13|GPIO_CFG_PORT_G|GPIO_CFG_PIN_6)
#define GPIO_DCI_D13_1         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_13|GPIO_CFG_PORT_G|GPIO_CFG_PIN_7)
#define GPIO_DCI_D13_2         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_13|GPIO_CFG_PORT_G|GPIO_CFG_PIN_15)
#define GPIO_DCI_D13_3         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_13|GPIO_CFG_PORT_I|GPIO_CFG_PIN_0)
#define GPIO_DCI_HSYNC_1       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_13|GPIO_CFG_PORT_A|GPIO_CFG_PIN_4)
#define GPIO_DCI_HSYNC_2       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_13|GPIO_CFG_PORT_H|GPIO_CFG_PIN_8)
#define GPIO_DCI_PIXCLK        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_13|GPIO_CFG_PORT_A|GPIO_CFG_PIN_6)
#define GPIO_DCI_VSYNC_1       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_13|GPIO_CFG_PORT_B|GPIO_CFG_PIN_7)
#define GPIO_DCI_VSYNC_2       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_13|GPIO_CFG_PORT_G|GPIO_CFG_PIN_9)
#define GPIO_DCI_VSYNC_3       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_13|GPIO_CFG_PORT_I|GPIO_CFG_PIN_5)

/* ENET MAC */

#define GPIO_ENET_MDC            (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_11|GPIO_CFG_PORT_C|GPIO_CFG_PIN_1)
#define GPIO_ENET_MDIO           (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_11|GPIO_CFG_PORT_A|GPIO_CFG_PIN_2)
#define GPIO_ENET_MII_COL_1      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_11|GPIO_CFG_PORT_A|GPIO_CFG_PIN_3)
#define GPIO_ENET_MII_COL_2      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_11|GPIO_CFG_PORT_H|GPIO_CFG_PIN_3)
#define GPIO_ENET_MII_CRS_1      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_11|GPIO_CFG_PORT_A|GPIO_CFG_PIN_0)
#define GPIO_ENET_MII_CRS_2      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_11|GPIO_CFG_PORT_H|GPIO_CFG_PIN_2)
#define GPIO_ENET_MII_RXD0       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_11|GPIO_CFG_PORT_C|GPIO_CFG_PIN_4)
#define GPIO_ENET_MII_RXD1       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_11|GPIO_CFG_PORT_C|GPIO_CFG_PIN_5)
#define GPIO_ENET_MII_RXD2_1     (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_11|GPIO_CFG_PORT_B|GPIO_CFG_PIN_0)
#define GPIO_ENET_MII_RXD2_2     (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_11|GPIO_CFG_PORT_H|GPIO_CFG_PIN_6)
#define GPIO_ENET_MII_RXD3_1     (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_11|GPIO_CFG_PORT_B|GPIO_CFG_PIN_1)
#define GPIO_ENET_MII_RXD3_2     (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_11|GPIO_CFG_PORT_H|GPIO_CFG_PIN_7)
#define GPIO_ENET_MII_RX_CLK     (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_11|GPIO_CFG_PORT_A|GPIO_CFG_PIN_1)
#define GPIO_ENET_MII_RX_DV      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_11|GPIO_CFG_PORT_A|GPIO_CFG_PIN_7)
#define GPIO_ENET_MII_RX_ER_1    (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_11|GPIO_CFG_PORT_B|GPIO_CFG_PIN_10)
#define GPIO_ENET_MII_RX_ER_2    (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_11|GPIO_CFG_PORT_I|GPIO_CFG_PIN_10)
#define GPIO_ENET_MII_TXD0_1     (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_11|GPIO_CFG_PORT_B|GPIO_CFG_PIN_12)
#define GPIO_ENET_MII_TXD0_2     (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_11|GPIO_CFG_PORT_G|GPIO_CFG_PIN_13)
#define GPIO_ENET_MII_TXD1_1     (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_11|GPIO_CFG_PORT_B|GPIO_CFG_PIN_13)
#define GPIO_ENET_MII_TXD1_2     (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_11|GPIO_CFG_PORT_G|GPIO_CFG_PIN_14)
#define GPIO_ENET_MII_TXD2       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_11|GPIO_CFG_PORT_C|GPIO_CFG_PIN_2)
#define GPIO_ENET_MII_TXD3_1     (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_11|GPIO_CFG_PORT_B|GPIO_CFG_PIN_8)
#define GPIO_ENET_MII_TXD3_2     (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_11|GPIO_CFG_PORT_E|GPIO_CFG_PIN_2)
#define GPIO_ENET_MII_TX_CLK     (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_11|GPIO_CFG_PORT_C|GPIO_CFG_PIN_3)
#define GPIO_ENET_MII_TX_EN_1    (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_11|GPIO_CFG_PORT_B|GPIO_CFG_PIN_11)
#define GPIO_ENET_MII_TX_EN_2    (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_11|GPIO_CFG_PORT_G|GPIO_CFG_PIN_11)
#define GPIO_ENET_PPS_OUT_1      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_11|GPIO_CFG_PORT_B|GPIO_CFG_PIN_5)
#define GPIO_ENET_PPS_OUT_2      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_11|GPIO_CFG_PORT_G|GPIO_CFG_PIN_8)
#define GPIO_ENET_RMII_CRS_DV    (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_11|GPIO_CFG_PORT_A|GPIO_CFG_PIN_7)
#define GPIO_ENET_RMII_REF_CLK   (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_11|GPIO_CFG_PORT_A|GPIO_CFG_PIN_1)
#define GPIO_ENET_RMII_RXD0      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_11|GPIO_CFG_PORT_C|GPIO_CFG_PIN_4)
#define GPIO_ENET_RMII_RXD1      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_11|GPIO_CFG_PORT_C|GPIO_CFG_PIN_5)
#define GPIO_ENET_RMII_TXD0_1    (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_11|GPIO_CFG_PORT_B|GPIO_CFG_PIN_12)
#define GPIO_ENET_RMII_TXD0_2    (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_11|GPIO_CFG_PORT_G|GPIO_CFG_PIN_13)
#define GPIO_ENET_RMII_TXD1_1    (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_11|GPIO_CFG_PORT_B|GPIO_CFG_PIN_13)
#define GPIO_ENET_RMII_TXD1_2    (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_11|GPIO_CFG_PORT_G|GPIO_CFG_PIN_14)
#define GPIO_ENET_RMII_TX_EN_1   (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_11|GPIO_CFG_PORT_B|GPIO_CFG_PIN_11)
#define GPIO_ENET_RMII_TX_EN_2   (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_11|GPIO_CFG_PORT_G|GPIO_CFG_PIN_11)

/* External memory controller (EXMC) */

#define GPIO_EXMC_A0           (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_F|GPIO_CFG_PIN_0)
#define GPIO_EXMC_A1           (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_F|GPIO_CFG_PIN_1)
#define GPIO_EXMC_A2           (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_F|GPIO_CFG_PIN_2)
#define GPIO_EXMC_A3           (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_F|GPIO_CFG_PIN_3)
#define GPIO_EXMC_A4           (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_F|GPIO_CFG_PIN_4)
#define GPIO_EXMC_A5           (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_F|GPIO_CFG_PIN_5)
#define GPIO_EXMC_A6           (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_F|GPIO_CFG_PIN_12)
#define GPIO_EXMC_A7           (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_F|GPIO_CFG_PIN_13)
#define GPIO_EXMC_A8           (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_F|GPIO_CFG_PIN_14)
#define GPIO_EXMC_A9           (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_F|GPIO_CFG_PIN_15)
#define GPIO_EXMC_A10          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_G|GPIO_CFG_PIN_0)
#define GPIO_EXMC_A11          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_G|GPIO_CFG_PIN_1)
#define GPIO_EXMC_A12          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_G|GPIO_CFG_PIN_2)
#define GPIO_EXMC_A13          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_G|GPIO_CFG_PIN_3)
#define GPIO_EXMC_A14          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_G|GPIO_CFG_PIN_4)
#define GPIO_EXMC_A15          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_G|GPIO_CFG_PIN_5)
#define GPIO_EXMC_A16          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_D|GPIO_CFG_PIN_11)
#define GPIO_EXMC_A17          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_D|GPIO_CFG_PIN_12)
#define GPIO_EXMC_A18          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_D|GPIO_CFG_PIN_13)
#define GPIO_EXMC_A19          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_E|GPIO_CFG_PIN_3)
#define GPIO_EXMC_A20          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_E|GPIO_CFG_PIN_4)
#define GPIO_EXMC_A21          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_E|GPIO_CFG_PIN_5)
#define GPIO_EXMC_A22          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_E|GPIO_CFG_PIN_6)
#define GPIO_EXMC_A23          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_E|GPIO_CFG_PIN_2)
#define GPIO_EXMC_A24          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_G|GPIO_CFG_PIN_13)
#define GPIO_EXMC_A25          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_G|GPIO_CFG_PIN_14)
#define GPIO_EXMC_CLK          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_D|GPIO_CFG_PIN_3)
#define GPIO_EXMC_CD           (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_F|GPIO_CFG_PIN_9)
#define GPIO_EXMC_D0           (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_D|GPIO_CFG_PIN_14)
#define GPIO_EXMC_D1           (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_D|GPIO_CFG_PIN_15)
#define GPIO_EXMC_D2           (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_D|GPIO_CFG_PIN_0)
#define GPIO_EXMC_D3           (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_D|GPIO_CFG_PIN_1)
#define GPIO_EXMC_D4           (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_E|GPIO_CFG_PIN_7)
#define GPIO_EXMC_D5           (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_E|GPIO_CFG_PIN_8)
#define GPIO_EXMC_D6           (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_E|GPIO_CFG_PIN_9)
#define GPIO_EXMC_D7           (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_E|GPIO_CFG_PIN_10)
#define GPIO_EXMC_D8           (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_E|GPIO_CFG_PIN_11)
#define GPIO_EXMC_D9           (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_E|GPIO_CFG_PIN_12)
#define GPIO_EXMC_D10          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_E|GPIO_CFG_PIN_13)
#define GPIO_EXMC_D11          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_E|GPIO_CFG_PIN_14)
#define GPIO_EXMC_D12          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_E|GPIO_CFG_PIN_15)
#define GPIO_EXMC_D13          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_D|GPIO_CFG_PIN_8)
#define GPIO_EXMC_D14          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_D|GPIO_CFG_PIN_9)
#define GPIO_EXMC_D15          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_D|GPIO_CFG_PIN_10)
#define GPIO_EXMC_D16          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_H|GPIO_CFG_PIN_8)
#define GPIO_EXMC_D17          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_H|GPIO_CFG_PIN_9)
#define GPIO_EXMC_D18          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_H|GPIO_CFG_PIN_10)
#define GPIO_EXMC_D19          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_H|GPIO_CFG_PIN_11)
#define GPIO_EXMC_D20          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_H|GPIO_CFG_PIN_12)
#define GPIO_EXMC_D21          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_H|GPIO_CFG_PIN_13)
#define GPIO_EXMC_D22          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_H|GPIO_CFG_PIN_14)
#define GPIO_EXMC_D23          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_H|GPIO_CFG_PIN_15)
#define GPIO_EXMC_D24          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_I|GPIO_CFG_PIN_0)
#define GPIO_EXMC_D25          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_I|GPIO_CFG_PIN_1)
#define GPIO_EXMC_D26          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_I|GPIO_CFG_PIN_2)
#define GPIO_EXMC_D27          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_I|GPIO_CFG_PIN_3)
#define GPIO_EXMC_D28          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_I|GPIO_CFG_PIN_6)
#define GPIO_EXMC_D29          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_I|GPIO_CFG_PIN_7)
#define GPIO_EXMC_D30          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_I|GPIO_CFG_PIN_9)
#define GPIO_EXMC_D31          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_I|GPIO_CFG_PIN_10)
#define GPIO_EXMC_INT1         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_G|GPIO_CFG_PIN_6)
#define GPIO_EXMC_INT2         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_G|GPIO_CFG_PIN_7)
#define GPIO_EXMC_INTR         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_F|GPIO_CFG_PIN_10)
#define GPIO_EXMC_NBL0         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_E|GPIO_CFG_PIN_0)
#define GPIO_EXMC_NBL1         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_E|GPIO_CFG_PIN_1)
#define GPIO_EXMC_NBL2         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_I|GPIO_CFG_PIN_4)
#define GPIO_EXMC_NBL3         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_I|GPIO_CFG_PIN_5)
#define GPIO_EXMC_NCE1         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_D|GPIO_CFG_PIN_7)
#define GPIO_EXMC_NCE2         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_G|GPIO_CFG_PIN_9)
#define GPIO_EXMC_NCE3_0       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_G|GPIO_CFG_PIN_10)
#define GPIO_EXMC_NCE3_1       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_G|GPIO_CFG_PIN_11)
#define GPIO_EXMC_NE0          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_D|GPIO_CFG_PIN_7)
#define GPIO_EXMC_NE1          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_G|GPIO_CFG_PIN_9)
#define GPIO_EXMC_NE2          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_G|GPIO_CFG_PIN_10)
#define GPIO_EXMC_NE3          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_G|GPIO_CFG_PIN_12)
#define GPIO_EXMC_NL           (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_B|GPIO_CFG_PIN_7)
#define GPIO_EXMC_NIORD        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_F|GPIO_CFG_PIN_6)
#define GPIO_EXMC_NIOWR        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_F|GPIO_CFG_PIN_8)
#define GPIO_EXMC_NOE          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_D|GPIO_CFG_PIN_4)
#define GPIO_EXMC_NREG         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_F|GPIO_CFG_PIN_7)
#define GPIO_EXMC_NWE          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_D|GPIO_CFG_PIN_5)
#define GPIO_EXMC_NWAIT        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_D|GPIO_CFG_PIN_6)
#define GPIO_EXMC_SDCKE0_1     (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_C|GPIO_CFG_PIN_3)
#define GPIO_EXMC_SDCKE0_2     (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_C|GPIO_CFG_PIN_5)
#define GPIO_EXMC_SDCKE0_3     (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_H|GPIO_CFG_PIN_2)
#define GPIO_EXMC_SDCKE1_1     (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_B|GPIO_CFG_PIN_5)
#define GPIO_EXMC_SDCKE1_2     (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_H|GPIO_CFG_PIN_7)
#define GPIO_EXMC_SDCLK        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_G|GPIO_CFG_PIN_8)
#define GPIO_EXMC_SDNCAS       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_G|GPIO_CFG_PIN_15)
#define GPIO_EXMC_SDNE0_1      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_C|GPIO_CFG_PIN_2)
#define GPIO_EXMC_SDNE0_2      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_C|GPIO_CFG_PIN_4)
#define GPIO_EXMC_SDNE0_3      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_H|GPIO_CFG_PIN_3)
#define GPIO_EXMC_SDNE1_1      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_B|GPIO_CFG_PIN_6)
#define GPIO_EXMC_SDNE1_2      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_H|GPIO_CFG_PIN_6)
#define GPIO_EXMC_SDNRAS       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_F|GPIO_CFG_PIN_11)
#define GPIO_EXMC_SDNWE_1      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_A|GPIO_CFG_PIN_7)
#define GPIO_EXMC_SDNWE_2      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_C|GPIO_CFG_PIN_0)
#define GPIO_EXMC_SDNWE_3      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_H|GPIO_CFG_PIN_5)

/* Inter-integrated circuit interface (I2C) */

#define GPIO_I2C0_SCL_1        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_OD|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_4|GPIO_CFG_PORT_B|GPIO_CFG_PIN_6)
#define GPIO_I2C0_SCL_2        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_OD|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_4|GPIO_CFG_PORT_B|GPIO_CFG_PIN_8)
#define GPIO_I2C0_SDA_1        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_OD|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_4|GPIO_CFG_PORT_B|GPIO_CFG_PIN_7)
#define GPIO_I2C0_SDA_2        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_OD|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_4|GPIO_CFG_PORT_B|GPIO_CFG_PIN_9)
#define GPIO_I2C0_SMBA         (GPIO_CFG_MODE_AF|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_4|GPIO_CFG_PORT_B|GPIO_CFG_PIN_5)
#define GPIO_I2C0_TXFRAME      (GPIO_CFG_MODE_AF|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_4|GPIO_CFG_PORT_B|GPIO_CFG_PIN_4)

#define GPIO_I2C1_SCL_1        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_OD|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_4|GPIO_CFG_PORT_B|GPIO_CFG_PIN_10)
#define GPIO_I2C1_SCL_2        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_OD|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_4|GPIO_CFG_PORT_F|GPIO_CFG_PIN_1)
#define GPIO_I2C1_SCL_3        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_OD|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_4|GPIO_CFG_PORT_H|GPIO_CFG_PIN_4)
#define GPIO_I2C1_SDA_1        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_OD|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_9|GPIO_CFG_PORT_B|GPIO_CFG_PIN_3)
#define GPIO_I2C1_SDA_2        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_OD|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_4|GPIO_CFG_PORT_B|GPIO_CFG_PIN_11)
#define GPIO_I2C1_SDA_3        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_OD|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_4|GPIO_CFG_PORT_C|GPIO_CFG_PIN_12)
#define GPIO_I2C1_SDA_4        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_OD|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_4|GPIO_CFG_PORT_F|GPIO_CFG_PIN_0)
#define GPIO_I2C1_SDA_5        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_OD|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_4|GPIO_CFG_PORT_H|GPIO_CFG_PIN_5)
#define GPIO_I2C1_SMBA_1       (GPIO_CFG_MODE_AF|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_4|GPIO_CFG_PORT_B|GPIO_CFG_PIN_12)
#define GPIO_I2C1_SMBA_2       (GPIO_CFG_MODE_AF|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_4|GPIO_CFG_PORT_F|GPIO_CFG_PIN_2)
#define GPIO_I2C1_SMBA_3       (GPIO_CFG_MODE_AF|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_4|GPIO_CFG_PORT_H|GPIO_CFG_PIN_6)
#define GPIO_I2C1_TXFRAME_1    (GPIO_CFG_MODE_AF|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_4|GPIO_CFG_PORT_B|GPIO_CFG_PIN_13)
#define GPIO_I2C1_TXFRAME_2    (GPIO_CFG_MODE_AF|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_4|GPIO_CFG_PORT_F|GPIO_CFG_PIN_3)
#define GPIO_I2C1_TXFRAME_3    (GPIO_CFG_MODE_AF|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_4|GPIO_CFG_PORT_H|GPIO_CFG_PIN_3)

#define GPIO_I2C2_SCL_1        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_OD|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_4|GPIO_CFG_PORT_A|GPIO_CFG_PIN_8)
#define GPIO_I2C2_SCL_2        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_OD|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_4|GPIO_CFG_PORT_H|GPIO_CFG_PIN_7)
#define GPIO_I2C2_SDA_1        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_OD|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_9|GPIO_CFG_PORT_B|GPIO_CFG_PIN_4)
#define GPIO_I2C2_SDA_2        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_OD|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_4|GPIO_CFG_PORT_C|GPIO_CFG_PIN_9)
#define GPIO_I2C2_SDA_3        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_OD|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_4|GPIO_CFG_PORT_H|GPIO_CFG_PIN_8)
#define GPIO_I2C2_SMBA_1       (GPIO_CFG_MODE_AF|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_4|GPIO_CFG_PORT_A|GPIO_CFG_PIN_9)
#define GPIO_I2C2_SMBA_2       (GPIO_CFG_MODE_AF|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_4|GPIO_CFG_PORT_H|GPIO_CFG_PIN_9)
#define GPIO_I2C2_TXFRAME_1    (GPIO_CFG_MODE_AF|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_4|GPIO_CFG_PORT_A|GPIO_CFG_PIN_10)
#define GPIO_I2C2_TXFRAME_2    (GPIO_CFG_MODE_AF|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_4|GPIO_CFG_PORT_H|GPIO_CFG_PIN_10)

/* JTAG, SWD */

#define GPIO_JTCK              (GPIO_CFG_MODE_AF|GPIO_CFG_AF_0|GPIO_CFG_PORT_A|GPIO_CFG_PIN_14)
#define GPIO_JTDI              (GPIO_CFG_MODE_AF|GPIO_CFG_AF_0|GPIO_CFG_PORT_A|GPIO_CFG_PIN_15)
#define GPIO_JTDO              (GPIO_CFG_MODE_AF|GPIO_CFG_AF_0|GPIO_CFG_PORT_B|GPIO_CFG_PIN_3)
#define GPIO_JTMS              (GPIO_CFG_MODE_AF|GPIO_CFG_AF_0|GPIO_CFG_PORT_A|GPIO_CFG_PIN_13)
#define GPIO_NJTRST            (GPIO_CFG_MODE_AF|GPIO_CFG_AF_0|GPIO_CFG_PORT_B|GPIO_CFG_PIN_4)

#define GPIO_SWCLK             (GPIO_CFG_MODE_AF|GPIO_CFG_AF_0|GPIO_CFG_PORT_A|GPIO_CFG_PIN_14)
#define GPIO_SSWDIO            (GPIO_CFG_MODE_AF|GPIO_CFG_AF_0|GPIO_CFG_PORT_A|GPIO_CFG_PIN_13)

/* RTC */

#define GPIO_RTC_REFIN         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_0|GPIO_CFG_PORT_C|GPIO_CFG_PIN_15)

/* Secure digital input/output interface (SDIO) */

#define GPIO_SDIO_CMD_1        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_25MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_A|GPIO_CFG_PIN_6)
#define GPIO_SDIO_CMD_2        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_25MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_D|GPIO_CFG_PIN_2)
#define GPIO_SDIO_CK_1         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_25MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_B|GPIO_CFG_PIN_2)
#define GPIO_SDIO_CK_2         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_25MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_C|GPIO_CFG_PIN_12)
#define GPIO_SDIO_D0_1         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_25MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_B|GPIO_CFG_PIN_4)
#define GPIO_SDIO_D0_2         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_25MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_C|GPIO_CFG_PIN_8)
#define GPIO_SDIO_D1_1         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_25MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_A|GPIO_CFG_PIN_8)
#define GPIO_SDIO_D1_2         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_25MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_B|GPIO_CFG_PIN_0)
#define GPIO_SDIO_D1_3         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_25MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_C|GPIO_CFG_PIN_9)
#define GPIO_SDIO_D2_1         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_25MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_A|GPIO_CFG_PIN_9)
#define GPIO_SDIO_D2_2         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_25MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_B|GPIO_CFG_PIN_1)
#define GPIO_SDIO_D2_3         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_25MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_C|GPIO_CFG_PIN_10)
#define GPIO_SDIO_D3           (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_25MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_C|GPIO_CFG_PIN_11)
#define GPIO_SDIO_D4           (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_25MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_B|GPIO_CFG_PIN_8)
#define GPIO_SDIO_D5           (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_25MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_B|GPIO_CFG_PIN_9)
#define GPIO_SDIO_D6           (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_25MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_C|GPIO_CFG_PIN_6)
#define GPIO_SDIO_D7           (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_25MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_C|GPIO_CFG_PIN_7)

/* Serial peripheral interface/Inter-IC sound (SPI/I2S) */

/* I2S */

#define GPIO_I2S1_ADD_SD_1     (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_25MHZ|GPIO_CFG_AF_6|GPIO_CFG_PORT_B|GPIO_CFG_PIN_14)
#define GPIO_I2S1_ADD_SD_2     (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_25MHZ|GPIO_CFG_AF_6|GPIO_CFG_PORT_C|GPIO_CFG_PIN_2)
#define GPIO_I2S1_ADD_SD_3     (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_25MHZ|GPIO_CFG_AF_6|GPIO_CFG_PORT_I|GPIO_CFG_PIN_2)
#define GPIO_I2S1_CK_1         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_25MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_A|GPIO_CFG_PIN_9)
#define GPIO_I2S1_CK_2         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_25MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_B|GPIO_CFG_PIN_10)
#define GPIO_I2S1_CK_3         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_25MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_B|GPIO_CFG_PIN_13)
#define GPIO_I2S1_CK_4         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_25MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_C|GPIO_CFG_PIN_7)
#define GPIO_I2S1_CK_5         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_25MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_D|GPIO_CFG_PIN_3)
#define GPIO_I2S1_CK_6         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_25MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_I|GPIO_CFG_PIN_1)
#define GPIO_I2S1_MCK_1        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_25MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_A|GPIO_CFG_PIN_3)
#define GPIO_I2S1_MCK_2        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_25MHZ|GPIO_CFG_AF_6|GPIO_CFG_PORT_A|GPIO_CFG_PIN_6)
#define GPIO_I2S1_MCK_3        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_25MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_C|GPIO_CFG_PIN_6)
#define GPIO_I2S1_SD_1         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_25MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_B|GPIO_CFG_PIN_15)
#define GPIO_I2S1_SD_2         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_25MHZ|GPIO_CFG_AF_7|GPIO_CFG_PORT_C|GPIO_CFG_PIN_1)
#define GPIO_I2S1_SD_3         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_25MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_C|GPIO_CFG_PIN_3)
#define GPIO_I2S1_SD_4         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_25MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_I|GPIO_CFG_PIN_3)
#define GPIO_I2S1_WS_1         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_25MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_B|GPIO_CFG_PIN_9)
#define GPIO_I2S1_WS_2         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_25MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_B|GPIO_CFG_PIN_12)
#define GPIO_I2S1_WS_3         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_25MHZ|GPIO_CFG_AF_7|GPIO_CFG_PORT_D|GPIO_CFG_PIN_1)
#define GPIO_I2S1_WS_4         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_25MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_I|GPIO_CFG_PIN_0)

#define GPIO_I2S2_ADD_SD_1     (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_25MHZ|GPIO_CFG_AF_7|GPIO_CFG_PORT_B|GPIO_CFG_PIN_4)
#define GPIO_I2S2_ADD_SD_2     (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_25MHZ|GPIO_CFG_AF_6|GPIO_CFG_PORT_C|GPIO_CFG_PIN_11)
#define GPIO_I2S2_CK_1         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_25MHZ|GPIO_CFG_AF_6|GPIO_CFG_PORT_B|GPIO_CFG_PIN_3)
#define GPIO_I2S2_CK_2         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_25MHZ|GPIO_CFG_AF_6|GPIO_CFG_PORT_C|GPIO_CFG_PIN_10)
#define GPIO_I2S2_MCK_1        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_25MHZ|GPIO_CFG_AF_6|GPIO_CFG_PORT_B|GPIO_CFG_PIN_10)
#define GPIO_I2S2_MCK_2        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_25MHZ|GPIO_CFG_AF_6|GPIO_CFG_PORT_C|GPIO_CFG_PIN_7)
#define GPIO_I2S2_SD_1         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_25MHZ|GPIO_CFG_AF_7|GPIO_CFG_PORT_B|GPIO_CFG_PIN_0)
#define GPIO_I2S2_SD_2         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_25MHZ|GPIO_CFG_AF_7|GPIO_CFG_PORT_B|GPIO_CFG_PIN_2)
#define GPIO_I2S2_SD_3         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_25MHZ|GPIO_CFG_AF_6|GPIO_CFG_PORT_B|GPIO_CFG_PIN_5)
#define GPIO_I2S2_SD_4         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_25MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_C|GPIO_CFG_PIN_1)
#define GPIO_I2S2_SD_5         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_25MHZ|GPIO_CFG_AF_6|GPIO_CFG_PORT_C|GPIO_CFG_PIN_12)
#define GPIO_I2S2_SD_6         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_25MHZ|GPIO_CFG_AF_6|GPIO_CFG_PORT_D|GPIO_CFG_PIN_0)
#define GPIO_I2S2_SD_7         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_25MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_D|GPIO_CFG_PIN_6)
#define GPIO_I2S2_WS_1         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_25MHZ|GPIO_CFG_AF_6|GPIO_CFG_PORT_A|GPIO_CFG_PIN_4)
#define GPIO_I2S2_WS_2         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_25MHZ|GPIO_CFG_AF_6|GPIO_CFG_PORT_A|GPIO_CFG_PIN_15)

#define GPIO_I2S_CKIN_1        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_25MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_A|GPIO_CFG_PIN_2)
#define GPIO_I2S_CKIN_2        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_25MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_B|GPIO_CFG_PIN_11)
#define GPIO_I2S_CKIN_3        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_25MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_C|GPIO_CFG_PIN_9)

/* SPI */
#define GPIO_SPI0_MISO_1       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_A|GPIO_CFG_PIN_6)
#define GPIO_SPI0_MISO_2       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_B|GPIO_CFG_PIN_4)
#define GPIO_SPI0_MOSI_1       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_A|GPIO_CFG_PIN_7)
#define GPIO_SPI0_MOSI_2       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_B|GPIO_CFG_PIN_5)
#define GPIO_SPI0_NSS_1        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_A|GPIO_CFG_PIN_4)
#define GPIO_SPI0_NSS_2        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_A|GPIO_CFG_PIN_15)
#define GPIO_SPI0_SCK_1        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_A|GPIO_CFG_PIN_5)
#define GPIO_SPI0_SCK_2        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_B|GPIO_CFG_PIN_3)

#define GPIO_SPI1_MISO_1       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_B|GPIO_CFG_PIN_14)
#define GPIO_SPI1_MISO_2       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_C|GPIO_CFG_PIN_2)
#define GPIO_SPI1_MISO_3       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_I|GPIO_CFG_PIN_2)
#define GPIO_SPI1_MOSI_1       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_B|GPIO_CFG_PIN_15)
#define GPIO_SPI1_MOSI_2       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_C|GPIO_CFG_PIN_1)
#define GPIO_SPI1_MOSI_3       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_C|GPIO_CFG_PIN_3)
#define GPIO_SPI1_MOSI_4       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_I|GPIO_CFG_PIN_3)
#define GPIO_SPI1_NSS_1        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_B|GPIO_CFG_PIN_9)
#define GPIO_SPI1_NSS_2        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_B|GPIO_CFG_PIN_12)
#define GPIO_SPI1_NSS_3        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_7|GPIO_CFG_PORT_D|GPIO_CFG_PIN_1)
#define GPIO_SPI1_NSS_4        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_I|GPIO_CFG_PIN_0)
#define GPIO_SPI1_SCK_1        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_A|GPIO_CFG_PIN_9)
#define GPIO_SPI1_SCK_2        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_B|GPIO_CFG_PIN_10)
#define GPIO_SPI1_SCK_3        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_B|GPIO_CFG_PIN_13)
#define GPIO_SPI1_SCK_4        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_C|GPIO_CFG_PIN_7)
#define GPIO_SPI1_SCK_5        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_D|GPIO_CFG_PIN_3)
#define GPIO_SPI1_SCK_6        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_I|GPIO_CFG_PIN_1)

#define GPIO_SPI2_MISO_1       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_6|GPIO_CFG_PORT_B|GPIO_CFG_PIN_4)
#define GPIO_SPI2_MISO_2       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_6|GPIO_CFG_PORT_C|GPIO_CFG_PIN_11)
#define GPIO_SPI2_MOSI_1       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_7|GPIO_CFG_PORT_B|GPIO_CFG_PIN_0)
#define GPIO_SPI2_MOSI_2       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_7|GPIO_CFG_PORT_B|GPIO_CFG_PIN_2)
#define GPIO_SPI2_MOSI_3       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_6|GPIO_CFG_PORT_B|GPIO_CFG_PIN_5)
#define GPIO_SPI2_MOSI_4       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_C|GPIO_CFG_PIN_1)
#define GPIO_SPI2_MOSI_5       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_6|GPIO_CFG_PORT_C|GPIO_CFG_PIN_12)
#define GPIO_SPI2_MOSI_6       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_6|GPIO_CFG_PORT_D|GPIO_CFG_PIN_0)
#define GPIO_SPI2_MOSI_7       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_D|GPIO_CFG_PIN_6)
#define GPIO_SPI2_NSS_1        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_6|GPIO_CFG_PORT_A|GPIO_CFG_PIN_4)
#define GPIO_SPI2_NSS_2        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_6|GPIO_CFG_PORT_A|GPIO_CFG_PIN_15)
#define GPIO_SPI2_SCK_1        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_6|GPIO_CFG_PORT_B|GPIO_CFG_PIN_3)
#define GPIO_SPI2_SCK_2        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_6|GPIO_CFG_PORT_C|GPIO_CFG_PIN_10)

#define GPIO_SPI3_MISO_1       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_6|GPIO_CFG_PORT_A|GPIO_CFG_PIN_11)
#define GPIO_SPI3_MISO_2       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_D|GPIO_CFG_PIN_0)
#define GPIO_SPI3_MISO_3       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_E|GPIO_CFG_PIN_5)
#define GPIO_SPI3_MISO_4       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_E|GPIO_CFG_PIN_13)
#define GPIO_SPI3_MISO_5       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_6|GPIO_CFG_PORT_G|GPIO_CFG_PIN_12)
#define GPIO_SPI3_MOSI_1       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_A|GPIO_CFG_PIN_1)
#define GPIO_SPI3_MOSI_2       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_E|GPIO_CFG_PIN_6)
#define GPIO_SPI3_MOSI_3       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_E|GPIO_CFG_PIN_14)
#define GPIO_SPI3_MOSI_4       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_6|GPIO_CFG_PORT_G|GPIO_CFG_PIN_13)
#define GPIO_SPI3_NSS_1        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_6|GPIO_CFG_PORT_B|GPIO_CFG_PIN_12)
#define GPIO_SPI3_NSS_2        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_E|GPIO_CFG_PIN_4)
#define GPIO_SPI3_NSS_3        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_E|GPIO_CFG_PIN_11)
#define GPIO_SPI3_NSS_4        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_6|GPIO_CFG_PORT_G|GPIO_CFG_PIN_14)
#define GPIO_SPI3_SCK_1        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_6|GPIO_CFG_PORT_B|GPIO_CFG_PIN_13)
#define GPIO_SPI3_SCK_2        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_E|GPIO_CFG_PIN_2)
#define GPIO_SPI3_SCK_3        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_E|GPIO_CFG_PIN_12)
#define GPIO_SPI3_SCK_4        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_6|GPIO_CFG_PORT_G|GPIO_CFG_PIN_11)

#define GPIO_SPI4_MISO_1       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_6|GPIO_CFG_PORT_A|GPIO_CFG_PIN_12)
#define GPIO_SPI4_MISO_2       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_6|GPIO_CFG_PORT_E|GPIO_CFG_PIN_13)
#define GPIO_SPI4_MISO_3       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_F|GPIO_CFG_PIN_8)
#define GPIO_SPI4_MISO_4       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_H|GPIO_CFG_PIN_7)
#define GPIO_SPI4_MOSI_1       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_6|GPIO_CFG_PORT_A|GPIO_CFG_PIN_10)
#define GPIO_SPI4_MOSI_2       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_6|GPIO_CFG_PORT_B|GPIO_CFG_PIN_8)
#define GPIO_SPI4_MOSI_3       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_6|GPIO_CFG_PORT_E|GPIO_CFG_PIN_14)
#define GPIO_SPI4_MOSI_4       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_F|GPIO_CFG_PIN_9)
#define GPIO_SPI4_MOSI_5       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_F|GPIO_CFG_PIN_11)
#define GPIO_SPI4_NSS_1        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_6|GPIO_CFG_PORT_B|GPIO_CFG_PIN_1)
#define GPIO_SPI4_NSS_2        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_6|GPIO_CFG_PORT_E|GPIO_CFG_PIN_11)
#define GPIO_SPI4_NSS_3        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_F|GPIO_CFG_PIN_6)
#define GPIO_SPI4_NSS_4        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_H|GPIO_CFG_PIN_5)
#define GPIO_SPI4_SCK_1        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_6|GPIO_CFG_PORT_B|GPIO_CFG_PIN_0)
#define GPIO_SPI4_SCK_2        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_6|GPIO_CFG_PORT_E|GPIO_CFG_PIN_12)
#define GPIO_SPI4_SCK_3        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_F|GPIO_CFG_PIN_7)
#define GPIO_SPI4_SCK_4        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_H|GPIO_CFG_PIN_6)

#define GPIO_SPI5_MISO         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_G|GPIO_CFG_PIN_12)
#define GPIO_SPI5_MOSI         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_G|GPIO_CFG_PIN_14)
#define GPIO_SPI5_IO2          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_G|GPIO_CFG_PIN_10)
#define GPIO_SPI5_IO3          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_G|GPIO_CFG_PIN_11)
#define GPIO_SPI5_NSS          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_G|GPIO_CFG_PIN_8)
#define GPIO_SPI5_SCK          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_5|GPIO_CFG_PORT_G|GPIO_CFG_PIN_13)

/* TFT-LCD interface (TLI) */

#define GPIO_TLI_B0            (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_14|GPIO_CFG_PORT_E|GPIO_CFG_PIN_4)
#define GPIO_TLI_B1            (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_14|GPIO_CFG_PORT_G|GPIO_CFG_PIN_12)
#define GPIO_TLI_B2_1          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_14|GPIO_CFG_PORT_D|GPIO_CFG_PIN_6)
#define GPIO_TLI_B2_2          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_14|GPIO_CFG_PORT_G|GPIO_CFG_PIN_10)
#define GPIO_TLI_B3_1          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_14|GPIO_CFG_PORT_D|GPIO_CFG_PIN_10)
#define GPIO_TLI_B3_2          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_14|GPIO_CFG_PORT_G|GPIO_CFG_PIN_11)
#define GPIO_TLI_B4_1          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_14|GPIO_CFG_PORT_E|GPIO_CFG_PIN_12)
#define GPIO_TLI_B4_2          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_9|GPIO_CFG_PORT_G|GPIO_CFG_PIN_12)
#define GPIO_TLI_B4_3          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_14|GPIO_CFG_PORT_I|GPIO_CFG_PIN_4)
#define GPIO_TLI_B5_1          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_14|GPIO_CFG_PORT_A|GPIO_CFG_PIN_3)
#define GPIO_TLI_B5_2          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_14|GPIO_CFG_PORT_I|GPIO_CFG_PIN_5)
#define GPIO_TLI_B6_1          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_14|GPIO_CFG_PORT_B|GPIO_CFG_PIN_8)
#define GPIO_TLI_B6_2          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_14|GPIO_CFG_PORT_I|GPIO_CFG_PIN_6)
#define GPIO_TLI_B7_1          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_14|GPIO_CFG_PORT_B|GPIO_CFG_PIN_9)
#define GPIO_TLI_B7_2          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_14|GPIO_CFG_PORT_I|GPIO_CFG_PIN_7)

#define GPIO_TLI_G0            (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_14|GPIO_CFG_PORT_E|GPIO_CFG_PIN_5)
#define GPIO_TLI_G1            (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_14|GPIO_CFG_PORT_E|GPIO_CFG_PIN_6)
#define GPIO_TLI_G2_1          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_14|GPIO_CFG_PORT_A|GPIO_CFG_PIN_6)
#define GPIO_TLI_G2_2          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_14|GPIO_CFG_PORT_H|GPIO_CFG_PIN_13)
#define GPIO_TLI_G3_1          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_14|GPIO_CFG_PORT_E|GPIO_CFG_PIN_11)
#define GPIO_TLI_G3_2          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_9|GPIO_CFG_PORT_G|GPIO_CFG_PIN_10)
#define GPIO_TLI_G3_3          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_14|GPIO_PORTH|GPIO_CFG_PIN_14)
#define GPIO_TLI_G4_1          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_14|GPIO_CFG_PORT_B|GPIO_CFG_PIN_10)
#define GPIO_TLI_G4_2          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_14|GPIO_CFG_PORT_H|GPIO_CFG_PIN_15)
#define GPIO_TLI_G5_1          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_14|GPIO_CFG_PORT_B|GPIO_CFG_PIN_11)
#define GPIO_TLI_G5_2          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_14|GPIO_CFG_PORT_I|GPIO_CFG_PIN_0)
#define GPIO_TLI_G6_1          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_14|GPIO_CFG_PORT_C|GPIO_CFG_PIN_7)
#define GPIO_TLI_G6_2          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_14|GPIO_CFG_PORT_I|GPIO_CFG_PIN_1)
#define GPIO_TLI_G7_1          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_14|GPIO_CFG_PORT_D|GPIO_CFG_PIN_3)
#define GPIO_TLI_G7_2          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_14|GPIO_CFG_PORT_I|GPIO_CFG_PIN_2)

#define GPIO_TLI_R0            (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_14|GPIO_CFG_PORT_H|GPIO_CFG_PIN_2)
#define GPIO_TLI_R1            (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_14|GPIO_CFG_PORT_H|GPIO_CFG_PIN_3)
#define GPIO_TLI_R2_1          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_14|GPIO_CFG_PORT_C|GPIO_CFG_PIN_10)
#define GPIO_TLI_R2_2          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_14|GPIO_CFG_PORT_H|GPIO_CFG_PIN_8)
#define GPIO_TLI_R3_1          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_9|GPIO_CFG_PORT_B|GPIO_CFG_PIN_0)
#define GPIO_TLI_R3_2          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_14|GPIO_CFG_PORT_H|GPIO_CFG_PIN_9)
#define GPIO_TLI_R4_1          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_14|GPIO_CFG_PORT_A|GPIO_CFG_PIN_11)
#define GPIO_TLI_R4_2          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_14|GPIO_CFG_PORT_H|GPIO_CFG_PIN_10)
#define GPIO_TLI_R5_1          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_14|GPIO_CFG_PORT_A|GPIO_CFG_PIN_12)
#define GPIO_TLI_R5_2          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_14|GPIO_CFG_PORT_H|GPIO_CFG_PIN_11)
#define GPIO_TLI_R6_1          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_14|GPIO_CFG_PORT_A|GPIO_CFG_PIN_8)
#define GPIO_TLI_R6_2          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_9|GPIO_CFG_PORT_B|GPIO_CFG_PIN_1)
#define GPIO_TLI_R6_3          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_14|GPIO_CFG_PORT_H|GPIO_CFG_PIN_12)
#define GPIO_TLI_R7_1          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_14|GPIO_CFG_PORT_E|GPIO_CFG_PIN_15)
#define GPIO_TLI_R7_2          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_14|GPIO_CFG_PORT_G|GPIO_CFG_PIN_6)

#define GPIO_TLI_VSYNC_1       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_14|GPIO_CFG_PORT_A|GPIO_CFG_PIN_4)
#define GPIO_TLI_VSYNC_2       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_14|GPIO_CFG_PORT_I|GPIO_CFG_PIN_9)

#define GPIO_TLI_HSYNC_1       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_14|GPIO_CFG_PORT_C|GPIO_CFG_PIN_6)
#define GPIO_TLI_HSYNC_2       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_14|GPIO_CFG_PORT_I|GPIO_CFG_PIN_10)

#define GPIO_TLI_DE_1          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_14|GPIO_CFG_PORT_E|GPIO_CFG_PIN_13)
#define GPIO_TLI_DE_2          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_14|GPIO_CFG_PORT_F|GPIO_CFG_PIN_10)

#define GPIO_TLI_PIXCLK_1      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_14|GPIO_CFG_PORT_E|GPIO_CFG_PIN_14)
#define GPIO_TLI_PIXCLK_2      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_14|GPIO_CFG_PORT_G|GPIO_CFG_PIN_7)

/* TIMER */

/* Advanced timer (TIMERx, x=0, 7) */

#define GPIO_TIMER0_BRKIN_1    (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_1|GPIO_CFG_PORT_A|GPIO_CFG_PIN_6)
#define GPIO_TIMER0_BRKIN_2    (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_1|GPIO_CFG_PORT_B|GPIO_CFG_PIN_12)
#define GPIO_TIMER0_BRKIN_3    (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_1|GPIO_CFG_PORT_E|GPIO_CFG_PIN_15)
#define GPIO_TIMER0_CH0_1      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_1|GPIO_CFG_PORT_A|GPIO_CFG_PIN_8)
#define GPIO_TIMER0_CH0_2      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_1|GPIO_CFG_PORT_E|GPIO_CFG_PIN_9)
#define GPIO_TIMER0_CH0_ON_1   (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_1|GPIO_CFG_PORT_A|GPIO_CFG_PIN_7)
#define GPIO_TIMER0_CH0_ON_2   (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_1|GPIO_CFG_PORT_B|GPIO_CFG_PIN_13)
#define GPIO_TIMER0_CH0_ON_3   (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_1|GPIO_CFG_PORT_E|GPIO_CFG_PIN_8)
#define GPIO_TIMER0_CH1_1      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_1|GPIO_CFG_PORT_A|GPIO_CFG_PIN_9)
#define GPIO_TIMER0_CH1_2      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_1|GPIO_CFG_PORT_E|GPIO_CFG_PIN_11)
#define GPIO_TIMER0_CH1_ON_1   (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_1|GPIO_CFG_PORT_B|GPIO_CFG_PIN_0)
#define GPIO_TIMER0_CH1_ON_2   (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_1|GPIO_CFG_PORT_B|GPIO_CFG_PIN_14)
#define GPIO_TIMER0_CH1_ON_3   (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_1|GPIO_CFG_PORT_E|GPIO_CFG_PIN_1)
#define GPIO_TIMER0_CH1_ON_4   (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_1|GPIO_CFG_PORT_E|GPIO_CFG_PIN_10)
#define GPIO_TIMER0_CH2_1      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_1|GPIO_CFG_PORT_A|GPIO_CFG_PIN_10)
#define GPIO_TIMER0_CH2_2      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_1|GPIO_CFG_PORT_E|GPIO_CFG_PIN_13)
#define GPIO_TIMER0_CH2_ON_1   (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_1|GPIO_CFG_PORT_B|GPIO_CFG_PIN_1)
#define GPIO_TIMER0_CH2_ON_2   (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_1|GPIO_CFG_PORT_B|GPIO_CFG_PIN_15)
#define GPIO_TIMER0_CH2_ON_3   (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_1|GPIO_CFG_PORT_E|GPIO_CFG_PIN_12)
#define GPIO_TIMER0_CH3_1      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_1|GPIO_CFG_PORT_A|GPIO_CFG_PIN_11)
#define GPIO_TIMER0_CH3_2      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_1|GPIO_CFG_PORT_E|GPIO_CFG_PIN_14)
#define GPIO_TIMER0_ETI_1      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_1|GPIO_CFG_PORT_A|GPIO_CFG_PIN_12)
#define GPIO_TIMER0_ETI_2      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_1|GPIO_CFG_PORT_E|GPIO_CFG_PIN_7)

#define GPIO_TIMER7_BRKIN_1    (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_3|GPIO_CFG_PORT_A|GPIO_CFG_PIN_6)
#define GPIO_TIMER7_BRKIN_2    (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_3|GPIO_CFG_PORT_I|GPIO_CFG_PIN_4)
#define GPIO_TIMER7_CH0_1      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_3|GPIO_CFG_PORT_C|GPIO_CFG_PIN_6)
#define GPIO_TIMER7_CH0_2      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_3|GPIO_CFG_PORT_I|GPIO_CFG_PIN_5)
#define GPIO_TIMER7_CH0_ON_1   (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_3|GPIO_CFG_PORT_A|GPIO_CFG_PIN_5)
#define GPIO_TIMER7_CH0_ON_2   (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_3|GPIO_CFG_PORT_A|GPIO_CFG_PIN_7)
#define GPIO_TIMER7_CH0_ON_3   (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_3|GPIO_CFG_PORT_H|GPIO_CFG_PIN_13)
#define GPIO_TIMER7_CH1_1      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_3|GPIO_CFG_PORT_C|GPIO_CFG_PIN_7)
#define GPIO_TIMER7_CH1_2      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_3|GPIO_CFG_PORT_I|GPIO_CFG_PIN_6)
#define GPIO_TIMER7_CH1_ON_1   (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_3|GPIO_CFG_PORT_B|GPIO_CFG_PIN_0)
#define GPIO_TIMER7_CH1_ON_2   (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_3|GPIO_CFG_PORT_B|GPIO_CFG_PIN_14)
#define GPIO_TIMER7_CH1_ON_3   (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_3|GPIO_CFG_PORT_H|GPIO_CFG_PIN_14)
#define GPIO_TIMER7_CH2_1      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_3|GPIO_CFG_PORT_C|GPIO_CFG_PIN_8)
#define GPIO_TIMER7_CH2_2      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_3|GPIO_CFG_PORT_I|GPIO_CFG_PIN_7)
#define GPIO_TIMER7_CH2_ON_1   (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_3|GPIO_CFG_PORT_B|GPIO_CFG_PIN_1)
#define GPIO_TIMER7_CH2_ON_2   (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_3|GPIO_CFG_PORT_B|GPIO_CFG_PIN_15)
#define GPIO_TIMER7_CH2_ON_3   (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_3|GPIO_CFG_PORT_H|GPIO_CFG_PIN_15)
#define GPIO_TIMER7_CH3_1      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_3|GPIO_CFG_PORT_C|GPIO_CFG_PIN_9)
#define GPIO_TIMER7_CH3_2      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_3|GPIO_CFG_PORT_I|GPIO_CFG_PIN_2)
#define GPIO_TIMER7_ETI1       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_3|GPIO_CFG_PORT_A|GPIO_CFG_PIN_0)
#define GPIO_TIMER7_ETI_2      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_3|GPIO_CFG_PORT_I|GPIO_CFG_PIN_3)

/* General level0 timer (TIMERx, x=1, 2, 3, 4) */

#define GPIO_TIMER1_CH0_1      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_1|GPIO_CFG_PORT_A|GPIO_CFG_PIN_0)
#define GPIO_TIMER1_CH0_2      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_1|GPIO_CFG_PORT_A|GPIO_CFG_PIN_5)
#define GPIO_TIMER1_CH0_3      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_1|GPIO_CFG_PORT_A|GPIO_CFG_PIN_15)
#define GPIO_TIMER1_CH0_4      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_1|GPIO_CFG_PORT_B|GPIO_CFG_PIN_8)
#define GPIO_TIMER1_CH1_1      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_1|GPIO_CFG_PORT_A|GPIO_CFG_PIN_1)
#define GPIO_TIMER1_CH1_2      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_1|GPIO_CFG_PORT_B|GPIO_CFG_PIN_3)
#define GPIO_TIMER1_CH1_3      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_1|GPIO_CFG_PORT_B|GPIO_CFG_PIN_9)
#define GPIO_TIMER1_CH2_1      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_1|GPIO_CFG_PORT_A|GPIO_CFG_PIN_2)
#define GPIO_TIMER1_CH2_2      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_1|GPIO_CFG_PORT_B|GPIO_CFG_PIN_10)
#define GPIO_TIMER1_CH3_1      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_1|GPIO_CFG_PORT_A|GPIO_CFG_PIN_3)
#define GPIO_TIMER1_CH3_2      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_1|GPIO_CFG_PORT_B|GPIO_CFG_PIN_2)
#define GPIO_TIMER1_CH3_3      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_1|GPIO_CFG_PORT_B|GPIO_CFG_PIN_11)
#define GPIO_TIMER1_ETI_1      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_1|GPIO_CFG_PORT_A|GPIO_CFG_PIN_0)
#define GPIO_TIMER1_ETI_2      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_1|GPIO_CFG_PORT_A|GPIO_CFG_PIN_5)
#define GPIO_TIMER1_ETI_3      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_1|GPIO_CFG_PORT_A|GPIO_CFG_PIN_15)
#define GPIO_TIMER1_ETI_4      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_1|GPIO_CFG_PORT_B|GPIO_CFG_PIN_8)

#define GPIO_TIMER2_CH0_1      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_2|GPIO_CFG_PORT_A|GPIO_CFG_PIN_6)
#define GPIO_TIMER2_CH0_2      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_2|GPIO_CFG_PORT_B|GPIO_CFG_PIN_4)
#define GPIO_TIMER2_CH0_3      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_2|GPIO_CFG_PORT_C|GPIO_CFG_PIN_6)
#define GPIO_TIMER2_CH1_1      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_2|GPIO_CFG_PORT_A|GPIO_CFG_PIN_7)
#define GPIO_TIMER2_CH1_2      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_2|GPIO_CFG_PORT_B|GPIO_CFG_PIN_5)
#define GPIO_TIMER2_CH1_3      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_2|GPIO_CFG_PORT_C|GPIO_CFG_PIN_7)
#define GPIO_TIMER2_CH2_1      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_2|GPIO_CFG_PORT_B|GPIO_CFG_PIN_0)
#define GPIO_TIMER2_CH2_2      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_2|GPIO_CFG_PORT_C|GPIO_CFG_PIN_8)
#define GPIO_TIMER2_CH3_1      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_2|GPIO_CFG_PORT_B|GPIO_CFG_PIN_1)
#define GPIO_TIMER2_CH3_2      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_2|GPIO_CFG_PORT_C|GPIO_CFG_PIN_9)
#define GPIO_TIMER2_ETI        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_2|GPIO_CFG_PORT_D|GPIO_CFG_PIN_2)

#define GPIO_TIMER3_CH0_1      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_2|GPIO_CFG_PORT_B|GPIO_CFG_PIN_6)
#define GPIO_TIMER3_CH0_2      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_2|GPIO_CFG_PORT_D|GPIO_CFG_PIN_12)
#define GPIO_TIMER3_CH1_1      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_2|GPIO_CFG_PORT_B|GPIO_CFG_PIN_7)
#define GPIO_TIMER3_CH1_2      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_2|GPIO_CFG_PORT_D|GPIO_CFG_PIN_13)
#define GPIO_TIMER3_CH2_1      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_2|GPIO_CFG_PORT_B|GPIO_CFG_PIN_8)
#define GPIO_TIMER3_CH2_2      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_2|GPIO_CFG_PORT_D|GPIO_CFG_PIN_14)
#define GPIO_TIMER3_CH3_1      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_2|GPIO_CFG_PORT_B|GPIO_CFG_PIN_9)
#define GPIO_TIMER3_CH3_2      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_2|GPIO_CFG_PORT_D|GPIO_CFG_PIN_15)
#define GPIO_TIMER3_ETI        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_2|GPIO_CFG_PORT_E|GPIO_CFG_PIN_0)

#define GPIO_TIMER4_CH0_1      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_2|GPIO_CFG_PORT_A|GPIO_CFG_PIN_0)
#define GPIO_TIMER4_CH0_2      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_2|GPIO_CFG_PORT_H|GPIO_CFG_PIN_10)
#define GPIO_TIMER4_CH1_1      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_2|GPIO_CFG_PORT_A|GPIO_CFG_PIN_1)
#define GPIO_TIMER4_CH1_2      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_2|GPIO_CFG_PORT_H|GPIO_CFG_PIN_11)
#define GPIO_TIMER4_CH2_1      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_2|GPIO_CFG_PORT_A|GPIO_CFG_PIN_2)
#define GPIO_TIMER4_CH2_2      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_2|GPIO_CFG_PORT_H|GPIO_CFG_PIN_12)
#define GPIO_TIMER4_CH3_1      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_2|GPIO_CFG_PORT_A|GPIO_CFG_PIN_3)
#define GPIO_TIMER4_CH3_2      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_2|GPIO_CFG_PORT_I|GPIO_CFG_PIN_0)

/* General level1 timer (TIMERx, x=8, 11) */
#define GPIO_TIMER8_CH0_1      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_3|GPIO_CFG_PORT_A|GPIO_CFG_PIN_2)
#define GPIO_TIMER8_CH0_2      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_3|GPIO_CFG_PORT_E|GPIO_CFG_PIN_5)
#define GPIO_TIMER8_CH1_1      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_3|GPIO_CFG_PORT_A|GPIO_CFG_PIN_3)
#define GPIO_TIMER8_CH1_2      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_3|GPIO_CFG_PORT_E|GPIO_CFG_PIN_6)

#define GPIO_TIMER11_CH0_1     (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_9|GPIO_CFG_PORT_B|GPIO_CFG_PIN_14)
#define GPIO_TIMER11_CH0_2     (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_9|GPIO_CFG_PORT_H|GPIO_CFG_PIN_6)
#define GPIO_TIMER11_CH1_1     (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_9|GPIO_CFG_PORT_B|GPIO_CFG_PIN_15)
#define GPIO_TIMER11_CH1_2     (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_9|GPIO_CFG_PORT_H|GPIO_CFG_PIN_9)

/* General level2 timer (TIMERx, x=9, 10, 12, 13) */

#define GPIO_TIMER9_CH0_1      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_3|GPIO_CFG_PORT_B|GPIO_CFG_PIN_8)
#define GPIO_TIMER9_CH0_2      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_3|GPIO_CFG_PORT_F|GPIO_CFG_PIN_6)

#define GPIO_TIMER10_CH0_1     (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_3|GPIO_CFG_PORT_B|GPIO_CFG_PIN_9)
#define GPIO_TIMER10_CH0_2     (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_3|GPIO_CFG_PORT_F|GPIO_CFG_PIN_7)

#define GPIO_TIMER12_CH0_1     (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_9|GPIO_CFG_PORT_A|GPIO_CFG_PIN_6)
#define GPIO_TIMER12_CH0_2     (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_9|GPIO_CFG_PORT_F|GPIO_CFG_PIN_8)

#define GPIO_TIMER13_CH0_1     (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_9|GPIO_CFG_PORT_A|GPIO_CFG_PIN_7)
#define GPIO_TIMER13_CH0_2     (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_9|GPIO_CFG_PORT_F|GPIO_CFG_PIN_9)

/* Instrumentation Trace Macrocell (ITM) */
#define GPIO_TRACECK           (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_0|GPIO_CFG_PORT_E|GPIO_CFG_PIN_2)
#define GPIO_TRACESWO          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_0|GPIO_CFG_PORT_B|GPIO_CFG_PIN_3)

/* Universal synchronous/asynchronous receiver /transmitter (USART/UART) */

/* USART */

#define GPIO_USART0_CK         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_7|GPIO_CFG_PORT_A|GPIO_CFG_PIN_8)
#define GPIO_USART0_CTS        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_7|GPIO_CFG_PORT_A|GPIO_CFG_PIN_11)
#define GPIO_USART0_RTS        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_7|GPIO_CFG_PORT_A|GPIO_CFG_PIN_12)
#define GPIO_USART0_RX_1       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_7|GPIO_CFG_PORT_A|GPIO_CFG_PIN_10)
#define GPIO_USART0_RX_2       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_7|GPIO_CFG_PORT_B|GPIO_CFG_PIN_3)
#define GPIO_USART0_RX_3       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_7|GPIO_CFG_PORT_B|GPIO_CFG_PIN_7)
#define GPIO_USART0_TX_1       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_7|GPIO_CFG_PORT_A|GPIO_CFG_PIN_9)
#define GPIO_USART0_TX_2       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_7|GPIO_CFG_PORT_A|GPIO_CFG_PIN_15)
#define GPIO_USART0_TX_3       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_7|GPIO_CFG_PORT_B|GPIO_CFG_PIN_6)

#define GPIO_USART1_CK_1       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_7|GPIO_CFG_PORT_A|GPIO_CFG_PIN_4)
#define GPIO_USART1_CK_2       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_7|GPIO_CFG_PORT_D|GPIO_CFG_PIN_7)
#define GPIO_USART1_CTS_1      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_7|GPIO_CFG_PORT_A|GPIO_CFG_PIN_0)
#define GPIO_USART1_CTS_2      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_7|GPIO_CFG_PORT_D|GPIO_CFG_PIN_3)
#define GPIO_USART1_RTS_1      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_7|GPIO_CFG_PORT_A|GPIO_CFG_PIN_1)
#define GPIO_USART1_RTS_2      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_7|GPIO_CFG_PORT_D|GPIO_CFG_PIN_4)
#define GPIO_USART1_RX_1       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_7|GPIO_CFG_PORT_A|GPIO_CFG_PIN_3)
#define GPIO_USART1_RX_2       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_7|GPIO_CFG_PORT_D|GPIO_CFG_PIN_6)
#define GPIO_USART1_TX_1       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_7|GPIO_CFG_PORT_A|GPIO_CFG_PIN_2)
#define GPIO_USART1_TX_2       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_7|GPIO_CFG_PORT_D|GPIO_CFG_PIN_5)

#define GPIO_USART2_CK_1       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_7|GPIO_CFG_PORT_B|GPIO_CFG_PIN_12)
#define GPIO_USART2_CK_2       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_7|GPIO_CFG_PORT_C|GPIO_CFG_PIN_12)
#define GPIO_USART2_CK_3       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_7|GPIO_CFG_PORT_D|GPIO_CFG_PIN_10)
#define GPIO_USART2_CTS_1      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_7|GPIO_CFG_PORT_B|GPIO_CFG_PIN_13)
#define GPIO_USART2_CTS_2      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_7|GPIO_CFG_PORT_D|GPIO_CFG_PIN_11)
#define GPIO_USART2_RTS_1      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_7|GPIO_CFG_PORT_B|GPIO_CFG_PIN_14)
#define GPIO_USART2_RTS_2      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_7|GPIO_CFG_PORT_D|GPIO_CFG_PIN_12)
#define GPIO_USART2_RX_1       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_7|GPIO_CFG_PORT_B|GPIO_CFG_PIN_11)
#define GPIO_USART2_RX_2       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_7|GPIO_CFG_PORT_C|GPIO_CFG_PIN_5)
#define GPIO_USART2_RX_3       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_7|GPIO_CFG_PORT_C|GPIO_CFG_PIN_11)
#define GPIO_USART2_RX_4       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_7|GPIO_CFG_PORT_D|GPIO_CFG_PIN_9)
#define GPIO_USART2_TX_1       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_7|GPIO_CFG_PORT_B|GPIO_CFG_PIN_10)
#define GPIO_USART2_TX_2       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_7|GPIO_CFG_PORT_C|GPIO_CFG_PIN_10)
#define GPIO_USART2_TX_3       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_7|GPIO_CFG_PORT_D|GPIO_CFG_PIN_8)

#define GPIO_USART5_CK_1       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_8|GPIO_CFG_PORT_C|GPIO_CFG_PIN_8)
#define GPIO_USART5_CK_2       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_8|GPIO_CFG_PORT_G|GPIO_CFG_PIN_7)
#define GPIO_USART5_CTS_1      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_8|GPIO_CFG_PORT_G|GPIO_CFG_PIN_13)
#define GPIO_USART5_CTS_2      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_8|GPIO_CFG_PORT_G|GPIO_CFG_PIN_15)
#define GPIO_USART5_RTS_1      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_8|GPIO_CFG_PORT_G|GPIO_CFG_PIN_8)
#define GPIO_USART5_RTS_2      (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_8|GPIO_CFG_PORT_G|GPIO_CFG_PIN_12)
#define GPIO_USART5_RX_1       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_8|GPIO_CFG_PORT_A|GPIO_CFG_PIN_12)
#define GPIO_USART5_RX_2       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_8|GPIO_CFG_PORT_C|GPIO_CFG_PIN_7)
#define GPIO_USART5_RX_3       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_8|GPIO_CFG_PORT_G|GPIO_CFG_PIN_9)
#define GPIO_USART5_TX_1       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_8|GPIO_CFG_PORT_A|GPIO_CFG_PIN_11)
#define GPIO_USART5_TX_2       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_8|GPIO_CFG_PORT_C|GPIO_CFG_PIN_6)
#define GPIO_USART5_TX_3       (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_8|GPIO_CFG_PORT_G|GPIO_CFG_PIN_14)

/* UART */

#define GPIO_UART3_RX_1        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_8|GPIO_CFG_PORT_A|GPIO_CFG_PIN_1)
#define GPIO_UART3_RX_2        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_8|GPIO_CFG_PORT_C|GPIO_CFG_PIN_11)
#define GPIO_UART3_TX_1        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_8|GPIO_CFG_PORT_A|GPIO_CFG_PIN_0)
#define GPIO_UART3_TX_2        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_8|GPIO_CFG_PORT_C|GPIO_CFG_PIN_10)

#define GPIO_UART4_RX          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_8|GPIO_CFG_PORT_D|GPIO_CFG_PIN_2)
#define GPIO_UART4_TX          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_8|GPIO_CFG_PORT_C|GPIO_CFG_PIN_12)

#define GPIO_UART6_RX_1        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_8|GPIO_CFG_PORT_E|GPIO_CFG_PIN_7)
#define GPIO_UART6_RX_2        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_8|GPIO_CFG_PORT_F|GPIO_CFG_PIN_6)
#define GPIO_UART6_TX_1        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_8|GPIO_CFG_PORT_E|GPIO_CFG_PIN_8)
#define GPIO_UART6_TX_2        (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_8|GPIO_CFG_PORT_F|GPIO_CFG_PIN_7)

#define GPIO_UART7_RX          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_8|GPIO_CFG_PORT_E|GPIO_CFG_PIN_0)
#define GPIO_UART7_TX          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_PP|GPIO_CFG_SPEED_50MHZ|GPIO_CFG_AF_8|GPIO_CFG_PORT_E|GPIO_CFG_PIN_1)

/* Universal serial bus full-speed interface (USBFS) */

#define GPIO_USBFS_DM          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_10|GPIO_CFG_PORT_A|GPIO_CFG_PIN_11)
#define GPIO_USBFS_DP          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_10|GPIO_CFG_PORT_A|GPIO_CFG_PIN_12)
#define GPIO_USBFS_ID          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_OD|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_10|GPIO_CFG_PORT_A|GPIO_CFG_PIN_10)
#define GPIO_USBFS_SOF         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_10|GPIO_CFG_PORT_A|GPIO_CFG_PIN_8)

/* Universal serial bus high-speed interface (USBHS) */
#define GPIO_USBHS_DM          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_B|GPIO_CFG_PIN_14)
#define GPIO_USBHS_DP          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_B|GPIO_CFG_PIN_15)
#define GPIO_USBHS_ID          (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_PULLUP|GPIO_CFG_OD|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_B|GPIO_CFG_PIN_12)
#define GPIO_USBHS_SOF         (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_12|GPIO_CFG_PORT_A|GPIO_CFG_PIN_4)
#define GPIO_USBHS_ULPI_CK     (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_10|GPIO_CFG_PORT_A|GPIO_CFG_PIN_5)
#define GPIO_USBHS_ULPI_D0     (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_10|GPIO_CFG_PORT_A|GPIO_CFG_PIN_3)
#define GPIO_USBHS_ULPI_D1     (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_10|GPIO_CFG_PORT_B|GPIO_CFG_PIN_0)
#define GPIO_USBHS_ULPI_D2     (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_10|GPIO_CFG_PORT_B|GPIO_CFG_PIN_1)
#define GPIO_USBHS_ULPI_D3     (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_10|GPIO_CFG_PORT_B|GPIO_CFG_PIN_10)
#define GPIO_USBHS_ULPI_D4_1   (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_10|GPIO_CFG_PORT_B|GPIO_CFG_PIN_2)
#define GPIO_USBHS_ULPI_D4_2   (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_10|GPIO_CFG_PORT_B|GPIO_CFG_PIN_11)
#define GPIO_USBHS_ULPI_D5     (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_10|GPIO_CFG_PORT_B|GPIO_CFG_PIN_12)
#define GPIO_USBHS_ULPI_D6     (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_10|GPIO_CFG_PORT_B|GPIO_CFG_PIN_13)
#define GPIO_USBHS_ULPI_D7     (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_10|GPIO_CFG_PORT_B|GPIO_CFG_PIN_5)
#define GPIO_USBHS_ULPI_DIR_1  (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_10|GPIO_CFG_PORT_C|GPIO_CFG_PIN_2)
#define GPIO_USBHS_ULPI_DIR_2  (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_10|GPIO_CFG_PORT_I|GPIO_CFG_PIN_11)
#define GPIO_USBHS_ULPI_NXT_1  (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_10|GPIO_CFG_PORT_C|GPIO_CFG_PIN_3)
#define GPIO_USBHS_ULPI_NXT_2  (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_10|GPIO_CFG_PORT_H|GPIO_CFG_PIN_4)
#define GPIO_USBHS_ULPI_STP    (GPIO_CFG_MODE_AF|GPIO_CFG_PUPD_NONE|GPIO_CFG_PP|GPIO_CFG_SPEED_200MHZ|GPIO_CFG_AF_10|GPIO_CFG_PORT_C|GPIO_CFG_PIN_0)

#endif /* __ARCH_ARM_SRC_GD32F4_HARDWARE_GD32F450_PINMAP_H */
