/****************************************************************************
 * arch/risc-v/src/hpm6000/hardware/hpm6300/hpm6300_ioc.h
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.  The
 * ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 ****************************************************************************/

#ifndef __ARCH_RISCV_SRC_HPM6000_HARDWARE_HPM6300_HPM6300_IOC_H
#define __ARCH_RISCV_SRC_HPM6000_HARDWARE_HPM6300_HPM6300_IOC_H

/****************************************************************************
 * Included Files
 ****************************************************************************/

#include <nuttx/config.h>
#include "hardware/hpm_memorymap.h"

/****************************************************************************
 * Pre-processor Definitions
 ****************************************************************************/

/* PAD register group index macro definition */
#define HPM_IOC_PAD_PA00_INDEX                   (0UL)
#define HPM_IOC_PAD_PA01_INDEX                   (1UL)
#define HPM_IOC_PAD_PA02_INDEX                   (2UL)
#define HPM_IOC_PAD_PA03_INDEX                   (3UL)
#define HPM_IOC_PAD_PA04_INDEX                   (4UL)
#define HPM_IOC_PAD_PA05_INDEX                   (5UL)
#define HPM_IOC_PAD_PA06_INDEX                   (6UL)
#define HPM_IOC_PAD_PA07_INDEX                   (7UL)
#define HPM_IOC_PAD_PA08_INDEX                   (8UL)
#define HPM_IOC_PAD_PA09_INDEX                   (9UL)
#define HPM_IOC_PAD_PA10_INDEX                   (10UL)
#define HPM_IOC_PAD_PA11_INDEX                   (11UL)
#define HPM_IOC_PAD_PA12_INDEX                   (12UL)
#define HPM_IOC_PAD_PA13_INDEX                   (13UL)
#define HPM_IOC_PAD_PA14_INDEX                   (14UL)
#define HPM_IOC_PAD_PA15_INDEX                   (15UL)
#define HPM_IOC_PAD_PA16_INDEX                   (16UL)
#define HPM_IOC_PAD_PA17_INDEX                   (17UL)
#define HPM_IOC_PAD_PA18_INDEX                   (18UL)
#define HPM_IOC_PAD_PA19_INDEX                   (19UL)
#define HPM_IOC_PAD_PA20_INDEX                   (20UL)
#define HPM_IOC_PAD_PA21_INDEX                   (21UL)
#define HPM_IOC_PAD_PA22_INDEX                   (22UL)
#define HPM_IOC_PAD_PA23_INDEX                   (23UL)
#define HPM_IOC_PAD_PA24_INDEX                   (24UL)
#define HPM_IOC_PAD_PA25_INDEX                   (25UL)
#define HPM_IOC_PAD_PA26_INDEX                   (26UL)
#define HPM_IOC_PAD_PA27_INDEX                   (27UL)
#define HPM_IOC_PAD_PA28_INDEX                   (28UL)
#define HPM_IOC_PAD_PA29_INDEX                   (29UL)
#define HPM_IOC_PAD_PA30_INDEX                   (30UL)
#define HPM_IOC_PAD_PA31_INDEX                   (31UL)
#define HPM_IOC_PAD_PB00_INDEX                   (32UL)
#define HPM_IOC_PAD_PB01_INDEX                   (33UL)
#define HPM_IOC_PAD_PB02_INDEX                   (34UL)
#define HPM_IOC_PAD_PB03_INDEX                   (35UL)
#define HPM_IOC_PAD_PB04_INDEX                   (36UL)
#define HPM_IOC_PAD_PB05_INDEX                   (37UL)
#define HPM_IOC_PAD_PB06_INDEX                   (38UL)
#define HPM_IOC_PAD_PB07_INDEX                   (39UL)
#define HPM_IOC_PAD_PB08_INDEX                   (40UL)
#define HPM_IOC_PAD_PB09_INDEX                   (41UL)
#define HPM_IOC_PAD_PB10_INDEX                   (42UL)
#define HPM_IOC_PAD_PB11_INDEX                   (43UL)
#define HPM_IOC_PAD_PB12_INDEX                   (44UL)
#define HPM_IOC_PAD_PB13_INDEX                   (45UL)
#define HPM_IOC_PAD_PB14_INDEX                   (46UL)
#define HPM_IOC_PAD_PB15_INDEX                   (47UL)
#define HPM_IOC_PAD_PB16_INDEX                   (48UL)
#define HPM_IOC_PAD_PB17_INDEX                   (49UL)
#define HPM_IOC_PAD_PB18_INDEX                   (50UL)
#define HPM_IOC_PAD_PB19_INDEX                   (51UL)
#define HPM_IOC_PAD_PB20_INDEX                   (52UL)
#define HPM_IOC_PAD_PB21_INDEX                   (53UL)
#define HPM_IOC_PAD_PB22_INDEX                   (54UL)
#define HPM_IOC_PAD_PB23_INDEX                   (55UL)
#define HPM_IOC_PAD_PB24_INDEX                   (56UL)
#define HPM_IOC_PAD_PB25_INDEX                   (57UL)
#define HPM_IOC_PAD_PB26_INDEX                   (58UL)
#define HPM_IOC_PAD_PB27_INDEX                   (59UL)
#define HPM_IOC_PAD_PB28_INDEX                   (60UL)
#define HPM_IOC_PAD_PB29_INDEX                   (61UL)
#define HPM_IOC_PAD_PB30_INDEX                   (62UL)
#define HPM_IOC_PAD_PB31_INDEX                   (63UL)
#define HPM_IOC_PAD_PC00_INDEX                   (64UL)
#define HPM_IOC_PAD_PC01_INDEX                   (65UL)
#define HPM_IOC_PAD_PC02_INDEX                   (66UL)
#define HPM_IOC_PAD_PC03_INDEX                   (67UL)
#define HPM_IOC_PAD_PC04_INDEX                   (68UL)
#define HPM_IOC_PAD_PC05_INDEX                   (69UL)
#define HPM_IOC_PAD_PC06_INDEX                   (70UL)
#define HPM_IOC_PAD_PC07_INDEX                   (71UL)
#define HPM_IOC_PAD_PC08_INDEX                   (72UL)
#define HPM_IOC_PAD_PC09_INDEX                   (73UL)
#define HPM_IOC_PAD_PC10_INDEX                   (74UL)
#define HPM_IOC_PAD_PC11_INDEX                   (75UL)
#define HPM_IOC_PAD_PC12_INDEX                   (76UL)
#define HPM_IOC_PAD_PC13_INDEX                   (77UL)
#define HPM_IOC_PAD_PC14_INDEX                   (78UL)
#define HPM_IOC_PAD_PC15_INDEX                   (79UL)
#define HPM_IOC_PAD_PC16_INDEX                   (80UL)
#define HPM_IOC_PAD_PC17_INDEX                   (81UL)
#define HPM_IOC_PAD_PC18_INDEX                   (82UL)
#define HPM_IOC_PAD_PC19_INDEX                   (83UL)
#define HPM_IOC_PAD_PC20_INDEX                   (84UL)
#define HPM_IOC_PAD_PC21_INDEX                   (85UL)
#define HPM_IOC_PAD_PC22_INDEX                   (86UL)
#define HPM_IOC_PAD_PC23_INDEX                   (87UL)
#define HPM_IOC_PAD_PC24_INDEX                   (88UL)
#define HPM_IOC_PAD_PC25_INDEX                   (89UL)
#define HPM_IOC_PAD_PC26_INDEX                   (90UL)
#define HPM_IOC_PAD_PC27_INDEX                   (91UL)
#define HPM_IOC_PAD_PX00_INDEX                   (416UL)
#define HPM_IOC_PAD_PX01_INDEX                   (417UL)
#define HPM_IOC_PAD_PX02_INDEX                   (418UL)
#define HPM_IOC_PAD_PX03_INDEX                   (419UL)
#define HPM_IOC_PAD_PX04_INDEX                   (420UL)
#define HPM_IOC_PAD_PX05_INDEX                   (421UL)
#define HPM_IOC_PAD_PX06_INDEX                   (422UL)
#define HPM_IOC_PAD_PX07_INDEX                   (423UL)
#define HPM_IOC_PAD_PY00_INDEX                   (448UL)
#define HPM_IOC_PAD_PY01_INDEX                   (449UL)
#define HPM_IOC_PAD_PY02_INDEX                   (450UL)
#define HPM_IOC_PAD_PY03_INDEX                   (451UL)
#define HPM_IOC_PAD_PY04_INDEX                   (452UL)
#define HPM_IOC_PAD_PY05_INDEX                   (453UL)
#define HPM_IOC_PAD_PY06_INDEX                   (454UL)
#define HPM_IOC_PAD_PY07_INDEX                   (455UL)
#define HPM_IOC_PAD_PZ00_INDEX                   (480UL)
#define HPM_IOC_PAD_PZ01_INDEX                   (481UL)
#define HPM_IOC_PAD_PZ02_INDEX                   (482UL)
#define HPM_IOC_PAD_PZ03_INDEX                   (483UL)
#define HPM_IOC_PAD_PZ04_INDEX                   (484UL)
#define HPM_IOC_PAD_PZ05_INDEX                   (485UL)
#define HPM_IOC_PAD_PZ06_INDEX                   (486UL)
#define HPM_IOC_PAD_PZ07_INDEX                   (487UL)

#define HPM_IOC_PAD_NREGISTERS                   116

/* Register offsets *********************************************************/

#define HPM_IOC_PAD_FUNC_CTL_OFFSET(n)            (0x0000 + ((unsigned int)(n) * 0x0008))
#define HPM_IOC_PAD_PAD_CTL_OFFSET(n)             (0x0004 + ((unsigned int)(n) * 0x0008))

#define HPM_IOC_PAD_PA00_FUNC_CTL_OFFSET          0x0000
#define HPM_IOC_PAD_PA00_PAD_CTL_OFFSET           0x0004
#define HPM_IOC_PAD_PA01_FUNC_CTL_OFFSET          0x0008
#define HPM_IOC_PAD_PA01_PAD_CTL_OFFSET           0x000c
#define HPM_IOC_PAD_PA02_FUNC_CTL_OFFSET          0x0010
#define HPM_IOC_PAD_PA02_PAD_CTL_OFFSET           0x0014
#define HPM_IOC_PAD_PA03_FUNC_CTL_OFFSET          0x0018
#define HPM_IOC_PAD_PA03_PAD_CTL_OFFSET           0x001c
#define HPM_IOC_PAD_PA04_FUNC_CTL_OFFSET          0x0020
#define HPM_IOC_PAD_PA04_PAD_CTL_OFFSET           0x0024
#define HPM_IOC_PAD_PA05_FUNC_CTL_OFFSET          0x0028
#define HPM_IOC_PAD_PA05_PAD_CTL_OFFSET           0x002c
#define HPM_IOC_PAD_PA06_FUNC_CTL_OFFSET          0x0030
#define HPM_IOC_PAD_PA06_PAD_CTL_OFFSET           0x0034
#define HPM_IOC_PAD_PA07_FUNC_CTL_OFFSET          0x0038
#define HPM_IOC_PAD_PA07_PAD_CTL_OFFSET           0x003c
#define HPM_IOC_PAD_PA08_FUNC_CTL_OFFSET          0x0040
#define HPM_IOC_PAD_PA08_PAD_CTL_OFFSET           0x0044
#define HPM_IOC_PAD_PA09_FUNC_CTL_OFFSET          0x0048
#define HPM_IOC_PAD_PA09_PAD_CTL_OFFSET           0x004c
#define HPM_IOC_PAD_PA10_FUNC_CTL_OFFSET          0x0050
#define HPM_IOC_PAD_PA10_PAD_CTL_OFFSET           0x0054
#define HPM_IOC_PAD_PA11_FUNC_CTL_OFFSET          0x0058
#define HPM_IOC_PAD_PA11_PAD_CTL_OFFSET           0x005c
#define HPM_IOC_PAD_PA12_FUNC_CTL_OFFSET          0x0060
#define HPM_IOC_PAD_PA12_PAD_CTL_OFFSET           0x0064
#define HPM_IOC_PAD_PA13_FUNC_CTL_OFFSET          0x0068
#define HPM_IOC_PAD_PA13_PAD_CTL_OFFSET           0x006c
#define HPM_IOC_PAD_PA14_FUNC_CTL_OFFSET          0x0070
#define HPM_IOC_PAD_PA14_PAD_CTL_OFFSET           0x0074
#define HPM_IOC_PAD_PA15_FUNC_CTL_OFFSET          0x0078
#define HPM_IOC_PAD_PA15_PAD_CTL_OFFSET           0x007c
#define HPM_IOC_PAD_PA16_FUNC_CTL_OFFSET          0x0080
#define HPM_IOC_PAD_PA16_PAD_CTL_OFFSET           0x0084
#define HPM_IOC_PAD_PA17_FUNC_CTL_OFFSET          0x0088
#define HPM_IOC_PAD_PA17_PAD_CTL_OFFSET           0x008c
#define HPM_IOC_PAD_PA18_FUNC_CTL_OFFSET          0x0090
#define HPM_IOC_PAD_PA18_PAD_CTL_OFFSET           0x0094
#define HPM_IOC_PAD_PA19_FUNC_CTL_OFFSET          0x0098
#define HPM_IOC_PAD_PA19_PAD_CTL_OFFSET           0x009c
#define HPM_IOC_PAD_PA20_FUNC_CTL_OFFSET          0x00a0
#define HPM_IOC_PAD_PA20_PAD_CTL_OFFSET           0x00a4
#define HPM_IOC_PAD_PA21_FUNC_CTL_OFFSET          0x00a8
#define HPM_IOC_PAD_PA21_PAD_CTL_OFFSET           0x00ac
#define HPM_IOC_PAD_PA22_FUNC_CTL_OFFSET          0x00b0
#define HPM_IOC_PAD_PA22_PAD_CTL_OFFSET           0x00b4
#define HPM_IOC_PAD_PA23_FUNC_CTL_OFFSET          0x00b8
#define HPM_IOC_PAD_PA23_PAD_CTL_OFFSET           0x00bc
#define HPM_IOC_PAD_PA24_FUNC_CTL_OFFSET          0x00c0
#define HPM_IOC_PAD_PA24_PAD_CTL_OFFSET           0x00c4
#define HPM_IOC_PAD_PA25_FUNC_CTL_OFFSET          0x00c8
#define HPM_IOC_PAD_PA25_PAD_CTL_OFFSET           0x00cc
#define HPM_IOC_PAD_PA26_FUNC_CTL_OFFSET          0x00d0
#define HPM_IOC_PAD_PA26_PAD_CTL_OFFSET           0x00d4
#define HPM_IOC_PAD_PA27_FUNC_CTL_OFFSET          0x00d8
#define HPM_IOC_PAD_PA27_PAD_CTL_OFFSET           0x00dc
#define HPM_IOC_PAD_PA28_FUNC_CTL_OFFSET          0x00e0
#define HPM_IOC_PAD_PA28_PAD_CTL_OFFSET           0x00e4
#define HPM_IOC_PAD_PA29_FUNC_CTL_OFFSET          0x00e8
#define HPM_IOC_PAD_PA29_PAD_CTL_OFFSET           0x00ec
#define HPM_IOC_PAD_PA30_FUNC_CTL_OFFSET          0x00f0
#define HPM_IOC_PAD_PA30_PAD_CTL_OFFSET           0x00f4
#define HPM_IOC_PAD_PA31_FUNC_CTL_OFFSET          0x00f8
#define HPM_IOC_PAD_PA31_PAD_CTL_OFFSET           0x00fc
#define HPM_IOC_PAD_PB00_FUNC_CTL_OFFSET          0x0100
#define HPM_IOC_PAD_PB00_PAD_CTL_OFFSET           0x0104
#define HPM_IOC_PAD_PB01_FUNC_CTL_OFFSET          0x0108
#define HPM_IOC_PAD_PB01_PAD_CTL_OFFSET           0x010c
#define HPM_IOC_PAD_PB02_FUNC_CTL_OFFSET          0x0110
#define HPM_IOC_PAD_PB02_PAD_CTL_OFFSET           0x0114
#define HPM_IOC_PAD_PB03_FUNC_CTL_OFFSET          0x0118
#define HPM_IOC_PAD_PB03_PAD_CTL_OFFSET           0x011c
#define HPM_IOC_PAD_PB04_FUNC_CTL_OFFSET          0x0120
#define HPM_IOC_PAD_PB04_PAD_CTL_OFFSET           0x0124
#define HPM_IOC_PAD_PB05_FUNC_CTL_OFFSET          0x0128
#define HPM_IOC_PAD_PB05_PAD_CTL_OFFSET           0x012c
#define HPM_IOC_PAD_PB06_FUNC_CTL_OFFSET          0x0130
#define HPM_IOC_PAD_PB06_PAD_CTL_OFFSET           0x0134
#define HPM_IOC_PAD_PB07_FUNC_CTL_OFFSET          0x0138
#define HPM_IOC_PAD_PB07_PAD_CTL_OFFSET           0x013c
#define HPM_IOC_PAD_PB08_FUNC_CTL_OFFSET          0x0140
#define HPM_IOC_PAD_PB08_PAD_CTL_OFFSET           0x0144
#define HPM_IOC_PAD_PB09_FUNC_CTL_OFFSET          0x0148
#define HPM_IOC_PAD_PB09_PAD_CTL_OFFSET           0x014c
#define HPM_IOC_PAD_PB10_FUNC_CTL_OFFSET          0x0150
#define HPM_IOC_PAD_PB10_PAD_CTL_OFFSET           0x0154
#define HPM_IOC_PAD_PB11_FUNC_CTL_OFFSET          0x0158
#define HPM_IOC_PAD_PB11_PAD_CTL_OFFSET           0x015c
#define HPM_IOC_PAD_PB12_FUNC_CTL_OFFSET          0x0160
#define HPM_IOC_PAD_PB12_PAD_CTL_OFFSET           0x0164
#define HPM_IOC_PAD_PB13_FUNC_CTL_OFFSET          0x0168
#define HPM_IOC_PAD_PB13_PAD_CTL_OFFSET           0x016c
#define HPM_IOC_PAD_PB14_FUNC_CTL_OFFSET          0x0170
#define HPM_IOC_PAD_PB14_PAD_CTL_OFFSET           0x0174
#define HPM_IOC_PAD_PB15_FUNC_CTL_OFFSET          0x0178
#define HPM_IOC_PAD_PB15_PAD_CTL_OFFSET           0x017c
#define HPM_IOC_PAD_PB16_FUNC_CTL_OFFSET          0x0180
#define HPM_IOC_PAD_PB16_PAD_CTL_OFFSET           0x0184
#define HPM_IOC_PAD_PB17_FUNC_CTL_OFFSET          0x0188
#define HPM_IOC_PAD_PB17_PAD_CTL_OFFSET           0x018c
#define HPM_IOC_PAD_PB18_FUNC_CTL_OFFSET          0x0190
#define HPM_IOC_PAD_PB18_PAD_CTL_OFFSET           0x0194
#define HPM_IOC_PAD_PB19_FUNC_CTL_OFFSET          0x0198
#define HPM_IOC_PAD_PB19_PAD_CTL_OFFSET           0x019c
#define HPM_IOC_PAD_PB20_FUNC_CTL_OFFSET          0x01a0
#define HPM_IOC_PAD_PB20_PAD_CTL_OFFSET           0x01a4
#define HPM_IOC_PAD_PB21_FUNC_CTL_OFFSET          0x01a8
#define HPM_IOC_PAD_PB21_PAD_CTL_OFFSET           0x01ac
#define HPM_IOC_PAD_PB22_FUNC_CTL_OFFSET          0x01b0
#define HPM_IOC_PAD_PB22_PAD_CTL_OFFSET           0x01b4
#define HPM_IOC_PAD_PB23_FUNC_CTL_OFFSET          0x01b8
#define HPM_IOC_PAD_PB23_PAD_CTL_OFFSET           0x01bc
#define HPM_IOC_PAD_PB24_FUNC_CTL_OFFSET          0x01c0
#define HPM_IOC_PAD_PB24_PAD_CTL_OFFSET           0x01c4
#define HPM_IOC_PAD_PB25_FUNC_CTL_OFFSET          0x01c8
#define HPM_IOC_PAD_PB25_PAD_CTL_OFFSET           0x01cc
#define HPM_IOC_PAD_PB26_FUNC_CTL_OFFSET          0x01d0
#define HPM_IOC_PAD_PB26_PAD_CTL_OFFSET           0x01d4
#define HPM_IOC_PAD_PB27_FUNC_CTL_OFFSET          0x01d8
#define HPM_IOC_PAD_PB27_PAD_CTL_OFFSET           0x01dc
#define HPM_IOC_PAD_PB28_FUNC_CTL_OFFSET          0x01e0
#define HPM_IOC_PAD_PB28_PAD_CTL_OFFSET           0x01e4
#define HPM_IOC_PAD_PB29_FUNC_CTL_OFFSET          0x01e8
#define HPM_IOC_PAD_PB29_PAD_CTL_OFFSET           0x01ec
#define HPM_IOC_PAD_PB30_FUNC_CTL_OFFSET          0x01f0
#define HPM_IOC_PAD_PB30_PAD_CTL_OFFSET           0x01f4
#define HPM_IOC_PAD_PB31_FUNC_CTL_OFFSET          0x01f8
#define HPM_IOC_PAD_PB31_PAD_CTL_OFFSET           0x01fc
#define HPM_IOC_PAD_PC00_FUNC_CTL_OFFSET          0x0200
#define HPM_IOC_PAD_PC00_PAD_CTL_OFFSET           0x0204
#define HPM_IOC_PAD_PC01_FUNC_CTL_OFFSET          0x0208
#define HPM_IOC_PAD_PC01_PAD_CTL_OFFSET           0x020c
#define HPM_IOC_PAD_PC02_FUNC_CTL_OFFSET          0x0210
#define HPM_IOC_PAD_PC02_PAD_CTL_OFFSET           0x0214
#define HPM_IOC_PAD_PC03_FUNC_CTL_OFFSET          0x0218
#define HPM_IOC_PAD_PC03_PAD_CTL_OFFSET           0x021c
#define HPM_IOC_PAD_PC04_FUNC_CTL_OFFSET          0x0220
#define HPM_IOC_PAD_PC04_PAD_CTL_OFFSET           0x0224
#define HPM_IOC_PAD_PC05_FUNC_CTL_OFFSET          0x0228
#define HPM_IOC_PAD_PC05_PAD_CTL_OFFSET           0x022c
#define HPM_IOC_PAD_PC06_FUNC_CTL_OFFSET          0x0230
#define HPM_IOC_PAD_PC06_PAD_CTL_OFFSET           0x0234
#define HPM_IOC_PAD_PC07_FUNC_CTL_OFFSET          0x0238
#define HPM_IOC_PAD_PC07_PAD_CTL_OFFSET           0x023c
#define HPM_IOC_PAD_PC08_FUNC_CTL_OFFSET          0x0240
#define HPM_IOC_PAD_PC08_PAD_CTL_OFFSET           0x0244
#define HPM_IOC_PAD_PC09_FUNC_CTL_OFFSET          0x0248
#define HPM_IOC_PAD_PC09_PAD_CTL_OFFSET           0x024c
#define HPM_IOC_PAD_PC10_FUNC_CTL_OFFSET          0x0250
#define HPM_IOC_PAD_PC10_PAD_CTL_OFFSET           0x0254
#define HPM_IOC_PAD_PC11_FUNC_CTL_OFFSET          0x0258
#define HPM_IOC_PAD_PC11_PAD_CTL_OFFSET           0x025c
#define HPM_IOC_PAD_PC12_FUNC_CTL_OFFSET          0x0260
#define HPM_IOC_PAD_PC12_PAD_CTL_OFFSET           0x0264
#define HPM_IOC_PAD_PC13_FUNC_CTL_OFFSET          0x0268
#define HPM_IOC_PAD_PC13_PAD_CTL_OFFSET           0x026c
#define HPM_IOC_PAD_PC14_FUNC_CTL_OFFSET          0x0270
#define HPM_IOC_PAD_PC14_PAD_CTL_OFFSET           0x0274
#define HPM_IOC_PAD_PC15_FUNC_CTL_OFFSET          0x0278
#define HPM_IOC_PAD_PC15_PAD_CTL_OFFSET           0x027c
#define HPM_IOC_PAD_PC16_FUNC_CTL_OFFSET          0x0280
#define HPM_IOC_PAD_PC16_PAD_CTL_OFFSET           0x0284
#define HPM_IOC_PAD_PC17_FUNC_CTL_OFFSET          0x0288
#define HPM_IOC_PAD_PC17_PAD_CTL_OFFSET           0x028c
#define HPM_IOC_PAD_PC18_FUNC_CTL_OFFSET          0x0290
#define HPM_IOC_PAD_PC18_PAD_CTL_OFFSET           0x0294
#define HPM_IOC_PAD_PC19_FUNC_CTL_OFFSET          0x0298
#define HPM_IOC_PAD_PC19_PAD_CTL_OFFSET           0x029c
#define HPM_IOC_PAD_PC20_FUNC_CTL_OFFSET          0x02a0
#define HPM_IOC_PAD_PC20_PAD_CTL_OFFSET           0x02a4
#define HPM_IOC_PAD_PC21_FUNC_CTL_OFFSET          0x02a8
#define HPM_IOC_PAD_PC21_PAD_CTL_OFFSET           0x02ac
#define HPM_IOC_PAD_PC22_FUNC_CTL_OFFSET          0x02b0
#define HPM_IOC_PAD_PC22_PAD_CTL_OFFSET           0x02b4
#define HPM_IOC_PAD_PC23_FUNC_CTL_OFFSET          0x02b8
#define HPM_IOC_PAD_PC23_PAD_CTL_OFFSET           0x02bc
#define HPM_IOC_PAD_PC24_FUNC_CTL_OFFSET          0x02c0
#define HPM_IOC_PAD_PC24_PAD_CTL_OFFSET           0x02c4
#define HPM_IOC_PAD_PC25_FUNC_CTL_OFFSET          0x02c8
#define HPM_IOC_PAD_PC25_PAD_CTL_OFFSET           0x02cc
#define HPM_IOC_PAD_PC26_FUNC_CTL_OFFSET          0x02d0
#define HPM_IOC_PAD_PC26_PAD_CTL_OFFSET           0x02d4
#define HPM_IOC_PAD_PC27_FUNC_CTL_OFFSET          0x02d8
#define HPM_IOC_PAD_PC27_PAD_CTL_OFFSET           0x02dc
#define HPM_IOC_PAD_PX00_FUNC_CTL_OFFSET          0x0d00
#define HPM_IOC_PAD_PX00_PAD_CTL_OFFSET           0x0d04
#define HPM_IOC_PAD_PX01_FUNC_CTL_OFFSET          0x0d08
#define HPM_IOC_PAD_PX01_PAD_CTL_OFFSET           0x0d0c
#define HPM_IOC_PAD_PX02_FUNC_CTL_OFFSET          0x0d10
#define HPM_IOC_PAD_PX02_PAD_CTL_OFFSET           0x0d14
#define HPM_IOC_PAD_PX03_FUNC_CTL_OFFSET          0x0d18
#define HPM_IOC_PAD_PX03_PAD_CTL_OFFSET           0x0d1c
#define HPM_IOC_PAD_PX04_FUNC_CTL_OFFSET          0x0d20
#define HPM_IOC_PAD_PX04_PAD_CTL_OFFSET           0x0d24
#define HPM_IOC_PAD_PX05_FUNC_CTL_OFFSET          0x0d28
#define HPM_IOC_PAD_PX05_PAD_CTL_OFFSET           0x0d2c
#define HPM_IOC_PAD_PX06_FUNC_CTL_OFFSET          0x0d30
#define HPM_IOC_PAD_PX06_PAD_CTL_OFFSET           0x0d34
#define HPM_IOC_PAD_PX07_FUNC_CTL_OFFSET          0x0d38
#define HPM_IOC_PAD_PX07_PAD_CTL_OFFSET           0x0d3c
#define HPM_IOC_PAD_PY00_FUNC_CTL_OFFSET          0x0e00
#define HPM_IOC_PAD_PY00_PAD_CTL_OFFSET           0x0e04
#define HPM_IOC_PAD_PY01_FUNC_CTL_OFFSET          0x0e08
#define HPM_IOC_PAD_PY01_PAD_CTL_OFFSET           0x0e0c
#define HPM_IOC_PAD_PY02_FUNC_CTL_OFFSET          0x0e10
#define HPM_IOC_PAD_PY02_PAD_CTL_OFFSET           0x0e14
#define HPM_IOC_PAD_PY03_FUNC_CTL_OFFSET          0x0e18
#define HPM_IOC_PAD_PY03_PAD_CTL_OFFSET           0x0e1c
#define HPM_IOC_PAD_PY04_FUNC_CTL_OFFSET          0x0e20
#define HPM_IOC_PAD_PY04_PAD_CTL_OFFSET           0x0e24
#define HPM_IOC_PAD_PY05_FUNC_CTL_OFFSET          0x0e28
#define HPM_IOC_PAD_PY05_PAD_CTL_OFFSET           0x0e2c
#define HPM_IOC_PAD_PY06_FUNC_CTL_OFFSET          0x0e30
#define HPM_IOC_PAD_PY06_PAD_CTL_OFFSET           0x0e34
#define HPM_IOC_PAD_PY07_FUNC_CTL_OFFSET          0x0e38
#define HPM_IOC_PAD_PY07_PAD_CTL_OFFSET           0x0e3c
#define HPM_IOC_PAD_PZ00_FUNC_CTL_OFFSET          0x0f00
#define HPM_IOC_PAD_PZ00_PAD_CTL_OFFSET           0x0f04
#define HPM_IOC_PAD_PZ01_FUNC_CTL_OFFSET          0x0f08
#define HPM_IOC_PAD_PZ01_PAD_CTL_OFFSET           0x0f0c
#define HPM_IOC_PAD_PZ02_FUNC_CTL_OFFSET          0x0f10
#define HPM_IOC_PAD_PZ02_PAD_CTL_OFFSET           0x0f14
#define HPM_IOC_PAD_PZ03_FUNC_CTL_OFFSET          0x0f18
#define HPM_IOC_PAD_PZ03_PAD_CTL_OFFSET           0x0f1c
#define HPM_IOC_PAD_PZ04_FUNC_CTL_OFFSET          0x0f20
#define HPM_IOC_PAD_PZ04_PAD_CTL_OFFSET           0x0f24
#define HPM_IOC_PAD_PZ05_FUNC_CTL_OFFSET          0x0f28
#define HPM_IOC_PAD_PZ05_PAD_CTL_OFFSET           0x0f2c
#define HPM_IOC_PAD_PZ06_FUNC_CTL_OFFSET          0x0f30
#define HPM_IOC_PAD_PZ06_PAD_CTL_OFFSET           0x0f34
#define HPM_IOC_PAD_PZ07_FUNC_CTL_OFFSET          0x0f38
#define HPM_IOC_PAD_PZ07_PAD_CTL_OFFSET           0x0f3c

#define HPM_IOC_PAD_FUNC_CTL_ADDRESS(n)    (HPM_IOC_BASE + HPM_IOC_PAD_FUNC_CTL_OFFSET(n))
#define HPM_IOC_PAD_PAD_CTL_ADDRESS(n)     (HPM_IOC_BASE + HPM_IOC_PAD_PAD_CTL_OFFSET(n))

#define HPM_IOC_PAD_PA00_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PA00_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PA00_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PA00_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PA01_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PA01_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PA01_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PA01_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PA02_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PA02_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PA02_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PA02_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PA03_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PA03_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PA03_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PA03_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PA04_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PA04_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PA04_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PA04_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PA05_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PA05_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PA05_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PA05_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PA06_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PA06_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PA06_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PA06_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PA07_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PA07_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PA07_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PA07_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PA08_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PA08_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PA08_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PA08_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PA09_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PA09_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PA09_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PA09_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PA10_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PA10_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PA10_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PA10_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PA11_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PA11_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PA11_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PA11_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PA12_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PA12_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PA12_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PA12_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PA13_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PA13_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PA13_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PA13_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PA14_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PA14_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PA14_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PA14_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PA15_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PA15_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PA15_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PA15_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PA16_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PA16_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PA16_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PA16_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PA17_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PA17_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PA17_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PA17_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PA18_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PA18_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PA18_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PA18_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PA19_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PA19_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PA19_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PA19_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PA20_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PA20_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PA20_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PA20_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PA21_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PA21_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PA21_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PA21_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PA22_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PA22_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PA22_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PA22_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PA23_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PA23_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PA23_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PA23_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PA24_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PA24_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PA24_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PA24_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PA25_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PA25_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PA25_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PA25_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PA26_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PA26_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PA26_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PA26_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PA27_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PA27_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PA27_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PA27_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PA28_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PA28_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PA28_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PA28_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PA29_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PA29_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PA29_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PA29_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PA30_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PA30_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PA30_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PA30_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PA31_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PA31_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PA31_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PA31_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PB00_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PB00_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PB00_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PB00_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PB01_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PB01_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PB01_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PB01_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PB02_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PB02_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PB02_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PB02_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PB03_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PB03_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PB03_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PB03_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PB04_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PB04_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PB04_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PB04_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PB05_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PB05_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PB05_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PB05_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PB06_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PB06_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PB06_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PB06_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PB07_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PB07_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PB07_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PB07_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PB08_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PB08_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PB08_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PB08_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PB09_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PB09_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PB09_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PB09_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PB10_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PB10_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PB10_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PB10_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PB11_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PB11_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PB11_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PB11_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PB12_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PB12_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PB12_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PB12_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PB13_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PB13_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PB13_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PB13_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PB14_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PB14_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PB14_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PB14_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PB15_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PB15_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PB15_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PB15_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PB16_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PB16_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PB16_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PB16_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PB17_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PB17_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PB17_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PB17_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PB18_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PB18_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PB18_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PB18_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PB19_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PB19_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PB19_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PB19_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PB20_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PB20_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PB20_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PB20_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PB21_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PB21_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PB21_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PB21_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PB22_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PB22_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PB22_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PB22_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PB23_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PB23_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PB23_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PB23_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PB24_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PB24_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PB24_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PB24_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PB25_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PB25_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PB25_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PB25_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PB26_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PB26_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PB26_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PB26_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PB27_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PB27_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PB27_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PB27_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PB28_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PB28_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PB28_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PB28_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PB29_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PB29_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PB29_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PB29_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PB30_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PB30_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PB30_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PB30_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PB31_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PB31_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PB31_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PB31_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PC00_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PC00_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PC00_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PC00_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PC01_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PC01_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PC01_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PC01_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PC02_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PC02_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PC02_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PC02_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PC03_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PC03_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PC03_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PC03_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PC04_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PC04_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PC04_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PC04_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PC05_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PC05_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PC05_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PC05_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PC06_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PC06_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PC06_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PC06_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PC07_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PC07_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PC07_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PC07_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PC08_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PC08_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PC08_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PC08_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PC09_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PC09_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PC09_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PC09_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PC10_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PC10_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PC10_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PC10_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PC11_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PC11_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PC11_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PC11_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PC12_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PC12_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PC12_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PC12_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PC13_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PC13_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PC13_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PC13_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PC14_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PC14_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PC14_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PC14_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PC15_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PC15_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PC15_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PC15_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PC16_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PC16_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PC16_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PC16_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PC17_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PC17_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PC17_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PC17_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PC18_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PC18_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PC18_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PC18_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PC19_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PC19_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PC19_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PC19_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PC20_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PC20_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PC20_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PC20_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PC21_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PC21_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PC21_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PC21_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PC22_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PC22_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PC22_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PC22_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PC23_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PC23_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PC23_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PC23_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PC24_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PC24_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PC24_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PC24_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PC25_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PC25_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PC25_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PC25_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PC26_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PC26_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PC26_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PC26_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PC27_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PC27_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PC27_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PC27_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PX00_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PX00_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PX00_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PX00_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PX01_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PX01_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PX01_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PX01_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PX02_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PX02_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PX02_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PX02_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PX03_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PX03_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PX03_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PX03_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PX04_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PX04_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PX04_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PX04_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PX05_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PX05_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PX05_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PX05_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PX06_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PX06_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PX06_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PX06_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PX07_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PX07_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PX07_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PX07_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PY00_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PY00_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PY00_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PY00_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PY01_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PY01_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PY01_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PY01_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PY02_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PY02_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PY02_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PY02_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PY03_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PY03_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PY03_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PY03_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PY04_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PY04_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PY04_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PY04_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PY05_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PY05_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PY05_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PY05_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PY06_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PY06_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PY06_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PY06_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PY07_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PY07_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PY07_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PY07_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PZ00_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PZ00_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PZ00_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PZ00_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PZ01_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PZ01_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PZ01_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PZ01_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PZ02_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PZ02_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PZ02_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PZ02_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PZ03_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PZ03_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PZ03_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PZ03_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PZ04_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PZ04_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PZ04_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PZ04_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PZ05_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PZ05_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PZ05_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PZ05_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PZ06_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PZ06_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PZ06_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PZ06_PAD_CTL_OFFSET )
#define HPM_IOC_PAD_PZ07_FUNC_CTL          (HPM_IOC_BASE + HPM_IOC_PAD_PZ07_FUNC_CTL_OFFSET)
#define HPM_IOC_PAD_PZ07_PAD_CTL           (HPM_IOC_BASE + HPM_IOC_PAD_PZ07_PAD_CTL_OFFSET )

#define HPM_PIOC_PAD_FUNC_CTL_ADDRESS(n)   (HPM_PIOC_BASE + HPM_IOC_PAD_FUNC_CTL_OFFSET(n))
#define HPM_PIOC_PAD_PAD_CTL_ADDRESS(n)    (HPM_PIOC_BASE + HPM_IOC_PAD_PAD_CTL_OFFSET(n))

#define HPM_PIOC_PAD_PY00_FUNC_CTL         (HPM_PIOC_BASE + HPM_IOC_PAD_PY00_FUNC_CTL_OFFSET)
#define HPM_PIOC_PAD_PY01_FUNC_CTL         (HPM_PIOC_BASE + HPM_IOC_PAD_PY01_FUNC_CTL_OFFSET)
#define HPM_PIOC_PAD_PY02_FUNC_CTL         (HPM_PIOC_BASE + HPM_IOC_PAD_PY02_FUNC_CTL_OFFSET)
#define HPM_PIOC_PAD_PY03_FUNC_CTL         (HPM_PIOC_BASE + HPM_IOC_PAD_PY03_FUNC_CTL_OFFSET)
#define HPM_PIOC_PAD_PY04_FUNC_CTL         (HPM_PIOC_BASE + HPM_IOC_PAD_PY04_FUNC_CTL_OFFSET)
#define HPM_PIOC_PAD_PY05_FUNC_CTL         (HPM_PIOC_BASE + HPM_IOC_PAD_PY05_FUNC_CTL_OFFSET)
#define HPM_PIOC_PAD_PY06_FUNC_CTL         (HPM_PIOC_BASE + HPM_IOC_PAD_PY06_FUNC_CTL_OFFSET)
#define HPM_PIOC_PAD_PY07_FUNC_CTL         (HPM_PIOC_BASE + HPM_IOC_PAD_PY07_FUNC_CTL_OFFSET)

#endif /* __ARCH_RISCV_SRC_HPM6000_HARDWARE_HPM6300_HPM6300_IOC_H */