/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.conf;

import java.awt.Image;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyDescriptor;
import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.lib.conf.BooleanValue;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.conf.ConfigurationProvider;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.lib.conf.DoubleValue;
import org.apache.openjpa.lib.conf.FileValue;
import org.apache.openjpa.lib.conf.IntValue;
import org.apache.openjpa.lib.conf.ObjectValue;
import org.apache.openjpa.lib.conf.PluginListValue;
import org.apache.openjpa.lib.conf.PluginValue;
import org.apache.openjpa.lib.conf.ProductDerivations;
import org.apache.openjpa.lib.conf.StringListValue;
import org.apache.openjpa.lib.conf.StringValue;
import org.apache.openjpa.lib.conf.Value;
import org.apache.openjpa.lib.conf.ValueListener;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.log.LogFactory;
import org.apache.openjpa.lib.log.LogFactoryImpl;
import org.apache.openjpa.lib.log.NoneLogFactory;
import org.apache.openjpa.lib.util.Closeable;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.MultiClassLoader;
import org.apache.openjpa.lib.util.ParseException;
import org.apache.openjpa.lib.util.Services;
import org.apache.openjpa.lib.util.StringDistance;
import serp.util.Strings;

public class ConfigurationImpl
implements Configuration,
Externalizable,
ValueListener {
    private static final String SEP = J2DoPrivHelper.getLineSeparator();
    private static final Localizer _loc = Localizer.forPackage(ConfigurationImpl.class);
    public ObjectValue logFactoryPlugin;
    public StringValue id;
    private String _product = null;
    private int _readOnlyState = 0;
    private Map _props = null;
    private boolean _globals = false;
    private String _auto = null;
    private final List<Value> _vals = new ArrayList<Value>();
    private Set<String> _supportedKeys = new TreeSet<String>();
    private PropertyChangeSupport _changeSupport = null;
    private PropertyDescriptor[] _pds = null;
    private MethodDescriptor[] _mds = null;
    private ClassLoader _userCL;
    private boolean _deferResourceLoading = false;

    public ConfigurationImpl() {
        this(true);
    }

    public ConfigurationImpl(boolean loadGlobals) {
        this.setProductName("openjpa");
        this.logFactoryPlugin = this.addPlugin("Log", true);
        String[] aliases = new String[]{"true", LogFactoryImpl.class.getName(), "openjpa", LogFactoryImpl.class.getName(), "commons", "org.apache.openjpa.lib.log.CommonsLogFactory", "log4j", "org.apache.openjpa.lib.log.Log4JLogFactory", "slf4j", "org.apache.openjpa.lib.log.SLF4JLogFactory", "none", NoneLogFactory.class.getName(), "false", NoneLogFactory.class.getName()};
        this.logFactoryPlugin.setAliases(aliases);
        this.logFactoryPlugin.setDefault(aliases[0]);
        this.logFactoryPlugin.setString(aliases[0]);
        this.logFactoryPlugin.setInstantiatingGetter("getLogFactory");
        this.id = this.addString("Id");
        if (loadGlobals) {
            this.loadGlobals();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadGlobals() {
        MultiClassLoader loader = AccessController.doPrivileged(J2DoPrivHelper.newMultiClassLoaderAction());
        loader.addClassLoader(AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction()));
        loader.addClassLoader(this.getClass().getClassLoader());
        ConfigurationProvider provider = ProductDerivations.loadGlobals(loader);
        if (provider != null) {
            provider.setInto(this);
        }
        try {
            Properties systemProperties = AccessController.doPrivileged(J2DoPrivHelper.getPropertiesAction());
            HashMap<Object, Object> sysPropHM = null;
            Properties properties = systemProperties;
            synchronized (properties) {
                sysPropHM = new HashMap<Object, Object>(systemProperties);
            }
            this.fromProperties(sysPropHM);
        }
        catch (SecurityException se) {
            // empty catch block
        }
        this._globals = true;
        if (provider == null) {
            Log log = this.getConfigurationLog();
            if (log.isTraceEnabled()) {
                log.trace(_loc.get("no-default-providers"));
            }
            return false;
        }
        return true;
    }

    @Override
    public String getProductName() {
        return this._product;
    }

    @Override
    public void setProductName(String name) {
        this._product = name;
    }

    @Override
    public LogFactory getLogFactory() {
        if (this.logFactoryPlugin.get() == null) {
            this.logFactoryPlugin.instantiate(LogFactory.class, this);
        }
        return (LogFactory)this.logFactoryPlugin.get();
    }

    @Override
    public void setLogFactory(LogFactory logFactory) {
        this.logFactoryPlugin.set(logFactory);
    }

    @Override
    public String getLog() {
        return this.logFactoryPlugin.getString();
    }

    @Override
    public void setLog(String log) {
        this.logFactoryPlugin.setString(log);
    }

    @Override
    public Log getLog(String category) {
        return this.getLogFactory().getLog(category);
    }

    @Override
    public String getId() {
        return this.id.get();
    }

    @Override
    public void setId(String id) {
        this.id.set(id);
    }

    @Override
    public Log getConfigurationLog() {
        return this.getLog("openjpa.Runtime");
    }

    @Override
    public Value[] getValues() {
        return this._vals.toArray(new Value[this._vals.size()]);
    }

    @Override
    public Value getValue(String property) {
        if (property == null) {
            return null;
        }
        for (int i = this._vals.size() - 1; i >= 0; --i) {
            if (!this._vals.get(i).matches(property)) continue;
            return this._vals.get(i);
        }
        return null;
    }

    @Override
    public void setReadOnly(int newState) {
        if (newState >= this._readOnlyState) {
            this._readOnlyState = newState;
        }
    }

    public boolean isDeferResourceLoading() {
        return this._deferResourceLoading;
    }

    public void setDeferResourceLoading(boolean deferResourceLoading) {
        this._deferResourceLoading = deferResourceLoading;
    }

    @Override
    public void instantiateAll() {
        StringWriter errs = null;
        PrintWriter stack = null;
        for (Value val : this._vals) {
            String getterName = val.getInstantiatingGetter();
            if (getterName == null) continue;
            Cloneable getterTarget = this;
            if (getterName.startsWith("this.")) {
                getterName = getterName.substring("this.".length());
                getterTarget = val;
            }
            try {
                Method getter = getterTarget.getClass().getMethod(getterName, null);
                getter.invoke((Object)getterTarget, (Object[])null);
            }
            catch (Throwable t) {
                if (t instanceof InvocationTargetException) {
                    t = ((InvocationTargetException)t).getTargetException();
                }
                if (errs == null) {
                    errs = new StringWriter();
                    stack = new PrintWriter(errs);
                } else {
                    errs.write(SEP);
                }
                t.printStackTrace(stack);
                stack.flush();
            }
        }
        if (errs != null) {
            throw new RuntimeException(_loc.get("get-prop-errs", errs.toString()).getMessage());
        }
    }

    @Override
    public boolean isReadOnly() {
        return this._readOnlyState == 2;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this._changeSupport == null) {
            this._changeSupport = new PropertyChangeSupport(this);
        }
        this._changeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this._changeSupport != null) {
            this._changeSupport.removePropertyChangeListener(listener);
        }
    }

    @Override
    public void valueChanged(Value val) {
        if (this._changeSupport == null && this._props == null) {
            return;
        }
        String newString = val.getString();
        if (this._changeSupport != null) {
            this._changeSupport.firePropertyChange(val.getProperty(), null, newString);
        }
        if (this._props != null) {
            if (newString == null) {
                Configurations.removeProperty(val.getProperty(), this._props);
            } else if (Configurations.containsProperty(val, this._props) || val.getDefault() == null || !val.getDefault().equals(newString)) {
                this.setValue(this._props, val);
            }
        }
    }

    @Override
    public final void close() {
        ProductDerivations.beforeClose(this);
        this.preClose();
        for (Value v : this._vals) {
            ObjectValue val;
            if (v instanceof Closeable) {
                try {
                    ((Closeable)((Object)v)).close();
                }
                catch (Exception e) {}
                continue;
            }
            if (!(v instanceof ObjectValue) || !((val = (ObjectValue)v).get() instanceof Closeable)) continue;
            try {
                ((Closeable)val.get()).close();
            }
            catch (Exception e) {}
        }
    }

    protected void preClose() {
    }

    @Override
    public BeanInfo[] getAdditionalBeanInfo() {
        return new BeanInfo[0];
    }

    @Override
    public BeanDescriptor getBeanDescriptor() {
        return new BeanDescriptor(this.getClass());
    }

    @Override
    public int getDefaultEventIndex() {
        return 0;
    }

    @Override
    public int getDefaultPropertyIndex() {
        return 0;
    }

    @Override
    public EventSetDescriptor[] getEventSetDescriptors() {
        return new EventSetDescriptor[0];
    }

    @Override
    public Image getIcon(int kind) {
        return null;
    }

    @Override
    public synchronized MethodDescriptor[] getMethodDescriptors() {
        if (this._mds != null) {
            return this._mds;
        }
        PropertyDescriptor[] pds = this.getPropertyDescriptors();
        ArrayList<MethodDescriptor> descs = new ArrayList<MethodDescriptor>();
        for (int i = 0; i < pds.length; ++i) {
            Method write = pds[i].getWriteMethod();
            Method read = pds[i].getReadMethod();
            if (read == null || write == null) continue;
            descs.add(new MethodDescriptor(write));
            descs.add(new MethodDescriptor(read));
        }
        this._mds = descs.toArray(new MethodDescriptor[descs.size()]);
        return this._mds;
    }

    @Override
    public synchronized PropertyDescriptor[] getPropertyDescriptors() {
        if (this._pds != null) {
            return this._pds;
        }
        this._pds = new PropertyDescriptor[this._vals.size()];
        ArrayList<String> failures = null;
        for (int i = 0; i < this._vals.size(); ++i) {
            Value val = this._vals.get(i);
            try {
                this._pds[i] = this.getPropertyDescriptor(val);
                continue;
            }
            catch (MissingResourceException mre) {
                if (failures == null) {
                    failures = new ArrayList<String>();
                }
                failures.add(val.getProperty());
                continue;
            }
            catch (IntrospectionException ie) {
                if (failures == null) {
                    failures = new ArrayList();
                }
                failures.add(val.getProperty());
            }
        }
        if (failures != null) {
            throw new ParseException(_loc.get("invalid-property-descriptors", failures));
        }
        return this._pds;
    }

    private PropertyDescriptor getPropertyDescriptor(Value val) throws IntrospectionException {
        String cat;
        PropertyDescriptor pd;
        String prop = val.getProperty();
        prop = prop.substring(prop.lastIndexOf(46) + 1);
        try {
            pd = new PropertyDescriptor(Introspector.decapitalize(prop), this.getClass());
        }
        catch (IntrospectionException ie) {
            pd = new PropertyDescriptor(Introspector.decapitalize(prop), null, null);
        }
        pd.setDisplayName(this.findLocalized(prop + "-name", true, val.getScope()));
        pd.setShortDescription(this.findLocalized(prop + "-desc", true, val.getScope()));
        pd.setExpert("true".equals(this.findLocalized(prop + "-expert", false, val.getScope())));
        try {
            pd.setReadMethod(this.getClass().getMethod("get" + StringUtils.capitalize((String)prop), null));
            pd.setWriteMethod(this.getClass().getMethod("set" + StringUtils.capitalize((String)prop), pd.getReadMethod().getReturnType()));
        }
        catch (Throwable t) {
            // empty catch block
        }
        String type = this.findLocalized(prop + "-type", true, val.getScope());
        if (type != null) {
            pd.setValue("propertyType", type);
        }
        if ((cat = this.findLocalized(prop + "-cat", false, val.getScope())) != null) {
            pd.setValue("propertyCategory", cat);
        }
        pd.setValue("xmlName", ConfigurationImpl.toXMLName(prop));
        String order = this.findLocalized(prop + "-displayorder", false, val.getScope());
        if (order != null) {
            pd.setValue("propertyCategoryOrder", order);
        }
        TreeSet<Object> allowed = new TreeSet<Object>();
        List<Object> aliases = Collections.emptyList();
        if (val.getAliases() != null) {
            aliases = Arrays.asList(val.getAliases());
            for (int i = 0; i < aliases.size(); i += 2) {
                allowed.add(aliases.get(i));
            }
        }
        String[] vals = Strings.split((String)this.findLocalized(prop + "-values", false, val.getScope()), (String)",", (int)0);
        for (int i = 0; i < vals.length; ++i) {
            if (aliases.contains(vals[i])) continue;
            allowed.add(vals[i]);
        }
        try {
            Class<?> intf = Class.forName(this.findLocalized(prop + "-interface", true, val.getScope()), false, this.getClass().getClassLoader());
            pd.setValue("propertyInterface", intf.getName());
            String[] impls = Services.getImplementors(intf);
            for (int i = 0; i < impls.length; ++i) {
                if (aliases.contains(impls[i])) continue;
                allowed.add(impls[i]);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (!allowed.isEmpty()) {
            pd.setValue("allowedValues", allowed.toArray(new String[allowed.size()]));
        }
        return pd;
    }

    private String findLocalized(String key, boolean fatal, Class<?> scope) {
        Localizer loc = null;
        if (scope != null) {
            loc = Localizer.forPackage(scope);
            try {
                return loc.getFatal(key).getMessage();
            }
            catch (MissingResourceException mse) {
                // empty catch block
            }
        }
        for (Class<?> cls = this.getClass(); cls != Object.class; cls = cls.getSuperclass()) {
            loc = Localizer.forPackage(cls);
            try {
                return loc.getFatal(key).getMessage();
            }
            catch (MissingResourceException mse) {
                continue;
            }
        }
        if (fatal) {
            throw new MissingResourceException(key, this.getClass().getName(), key);
        }
        return null;
    }

    public Map toProperties(boolean storeDefaults) {
        Map clone = this._props == null ? new TreeMap() : (this._props instanceof Properties ? (Map)((Properties)this._props).clone() : new TreeMap(this._props));
        if (this._props == null || storeDefaults) {
            for (Value val : this._vals) {
                String str = val.getString();
                if (str == null || !storeDefaults && str.equals(val.getDefault())) continue;
                this.setValue(clone, val);
            }
            if (this._props == null) {
                this._props = new TreeMap(clone);
            }
        }
        return clone;
    }

    @Override
    public void fromProperties(Map map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        if (this.isReadOnly()) {
            throw new IllegalStateException(_loc.get("read-only").getMessage());
        }
        if (this._globals) {
            this._props = null;
            this._globals = false;
        }
        map = map instanceof HashMap ? (Map)((HashMap)map).clone() : (map instanceof Properties ? (Map)((Properties)map).clone() : new LinkedHashMap(map));
        HashMap remaining = new HashMap(map);
        boolean ser = true;
        for (Value val : this._vals) {
            Object o = this.findValue(map, val);
            if (o == null) continue;
            if (o instanceof String) {
                if (!StringUtils.equals((String)((String)o), (String)val.getString()) && !StringUtils.equals((String)((String)o), (String)"******")) {
                    val.setString((String)o);
                }
            } else {
                ser &= o instanceof Serializable;
                val.setObject(o);
            }
            Configurations.removeProperty(val.getProperty(), remaining);
        }
        Configurations.removeProperty("properties", remaining);
        Configurations.removeProperty("Id", remaining, map);
        for (Map.Entry entry : remaining.entrySet()) {
            Object key = entry.getKey();
            if (key == null) continue;
            this.warnInvalidProperty((String)key);
            map.remove(key);
        }
        if (this._props == null && ser) {
            this._props = map;
        }
    }

    @Override
    public List<String> getPropertyKeys(String propertyName) {
        Value value = this.getValue(propertyName);
        return value == null ? Collections.EMPTY_LIST : value.getPropertyKeys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getPropertyKeys() {
        Set<String> set = this._supportedKeys;
        synchronized (set) {
            if (this._supportedKeys.size() == 0) {
                for (Value val : this._vals) {
                    if (val.isPrivate()) continue;
                    List<String> keys = val.getPropertyKeys();
                    for (String key : keys) {
                        this._supportedKeys.add(this.fixPrefix(key));
                    }
                }
            }
        }
        return new TreeSet<String>(this._supportedKeys);
    }

    String fixPrefix(String key) {
        return key == null || this.hasKnownPrefix(key) ? key : "openjpa." + key;
    }

    boolean hasKnownPrefix(String key) {
        String[] prefixes;
        for (String prefix : prefixes = ProductDerivations.getConfigurationPrefixes()) {
            if (!key.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    private void setValue(Map map, Value val) {
        String key = val.getLoadKey();
        if (key == null) {
            List<String> keys = val.getPropertyKeys();
            for (String k : keys) {
                if (!this.hasKnownPrefix(k)) continue;
                key = k;
                break;
            }
            if (key == null) {
                key = "openjpa." + val.getProperty();
            }
        }
        String external = val.isHidden() ? "******" : (val instanceof ObjectValue ? val.getString() : val.get());
        map.put(key, external);
    }

    private Object findValue(Map map, Value val) {
        Object result = null;
        List<String> partialKeys = val.getPropertyKeys();
        for (String partialKey : partialKeys) {
            String key = ProductDerivations.getConfigurationKey(partialKey, map);
            if (!map.containsKey(key)) continue;
            val.setLoadKey(key);
            result = map.get(key);
        }
        return result;
    }

    private void warnInvalidProperty(String propName) {
        if (propName != null && (propName.startsWith("java.") || propName.startsWith("javax.persistence") || propName.startsWith("sun."))) {
            return;
        }
        if (!this.isInvalidProperty(propName)) {
            return;
        }
        Log log = this.getConfigurationLog();
        if (log == null || !log.isWarnEnabled()) {
            return;
        }
        String closest = StringDistance.getClosestLevenshteinDistance(propName, this.newPropertyList(), 15);
        if (closest == null) {
            log.warn(_loc.get("invalid-property", propName));
        } else {
            log.warn(_loc.get("invalid-property-hint", propName, closest));
        }
    }

    private Collection<String> newPropertyList() {
        String[] prefixes = ProductDerivations.getConfigurationPrefixes();
        ArrayList<String> l = new ArrayList<String>(this._vals.size() * prefixes.length);
        for (Value v : this._vals) {
            for (int j = 0; j < prefixes.length; ++j) {
                l.add(prefixes[j] + "." + v.getProperty());
            }
        }
        return l;
    }

    protected boolean isInvalidProperty(String propName) {
        String[] prefixes;
        for (String prefix : prefixes = ProductDerivations.getConfigurationPrefixes()) {
            if (!propName.toLowerCase(Locale.ENGLISH).startsWith(prefix) || propName.length() <= prefix.length() + 1 || propName.indexOf(46, prefix.length()) != prefix.length() || propName.indexOf(46, prefix.length() + 1) != -1 || !"openjpa".equals(prefix)) continue;
            return true;
        }
        return false;
    }

    public void setProperties(String resourceName) throws IOException {
        if (!this._deferResourceLoading) {
            String anchor = null;
            if (resourceName.indexOf("#") != -1) {
                anchor = resourceName.substring(resourceName.lastIndexOf("#") + 1);
                resourceName = resourceName.substring(0, resourceName.length() - anchor.length() - 1);
            }
            ProductDerivations.load(resourceName, anchor, this.getClass().getClassLoader()).setInto(this);
        }
        this._auto = resourceName;
    }

    public void setPropertiesFile(File file) throws IOException {
        ProductDerivations.load(file, null, this.getClass().getClassLoader()).setInto(this);
        this.setDeferResourceLoading(false);
        this._auto = file.toString();
    }

    public String getPropertiesResource() {
        return this._auto;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        ConfigurationImpl conf = (ConfigurationImpl)other;
        if (this._vals.size() != conf.getValues().length) {
            return false;
        }
        for (Value v : this._vals) {
            Value thatV;
            String propName = v.getProperty();
            Value thisV = this.getValue(propName);
            if (thisV.equals(thatV = conf.getValue(propName))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 0;
        for (Value v : this._vals) {
            hash += v.hashCode();
        }
        return hash;
    }

    public static String toXMLName(String propName) {
        if (propName == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < propName.length(); ++i) {
            char c = propName.charAt(i);
            if (i != 0 && Character.isUpperCase(c) && (Character.isLowerCase(propName.charAt(i - 1)) || i > 1 && i < propName.length() - 1 && Character.isUpperCase(propName.charAt(i - 1)) && Character.isLowerCase(propName.charAt(i + 1)))) {
                buf.append('-');
            }
            if (i != 0 && (!Character.isLetter(c) && Character.isLetter(propName.charAt(i - 1)) || Character.isLetter(c) && !Character.isLetter(propName.charAt(i - 1)))) {
                buf.append('-');
            }
            buf.append(Character.toLowerCase(c));
        }
        return buf.toString();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fromProperties((Map)in.readObject());
        this._props = (Map)in.readObject();
        this._globals = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.toProperties(true));
        out.writeObject(this._props);
        out.writeBoolean(this._globals);
    }

    @Override
    public Object clone() {
        try {
            Constructor<?> cons = this.getClass().getConstructor(Boolean.TYPE);
            ConfigurationImpl clone = (ConfigurationImpl)cons.newInstance(Boolean.FALSE);
            clone.fromProperties(this.toProperties(true));
            clone._props = this._props == null ? null : new HashMap(this._props);
            clone._globals = this._globals;
            return clone;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    @Override
    public boolean removeValue(Value val) {
        if (!this._vals.remove(val)) {
            return false;
        }
        val.removeListener(this);
        return true;
    }

    @Override
    public <T extends Value> T addValue(T val) {
        this._vals.add(val);
        val.addListener(this);
        return val;
    }

    public StringValue addString(String property) {
        StringValue val = new StringValue(property);
        this.addValue(val);
        return val;
    }

    public FileValue addFile(String property) {
        FileValue val = new FileValue(property);
        this.addValue(val);
        return val;
    }

    public IntValue addInt(String property) {
        IntValue val = new IntValue(property);
        this.addValue(val);
        return val;
    }

    public DoubleValue addDouble(String property) {
        DoubleValue val = new DoubleValue(property);
        this.addValue(val);
        return val;
    }

    public BooleanValue addBoolean(String property) {
        BooleanValue val = new BooleanValue(property);
        this.addValue(val);
        val.setDefault("false");
        return val;
    }

    public StringListValue addStringList(String property) {
        StringListValue val = new StringListValue(property);
        this.addValue(val);
        return val;
    }

    public ObjectValue addObject(String property) {
        ObjectValue val = new ObjectValue(property);
        this.addValue(val);
        return val;
    }

    public PluginValue addPlugin(String property, boolean singleton) {
        PluginValue val = new PluginValue(property, singleton);
        this.addValue(val);
        return val;
    }

    public PluginListValue addPluginList(String property) {
        PluginListValue val = new PluginListValue(property);
        this.addValue(val);
        return val;
    }

    @Override
    public ClassLoader getUserClassLoader() {
        return this._userCL;
    }

    @Override
    public void setUserClassLoader(ClassLoader cl) {
        this._userCL = cl;
    }
}

