/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.rop;

import java.util.List;
import org.apache.commons.lang.exception.NestableRuntimeException;
import org.apache.openjpa.lib.rop.ResultObjectProvider;
import org.apache.openjpa.lib.util.Closeable;

public class ListResultObjectProvider
implements ResultObjectProvider {
    private final List _list;
    private int _idx = -1;

    public ListResultObjectProvider(List list) {
        this._list = list;
    }

    public List getDelegate() {
        return this._list;
    }

    @Override
    public boolean supportsRandomAccess() {
        return true;
    }

    @Override
    public void open() throws Exception {
    }

    @Override
    public Object getResultObject() throws Exception {
        return this._list.get(this._idx);
    }

    @Override
    public boolean next() throws Exception {
        return this.absolute(this._idx + 1);
    }

    @Override
    public boolean absolute(int pos) throws Exception {
        if (pos >= 0 && pos < this._list.size()) {
            this._idx = pos;
            return true;
        }
        return false;
    }

    @Override
    public int size() throws Exception {
        return this._list.size();
    }

    @Override
    public void reset() throws Exception {
        this._idx = -1;
    }

    @Override
    public void close() throws Exception {
        if (this._list instanceof Closeable) {
            try {
                ((Closeable)((Object)this._list)).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void handleCheckedException(Exception e) {
        throw new NestableRuntimeException((Throwable)e);
    }
}

