/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.persistence.CacheRetrieveMode;
import javax.persistence.CacheStoreMode;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.kernel.DataCacheRetrieveMode;
import org.apache.openjpa.kernel.DataCacheStoreMode;

public class JPAProperties {
    private static final String REGEX_DOT = "\\.";
    public static final String PREFIX = "javax.persistence.";
    public static final String PROVIDER = "javax.persistence.provider";
    public static final String TRANSACTION_TYPE = "javax.persistence.transactionType";
    public static final String DATASOURCE = "javax.persistence.dataSource";
    public static final String DATASOURCE_JTA = "javax.persistence.jtaDataSource";
    public static final String DATASOURCE_NONJTA = "javax.persistence.nonJtaDataSource";
    public static final String JDBC_DRIVER = "javax.persistence.jdbc.driver";
    public static final String JDBC_URL = "javax.persistence.jdbc.url";
    public static final String JDBC_USER = "javax.persistence.jdbc.user";
    public static final String JDBC_PASSWORD = "javax.persistence.jdbc.password";
    public static final String LOCK_SCOPE = "javax.persistence.lock.scope";
    public static final String LOCK_TIMEOUT = "javax.persistence.lock.timeout";
    public static final String QUERY_TIMEOUT = "javax.persistence.query.timeout";
    public static final String CACHE_MODE = "javax.persistence.sharedCache.mode";
    public static final String CACHE_STORE_MODE = "javax.persistence.cache.storeMode";
    public static final String CACHE_RETRIEVE_MODE = "javax.persistence.cache.retrieveMode";
    public static final String VALIDATE_FACTORY = "javax.persistence.validation.factory";
    public static final String VALIDATE_MODE = "javax.persistence.validation.mode";
    public static final String VALIDATE_PRE_PERSIST = "javax.persistence.validation.group.pre-persist";
    public static final String VALIDATE_PRE_REMOVE = "javax.persistence.validation.group.pre-remove";
    public static final String VALIDATE_PRE_UPDATE = "javax.persistence.validation.group.pre-update";
    public static final String VALIDATE_GROUP_DEFAULT = "javax.validation.groups.Default";
    private static Map<String, String> _names = new HashMap<String, String>();

    static void record(String kernel, String user) {
        _names.put(kernel, user);
    }

    static String getUserName(String beanProperty) {
        return _names.containsKey(beanProperty) ? _names.get(beanProperty) : beanProperty;
    }

    public static boolean isValidKey(String key) {
        return key != null && key.startsWith(PREFIX);
    }

    public static String getBeanProperty(String key) {
        if (!JPAProperties.isValidKey(key)) {
            throw new IllegalArgumentException("Invalid JPA property " + key);
        }
        String[] parts = key.split(REGEX_DOT);
        StringBuilder buf = new StringBuilder();
        for (int i = 2; i < parts.length; ++i) {
            buf.append(StringUtils.capitalize((String)parts[i]));
        }
        return buf.toString();
    }

    public static <T> T convertToKernelValue(Class<T> resultType, String key, Object value) {
        if (value == null) {
            return null;
        }
        if (JPAProperties.isValidKey(key)) {
            if (value instanceof CacheRetrieveMode || value instanceof String && CACHE_RETRIEVE_MODE.equals(key)) {
                return (T)((Object)DataCacheRetrieveMode.valueOf(value.toString().trim().toUpperCase(Locale.ENGLISH)));
            }
            if (value instanceof CacheStoreMode || value instanceof String && CACHE_STORE_MODE.equals(key)) {
                return (T)((Object)DataCacheStoreMode.valueOf(value.toString().trim().toUpperCase(Locale.ENGLISH)));
            }
        }
        return (T)value;
    }

    public static Object convertToUserValue(String key, Object value) {
        if (value == null) {
            return null;
        }
        if (JPAProperties.isValidKey(key)) {
            if (value instanceof DataCacheRetrieveMode) {
                return CacheRetrieveMode.valueOf((String)value.toString().trim().toUpperCase(Locale.ENGLISH));
            }
            if (value instanceof DataCacheStoreMode) {
                return CacheStoreMode.valueOf((String)value.toString().trim().toUpperCase(Locale.ENGLISH));
            }
        }
        return value;
    }

    public static <E extends Enum<E>> E getEnumValue(Class<E> type, String key, Map<String, Object> prop) {
        return (E)JPAProperties.getEnumValue(type, null, (String)key, prop);
    }

    public static <E extends Enum<E>> E getEnumValue(Class<E> type, E[] values, String key, Map<String, Object> prop) {
        if (prop == null) {
            return null;
        }
        return (E)JPAProperties.getEnumValue(type, values, (Object)prop.get(key));
    }

    public static <E extends Enum<E>> E getEnumValue(Class<E> type, Object val) {
        return (E)JPAProperties.getEnumValue(type, null, (Object)val);
    }

    public static <E extends Enum<E>> E getEnumValue(Class<E> type, E[] values, Object val) {
        if (val == null) {
            return null;
        }
        if (type.isInstance(val)) {
            return (E)((Enum)val);
        }
        if (val instanceof String) {
            return Enum.valueOf(type, val.toString().trim().toUpperCase(Locale.ENGLISH));
        }
        if (values != null && values.length > 0 && val instanceof Number) {
            return values[((Number)val).intValue()];
        }
        return null;
    }
}

