/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.asm6.commons;

import java.util.List;
import org.apache.xbean.asm6.AnnotationVisitor;
import org.apache.xbean.asm6.Attribute;
import org.apache.xbean.asm6.ClassVisitor;
import org.apache.xbean.asm6.FieldVisitor;
import org.apache.xbean.asm6.MethodVisitor;
import org.apache.xbean.asm6.ModuleVisitor;
import org.apache.xbean.asm6.TypePath;
import org.apache.xbean.asm6.commons.AnnotationRemapper;
import org.apache.xbean.asm6.commons.FieldRemapper;
import org.apache.xbean.asm6.commons.MethodRemapper;
import org.apache.xbean.asm6.commons.ModuleHashesAttribute;
import org.apache.xbean.asm6.commons.ModuleRemapper;
import org.apache.xbean.asm6.commons.Remapper;

public class ClassRemapper
extends ClassVisitor {
    protected final Remapper remapper;
    protected String className;

    public ClassRemapper(ClassVisitor cv, Remapper remapper) {
        this(393216, cv, remapper);
    }

    protected ClassRemapper(int api, ClassVisitor cv, Remapper remapper) {
        super(api, cv);
        this.remapper = remapper;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name;
        super.visit(version, access, this.remapper.mapType(name), this.remapper.mapSignature(signature, false), this.remapper.mapType(superName), interfaces == null ? null : this.remapper.mapTypes(interfaces));
    }

    public ModuleVisitor visitModule(String name, int flags, String version) {
        ModuleVisitor mv = super.visitModule(this.remapper.mapModuleName(name), flags, version);
        return mv == null ? null : this.createModuleRemapper(mv);
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        AnnotationVisitor av = super.visitAnnotation(this.remapper.mapDesc(desc), visible);
        return av == null ? null : this.createAnnotationRemapper(av);
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        AnnotationVisitor av = super.visitTypeAnnotation(typeRef, typePath, this.remapper.mapDesc(desc), visible);
        return av == null ? null : this.createAnnotationRemapper(av);
    }

    public void visitAttribute(Attribute attr) {
        if (attr instanceof ModuleHashesAttribute) {
            ModuleHashesAttribute hashesAttr = new ModuleHashesAttribute();
            List<String> modules = hashesAttr.modules;
            for (int i = 0; i < modules.size(); ++i) {
                modules.set(i, this.remapper.mapModuleName(modules.get(i)));
            }
        }
        super.visitAttribute(attr);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        FieldVisitor fv = super.visitField(access, this.remapper.mapFieldName(this.className, name, desc), this.remapper.mapDesc(desc), this.remapper.mapSignature(signature, true), this.remapper.mapValue(value));
        return fv == null ? null : this.createFieldRemapper(fv);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        String newDesc = this.remapper.mapMethodDesc(desc);
        MethodVisitor mv = super.visitMethod(access, this.remapper.mapMethodName(this.className, name, desc), newDesc, this.remapper.mapSignature(signature, false), exceptions == null ? null : this.remapper.mapTypes(exceptions));
        return mv == null ? null : this.createMethodRemapper(mv);
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        super.visitInnerClass(this.remapper.mapType(name), outerName == null ? null : this.remapper.mapType(outerName), innerName, access);
    }

    public void visitOuterClass(String owner, String name, String desc) {
        super.visitOuterClass(this.remapper.mapType(owner), name == null ? null : this.remapper.mapMethodName(owner, name, desc), desc == null ? null : this.remapper.mapMethodDesc(desc));
    }

    protected FieldVisitor createFieldRemapper(FieldVisitor fv) {
        return new FieldRemapper(this.api, fv, this.remapper);
    }

    protected MethodVisitor createMethodRemapper(MethodVisitor mv) {
        return new MethodRemapper(this.api, mv, this.remapper);
    }

    protected AnnotationVisitor createAnnotationRemapper(AnnotationVisitor av) {
        return new AnnotationRemapper(this.api, av, this.remapper);
    }

    protected ModuleVisitor createModuleRemapper(ModuleVisitor mv) {
        return new ModuleRemapper(this.api, mv, this.remapper);
    }
}

