/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.fastagi.internal;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import org.asteriskjava.fastagi.AgiException;
import org.asteriskjava.fastagi.AgiReader;
import org.asteriskjava.fastagi.AgiRequest;
import org.asteriskjava.fastagi.internal.AgiReplyImpl;
import org.asteriskjava.fastagi.internal.AgiRequestImpl;
import org.asteriskjava.fastagi.reply.AgiReply;
import org.asteriskjava.manager.ManagerConnection;
import org.asteriskjava.manager.event.AsyncAgiEvent;

public class AsyncAgiReader
implements AgiReader {
    private final AgiRequestImpl request;
    private final BlockingQueue<AsyncAgiEvent> asyncAgiEvents;

    public AsyncAgiReader(ManagerConnection connection, List<String> environment, BlockingQueue<AsyncAgiEvent> asyncAgiEvents) {
        this.request = new AgiRequestImpl(environment);
        this.asyncAgiEvents = asyncAgiEvents;
        this.request.setLocalAddress(connection.getLocalAddress());
        this.request.setLocalPort(connection.getLocalPort());
        this.request.setRemoteAddress(connection.getRemoteAddress());
        this.request.setRemotePort(connection.getRemotePort());
    }

    @Override
    public AgiRequest readRequest() throws AgiException {
        return this.request;
    }

    @Override
    public AgiReply readReply() throws AgiException {
        try {
            return new AgiReplyImpl(this.asyncAgiEvents.take().decodeResult());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new AgiException("Interrupted while waiting for AsyncAgiEvent", e);
        }
    }
}

