/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.custom.SchemaCodec;
import com.hazelcast.internal.serialization.impl.compact.Schema;
import javax.annotation.Nullable;

public final class ClientFetchSchemaCodec {
    public static final int REQUEST_MESSAGE_TYPE = 5120;
    public static final int RESPONSE_MESSAGE_TYPE = 5121;
    private static final int REQUEST_SCHEMA_ID_FIELD_OFFSET = 16;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 24;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 13;

    private ClientFetchSchemaCodec() {
    }

    public static ClientMessage encodeRequest(long schemaId) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(true);
        clientMessage.setOperationName("Client.FetchSchema");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[24], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 5120);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 16, schemaId);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static long decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ClientMessage.Frame initialFrame = iterator.next();
        return FixedSizeTypesCodec.decodeLong(initialFrame.content, 16);
    }

    public static ClientMessage encodeResponse(@Nullable Schema schema) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[13], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 5121);
        clientMessage.add(initialFrame);
        CodecUtil.encodeNullable(clientMessage, schema, SchemaCodec::encode);
        return clientMessage;
    }

    public static Schema decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        iterator.next();
        return CodecUtil.decodeNullable(iterator, SchemaCodec::decode);
    }
}

