/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tpcengine;

import com.hazelcast.internal.tpcengine.Eventloop;
import com.hazelcast.internal.tpcengine.PromiseAllocator;
import com.hazelcast.internal.tpcengine.util.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;

public class Promise<E> {
    private static final Object EMPTY = new Object();
    int refCount = 1;
    PromiseAllocator allocator;
    private Object value = EMPTY;
    private final Eventloop eventloop;
    private final List<BiConsumer<E, Throwable>> consumers = new ArrayList<BiConsumer<E, Throwable>>();
    private boolean exceptional;
    private boolean releaseOnComplete;

    public Promise(Eventloop eventloop) {
        this.eventloop = Preconditions.checkNotNull(eventloop);
    }

    public boolean isDone() {
        return this.value != EMPTY;
    }

    public boolean isCompletedExceptionally() {
        return this.value != EMPTY && this.exceptional;
    }

    public void releaseOnComplete() {
        this.releaseOnComplete = true;
        if (this.value != EMPTY) {
            this.release();
        }
    }

    public void completeExceptionally(Throwable value) {
        Preconditions.checkNotNull(value);
        if (this.value != EMPTY) {
            throw new IllegalStateException("Promise is already completed");
        }
        this.value = value;
        this.exceptional = true;
        for (BiConsumer<E, Throwable> consumer : this.consumers) {
            try {
                consumer.accept(null, value);
            }
            catch (Exception e) {
                this.eventloop.logger.warning(e);
            }
        }
        if (this.releaseOnComplete) {
            this.release();
        }
    }

    public void complete(E value) {
        if (this.value != EMPTY) {
            throw new IllegalStateException("Promise is already completed");
        }
        this.value = value;
        this.exceptional = false;
        for (BiConsumer<E, Throwable> consumer : this.consumers) {
            try {
                consumer.accept(value, null);
            }
            catch (Exception e) {
                this.eventloop.logger.warning(e);
            }
        }
        if (this.releaseOnComplete) {
            this.release();
        }
    }

    public <T extends Throwable> Promise then(BiConsumer<E, T> consumer) {
        Preconditions.checkNotNull(consumer, "consumer");
        if (this.value == EMPTY) {
            this.consumers.add(consumer);
        } else if (this.exceptional) {
            consumer.accept(null, (Throwable)this.value);
        } else {
            consumer.accept(this.value, null);
        }
        return this;
    }

    public void acquire() {
        if (this.refCount == 0) {
            throw new IllegalStateException();
        }
        ++this.refCount;
    }

    public void release() {
        if (this.refCount == 0) {
            throw new IllegalStateException();
        }
        if (this.refCount == 1) {
            this.refCount = 0;
            this.value = EMPTY;
            this.consumers.clear();
            this.releaseOnComplete = false;
            if (this.allocator != null) {
                this.allocator.free(this);
            }
        } else {
            --this.refCount;
        }
    }
}

