/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tpcengine.net;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;

public class AsyncSocketMetrics {
    private static final VarHandle BYTES_READ;
    private static final VarHandle BYTES_WRITTEN;
    private static final VarHandle WRITE_EVENTS;
    private static final VarHandle READ_EVENTS;
    private volatile long bytesRead;
    private volatile long bytesWritten;
    private volatile long writeEvents;
    private volatile long readEvents;

    public long bytesRead() {
        return BYTES_READ.getOpaque(this);
    }

    public void incBytesRead(long delta) {
        BYTES_READ.setOpaque(this, BYTES_READ.getOpaque(this) + delta);
    }

    public long bytesWritten() {
        return BYTES_WRITTEN.getOpaque(this);
    }

    public void incBytesWritten(long delta) {
        BYTES_WRITTEN.setOpaque(this, BYTES_WRITTEN.getOpaque(this) + delta);
    }

    public long writeEvents() {
        return WRITE_EVENTS.getOpaque(this);
    }

    public void incWriteEvents() {
        WRITE_EVENTS.setOpaque(this, WRITE_EVENTS.getOpaque(this) + 1L);
    }

    public long readEvents() {
        return READ_EVENTS.getOpaque(this);
    }

    public void incReadEvents() {
        READ_EVENTS.setOpaque(this, READ_EVENTS.getOpaque(this) + 1L);
    }

    static {
        try {
            MethodHandles.Lookup l = MethodHandles.lookup();
            BYTES_READ = l.findVarHandle(AsyncSocketMetrics.class, "bytesRead", Long.TYPE);
            BYTES_WRITTEN = l.findVarHandle(AsyncSocketMetrics.class, "bytesWritten", Long.TYPE);
            WRITE_EVENTS = l.findVarHandle(AsyncSocketMetrics.class, "writeEvents", Long.TYPE);
            READ_EVENTS = l.findVarHandle(AsyncSocketMetrics.class, "readEvents", Long.TYPE);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

