/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.CustomTypeFactory;
import com.hazelcast.client.impl.protocol.codec.builtin.DataCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListMultiFrameCodec;
import com.hazelcast.client.impl.protocol.codec.custom.VectorPairCodec;
import com.hazelcast.client.impl.protocol.codec.holder.VectorPairHolder;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.vector.impl.DataVectorDocument;
import java.util.List;

public final class VectorDocumentCodec {
    private VectorDocumentCodec() {
    }

    public static void encode(ClientMessage clientMessage, DataVectorDocument vectorDocument) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        DataCodec.encode(clientMessage, vectorDocument.getValue());
        ListMultiFrameCodec.encode(clientMessage, vectorDocument.getVectors(), VectorPairCodec::encode);
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static DataVectorDocument decode(ClientMessage.ForwardFrameIterator iterator) {
        iterator.next();
        Data value = DataCodec.decode(iterator);
        List<VectorPairHolder> vectors = ListMultiFrameCodec.decode(iterator, VectorPairCodec::decode);
        CodecUtil.fastForwardToEndFrame(iterator);
        return CustomTypeFactory.createVectorDocument(value, vectors);
    }
}

