/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.connector;

import com.hazelcast.dataconnection.impl.JdbcDataConnection;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.core.AbstractProcessor;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.function.ToResultSetFunction;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.pipeline.DataConnectionRef;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.sql.DataSource;

public final class ReadJdbcP<T>
extends AbstractProcessor {
    private static final ILogger LOGGER = Logger.getLogger(ReadJdbcP.class);
    private final SupplierEx<? extends Connection> newConnectionFn;
    private final ToResultSetFunction resultSetFn;
    private final FunctionEx<? super ResultSet, ? extends T> mapOutputFn;
    private Connection connection;
    private ResultSet resultSet;
    private Traverser<? extends T> traverser;
    private int parallelism;
    private int index;

    public ReadJdbcP(@Nonnull SupplierEx<? extends Connection> newConnectionFn, @Nonnull ToResultSetFunction resultSetFn, @Nonnull FunctionEx<? super ResultSet, ? extends T> mapOutputFn) {
        this.newConnectionFn = newConnectionFn;
        this.resultSetFn = resultSetFn;
        this.mapOutputFn = mapOutputFn;
    }

    @Override
    public boolean isCooperative() {
        return false;
    }

    public static <T> ProcessorMetaSupplier supplier(@Nonnull SupplierEx<? extends DataSource> newDataSourceFn, @Nonnull ToResultSetFunction resultSetFn, @Nonnull FunctionEx<? super ResultSet, ? extends T> mapOutputFn) {
        return ReadJdbcP.supplier((ProcessorSupplier.Context ctx) -> ((DataSource)newDataSourceFn.get()).getConnection(), resultSetFn, mapOutputFn);
    }

    public static <T> ProcessorMetaSupplier supplier(@Nonnull FunctionEx<ProcessorSupplier.Context, ? extends Connection> newConnectionFn, @Nonnull ToResultSetFunction resultSetFn, @Nonnull FunctionEx<? super ResultSet, ? extends T> mapOutputFn) {
        Util.checkSerializable(newConnectionFn, "newConnectionFn");
        Util.checkSerializable(resultSetFn, "resultSetFn");
        Util.checkSerializable(mapOutputFn, "mapOutputFn");
        return ProcessorMetaSupplier.preferLocalParallelismOne(ReadJdbcP.readJdbcProcessorFn(newConnectionFn, resultSetFn, mapOutputFn));
    }

    public static <T> ProcessorMetaSupplier supplier(@Nonnull String connectionURL, @Nonnull String query, @Nonnull Properties properties, @Nonnull FunctionEx<? super ResultSet, ? extends T> mapOutputFn) {
        Util.checkSerializable(mapOutputFn, "mapOutputFn");
        return ProcessorMetaSupplier.forceTotalParallelismOne(ReadJdbcP.readJdbcProcessorFn(context -> DriverManager.getConnection(connectionURL), (connection, parallelism, index) -> {
            ReadJdbcP.setAutoCommitIfNecessary(connection, properties);
            PreparedStatement preparedStatement = connection.prepareStatement(query);
            try {
                ReadJdbcP.setFetchSizeIfNecessary(preparedStatement, properties);
                return preparedStatement.executeQuery();
            }
            catch (SQLException e) {
                preparedStatement.close();
                throw e;
            }
        }, mapOutputFn), UuidUtil.newUnsecureUuidString());
    }

    public static <T> ProcessorMetaSupplier supplier(final DataConnectionRef dataConnectionRef, final ToResultSetFunction resultSetFn, final FunctionEx<? super ResultSet, ? extends T> mapOutputFn) {
        return ProcessorMetaSupplier.preferLocalParallelismOne(new ProcessorSupplier(){
            private static final long serialVersionUID = 1L;
            private transient JdbcDataConnection dataConnection;

            @Override
            public void init(@Nonnull ProcessorSupplier.Context context) {
                this.dataConnection = context.dataConnectionService().getAndRetainDataConnection(dataConnectionRef.getName(), JdbcDataConnection.class);
            }

            @Override
            @Nonnull
            public Collection<? extends Processor> get(int count) {
                return IntStream.range(0, count).mapToObj(i -> new ReadJdbcP(() -> this.dataConnection.getConnection(), resultSetFn, mapOutputFn)).collect(Collectors.toList());
            }

            @Override
            public void close(@Nullable Throwable error) {
                if (this.dataConnection != null) {
                    this.dataConnection.release();
                }
            }
        });
    }

    private static <T> ProcessorSupplier readJdbcProcessorFn(final FunctionEx<ProcessorSupplier.Context, ? extends Connection> newConnectionFn, final ToResultSetFunction resultSetFn, final FunctionEx<? super ResultSet, ? extends T> mapOutputFn) {
        return new ProcessorSupplier(){
            private static final long serialVersionUID = 1L;
            private transient ProcessorSupplier.Context context;

            @Override
            public void init(@Nonnull ProcessorSupplier.Context context) {
                this.context = context;
            }

            @Override
            @Nonnull
            public Collection<? extends Processor> get(int count) {
                return IntStream.range(0, count).mapToObj(i -> new ReadJdbcP(() -> (Connection)newConnectionFn.apply(this.context), resultSetFn, mapOutputFn)).collect(Collectors.toList());
            }
        };
    }

    @Override
    protected void init(@Nonnull Processor.Context context) {
        this.connection = this.newConnectionFn.get();
        this.parallelism = context.totalParallelism();
        this.index = context.globalProcessorIndex();
    }

    @Override
    public boolean complete() {
        if (this.traverser == null) {
            this.resultSet = Util.uncheckCall(() -> this.resultSetFn.createResultSet(this.connection, this.parallelism, this.index));
            Traverser<ResultSet> t = () -> Util.uncheckCall(() -> this.resultSet.next() ? this.resultSet : null);
            this.traverser = t.map(this.mapOutputFn);
        }
        return this.emitFromTraverser(this.traverser);
    }

    @Override
    public void close() throws Exception {
        Exception resultSetException = null;
        Exception statementException = null;
        if (this.resultSet != null) {
            Statement statement = this.resultSet.getStatement();
            resultSetException = ReadJdbcP.close(this.resultSet);
            if (statement != null) {
                statementException = ReadJdbcP.close(statement);
            }
        }
        if (this.connection != null) {
            this.connection.close();
        }
        if (resultSetException != null) {
            throw resultSetException;
        }
        if (statementException != null) {
            throw statementException;
        }
    }

    private static Exception close(AutoCloseable closeable) {
        try {
            closeable.close();
        }
        catch (Exception e) {
            return e;
        }
        return null;
    }

    private static void setAutoCommitIfNecessary(Connection connection, Properties properties) throws SQLException {
        String key = "autoCommit";
        if (properties.containsKey(key)) {
            String value = properties.getProperty(key);
            if (StringUtil.isBoolean(value)) {
                boolean autoCommit = Boolean.parseBoolean(value);
                connection.setAutoCommit(autoCommit);
            } else {
                throw new IllegalArgumentException("Invalid boolean value specified for autoCommit: " + value);
            }
        }
    }

    private static void setFetchSizeIfNecessary(PreparedStatement statement, Properties properties) throws SQLException {
        String key = "fetchSize";
        if (properties.containsKey(key)) {
            String value = properties.getProperty(key);
            try {
                int fetchSize = Integer.parseInt(value);
                statement.setFetchSize(fetchSize);
            }
            catch (NumberFormatException exception) {
                LOGGER.severe("Invalid integer value specified for fetchSize: " + value, exception);
                throw exception;
            }
        }
    }

    static {
        DriverManager.getDrivers();
    }
}

