/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.cursor;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.constants.Loggers;
import org.apache.directory.api.ldap.model.cursor.AbstractCursor;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListCursor<E>
extends AbstractCursor<E> {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger((String)Loggers.CURSOR_LOG.getName());
    private final List<E> list;
    private final Comparator<E> comparator;
    private final int start;
    private final int end;
    private int index = -1;

    public ListCursor(Comparator<E> comparator, int start, List<E> list, int end) {
        if (list == null) {
            list = Collections.emptyList();
        }
        if (start < 0 || start > list.size()) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_13105_START_INDEX_OUT_OF_RANGE, start));
        }
        if (end < 0 || end > list.size()) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_13106_END_INDEX_OUT_OF_RANGE, end));
        }
        if (!list.isEmpty() && start >= end) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_13107_START_INDEX_ABOVE_END_INDEX, start, end));
        }
        if (LOG_CURSOR.isDebugEnabled()) {
            LOG_CURSOR.debug(I18n.msg(I18n.MSG_13104_CREATING_LIST_CURSOR, this));
        }
        this.comparator = comparator;
        this.list = list;
        this.start = start;
        this.end = end;
    }

    public ListCursor(int start, List<E> list, int end) {
        this(null, start, list, end);
    }

    public ListCursor(List<E> list, int end) {
        this(null, 0, list, end);
    }

    public ListCursor(Comparator<E> comparator, List<E> list, int end) {
        this(comparator, 0, list, end);
    }

    public ListCursor(int start, List<E> list) {
        this(null, start, list, list.size());
    }

    public ListCursor(Comparator<E> comparator, int start, List<E> list) {
        this(comparator, start, list, list.size());
    }

    public ListCursor(List<E> list) {
        this(null, 0, list, list.size());
    }

    public ListCursor(Comparator<E> comparator, List<E> list) {
        this(comparator, 0, list, list.size());
    }

    public ListCursor() {
        this(null, 0, Collections.EMPTY_LIST, 0);
    }

    public ListCursor(Comparator<E> comparator) {
        this(comparator, 0, Collections.EMPTY_LIST, 0);
    }

    @Override
    public boolean available() {
        return this.index >= 0 && this.index < this.end;
    }

    @Override
    public void before(E element) throws LdapException, CursorException {
        this.checkNotClosed();
        if (this.comparator == null) {
            throw new IllegalStateException();
        }
        if (this.list.isEmpty()) {
            return;
        }
        if (this.list.size() == 1) {
            if (this.comparator.compare(element, this.list.get(0)) <= 0) {
                this.beforeFirst();
            } else {
                this.afterLast();
            }
        }
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_13108_LIST_MAY_BE_SORTED, new Object[0]));
    }

    @Override
    public void after(E element) throws LdapException, CursorException {
        this.checkNotClosed();
        if (this.comparator == null) {
            throw new IllegalStateException();
        }
        if (this.list.isEmpty()) {
            return;
        }
        if (this.list.size() == 1) {
            if (this.comparator.compare(element, this.list.get(0)) >= 0) {
                this.afterLast();
            } else {
                this.beforeFirst();
            }
        }
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_13108_LIST_MAY_BE_SORTED, new Object[0]));
    }

    @Override
    public void beforeFirst() throws LdapException, CursorException {
        this.checkNotClosed();
        this.index = -1;
    }

    @Override
    public void afterLast() throws LdapException, CursorException {
        this.checkNotClosed();
        this.index = this.end;
    }

    @Override
    public boolean first() throws LdapException, CursorException {
        this.checkNotClosed();
        if (!this.list.isEmpty()) {
            this.index = this.start;
            return true;
        }
        return false;
    }

    @Override
    public boolean last() throws LdapException, CursorException {
        this.checkNotClosed();
        if (!this.list.isEmpty()) {
            this.index = this.end - 1;
            return true;
        }
        return false;
    }

    @Override
    public boolean isFirst() {
        return !this.list.isEmpty() && this.index == this.start;
    }

    @Override
    public boolean isLast() {
        return !this.list.isEmpty() && this.index == this.end - 1;
    }

    @Override
    public boolean isAfterLast() {
        return this.index == this.end;
    }

    @Override
    public boolean isBeforeFirst() {
        return this.index == -1;
    }

    @Override
    public boolean previous() throws LdapException, CursorException {
        this.checkNotClosed();
        if (this.index == -1) {
            return false;
        }
        if (this.index - 1 >= this.start) {
            --this.index;
            return true;
        }
        if (this.index <= this.start) {
            this.index = -1;
            return false;
        }
        if (this.list.isEmpty()) {
            this.index = -1;
        }
        return false;
    }

    @Override
    public boolean next() throws LdapException, CursorException {
        this.checkNotClosed();
        if (!this.list.isEmpty() && this.index == -1) {
            this.index = this.start;
            return true;
        }
        if (!this.list.isEmpty() && this.index + 1 < this.end) {
            ++this.index;
            return true;
        }
        if (!this.list.isEmpty() && this.index + 1 == this.end) {
            ++this.index;
            return false;
        }
        if (this.list.isEmpty()) {
            this.index = this.end;
        }
        return false;
    }

    @Override
    public E get() throws CursorException {
        this.checkNotClosed();
        if (this.index < this.start || this.index >= this.end) {
            throw new CursorException(I18n.err(I18n.ERR_13109_CURSOR_NOT_POSITIONED, new Object[0]));
        }
        return this.list.get(this.index);
    }

    @Override
    public void close() throws IOException {
        if (LOG_CURSOR.isDebugEnabled()) {
            LOG_CURSOR.debug(I18n.msg(I18n.MSG_13101_CLOSING_LIST_CURSOR, this));
        }
        super.close();
    }

    @Override
    public void close(Exception cause) throws IOException {
        if (LOG_CURSOR.isDebugEnabled()) {
            LOG_CURSOR.debug(I18n.msg(I18n.MSG_13101_CLOSING_LIST_CURSOR, this));
        }
        super.close(cause);
    }
}

