/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.core.office;

import org.jodconverter.core.office.RetryTimeoutException;
import org.jodconverter.core.office.TemporaryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRetryable<T extends Throwable> {
    private static final long NO_SLEEP = 0L;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected AbstractRetryable() {
    }

    protected abstract void attempt() throws TemporaryException, T;

    public void execute(long interval, long timeout) throws RetryTimeoutException, T {
        this.execute(0L, interval, timeout);
    }

    public void execute(long delay, long interval, long timeout) throws RetryTimeoutException, T {
        long start = System.currentTimeMillis();
        int attempt = 0;
        if (delay > 0L) {
            this.sleep(delay);
        }
        while (true) {
            ++attempt;
            try {
                this.logger.debug("Execution attempt #{}", (Object)attempt);
                this.attempt();
                this.logger.debug("Execution succeeded on attempt #{}", (Object)attempt);
                return;
            }
            catch (TemporaryException temporaryException) {
                if (System.currentTimeMillis() - start < timeout) {
                    if (interval > 0L) {
                        this.logger.debug("Execution attempt #{} failed, retrying after sleep of {} ms", (Object)attempt, (Object)interval);
                        this.sleep(interval);
                        continue;
                    }
                    this.logger.debug("Execution attempt #{} failed, retrying without sleep", (Object)attempt);
                    continue;
                }
                this.logger.debug("Execution failed on attempt #{}", (Object)attempt);
                throw new RetryTimeoutException(temporaryException.getCause());
            }
            break;
        }
    }

    private void sleep(long millis) throws RetryTimeoutException {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RetryTimeoutException(ex);
        }
    }
}

