/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.jsonrpc.internal.client;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.kurento.jsonrpc.Session;
import org.kurento.jsonrpc.client.RequestAlreadyRespondedException;
import org.kurento.jsonrpc.internal.client.AbstractTransaction;
import org.kurento.jsonrpc.message.Message;
import org.kurento.jsonrpc.message.Request;
import org.kurento.jsonrpc.message.Response;

public class TransactionImpl
extends AbstractTransaction {
    private final AtomicBoolean responded = new AtomicBoolean(false);
    private final ResponseSender responseSender;

    public TransactionImpl(Session session, Request<?> request, ResponseSender responseSender) {
        super(session, request);
        this.responseSender = responseSender;
    }

    public boolean setRespondedIfNot() {
        return this.responded.compareAndSet(false, true);
    }

    @Override
    protected void internalSendResponse(Response<? extends Object> response) throws IOException {
        boolean notResponded = this.setRespondedIfNot();
        if (notResponded) {
            if (response.getSessionId() == null) {
                response.setSessionId(this.session.getSessionId());
            }
            if (response.getId() == null) {
                response.setId(this.request.getId());
            }
        } else {
            throw new RequestAlreadyRespondedException("This request has already been responded");
        }
        this.responseSender.sendResponse(response);
    }

    public static interface ResponseSender {
        public void sendResponse(Message var1) throws IOException;

        public void sendPingResponse(Message var1) throws IOException;
    }
}

