/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.cli;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.cli.Option;

public class OmOption
extends Option {
    private static final long serialVersionUID = 1L;
    private String group = null;
    private Map<String, Boolean> optional = null;
    private int order = 0;
    private String helpPrefix = "";

    public OmOption(String group, String opt, String longOpt, boolean hasArg, String description, boolean optional) {
        this(group, 0, opt, longOpt, hasArg, description);
        this.setOptional(optional);
    }

    public OmOption(String group, String opt, String longOpt, boolean hasArg, String description, String optional) {
        this(group, 0, opt, longOpt, hasArg, description);
        this.setOptional(optional, true);
    }

    public OmOption(String group, int order, String opt, String longOpt, boolean hasArg, String description) {
        super(opt, longOpt, hasArg, description);
        this.group = group;
        this.setOrder(order);
    }

    public OmOption(String group, String opt, String longOpt, boolean hasArg, String description) {
        this(group, 0, opt, longOpt, hasArg, description);
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public boolean isOptional(String group) {
        boolean result = false;
        if (this.optional != null) {
            String[] grps;
            for (String g : grps = group.split(",")) {
                result |= this.optional.getOrDefault(g, false).booleanValue();
            }
        }
        return result;
    }

    public void setOptional(boolean val) {
        this.setOptional(this.group, val);
    }

    public void setOptional(String group, boolean val) {
        this.optional = Stream.of(group.split(",")).collect(Collectors.toMap(Function.identity(), s -> val));
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public String getHelpPrefix() {
        return this.helpPrefix;
    }

    public void setHelpPrefix(StringBuilder helpPrefix) {
        this.helpPrefix = helpPrefix.toString();
    }

    public void setHelpPrefix(String helpPrefix) {
        this.helpPrefix = helpPrefix;
    }
}

