/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.parser.treeinsert;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import opennlp.tools.chunker.Chunker;
import opennlp.tools.chunker.ChunkerME;
import opennlp.tools.chunker.ChunkerModel;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.ml.EventTrainer;
import opennlp.tools.ml.TrainerFactory;
import opennlp.tools.ml.model.MaxentModel;
import opennlp.tools.parser.AbstractBottomUpParser;
import opennlp.tools.parser.ChunkSampleStream;
import opennlp.tools.parser.HeadRules;
import opennlp.tools.parser.Parse;
import opennlp.tools.parser.ParserChunkerFactory;
import opennlp.tools.parser.ParserEventTypeEnum;
import opennlp.tools.parser.ParserModel;
import opennlp.tools.parser.ParserType;
import opennlp.tools.parser.PosSampleStream;
import opennlp.tools.parser.treeinsert.AttachContextGenerator;
import opennlp.tools.parser.treeinsert.BuildContextGenerator;
import opennlp.tools.parser.treeinsert.CheckContextGenerator;
import opennlp.tools.parser.treeinsert.ParserEventStream;
import opennlp.tools.postag.POSModel;
import opennlp.tools.postag.POSTagger;
import opennlp.tools.postag.POSTaggerFactory;
import opennlp.tools.postag.POSTaggerME;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.TrainingParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Parser
extends AbstractBottomUpParser {
    private static final Logger logger = LoggerFactory.getLogger(Parser.class);
    public static final String DONE = "d";
    public static final String ATTACH_SISTER = "s";
    public static final String ATTACH_DAUGHTER = "d";
    public static final String NON_ATTACH = "n";
    public static final String BUILT = "built";
    private final MaxentModel buildModel;
    private final MaxentModel attachModel;
    private final MaxentModel checkModel;
    static boolean checkComplete = false;
    private final BuildContextGenerator buildContextGenerator;
    private final AttachContextGenerator attachContextGenerator;
    private final CheckContextGenerator checkContextGenerator;
    private final double[] bprobs;
    private final double[] aprobs;
    private double[] cprobs;
    private final int doneIndex;
    private final int sisterAttachIndex;
    private final int daughterAttachIndex;
    private final int nonAttachIndex;
    private final int completeIndex;
    private final int[] attachments;

    public Parser(ParserModel model, int beamSize, double advancePercentage) {
        this(model.getBuildModel(), model.getAttachModel(), model.getCheckModel(), new POSTaggerME(model.getParserTaggerModel()), new ChunkerME(model.getParserChunkerModel()), model.getHeadRules(), beamSize, advancePercentage);
    }

    public Parser(ParserModel model) {
        this(model, 20, 0.95);
    }

    private Parser(MaxentModel buildModel, MaxentModel attachModel, MaxentModel checkModel, POSTagger tagger, Chunker chunker, HeadRules headRules, int beamSize, double advancePercentage) {
        super(tagger, chunker, headRules, beamSize, advancePercentage);
        this.buildModel = buildModel;
        this.attachModel = attachModel;
        this.checkModel = checkModel;
        this.buildContextGenerator = new BuildContextGenerator();
        this.attachContextGenerator = new AttachContextGenerator(this.punctSet);
        this.checkContextGenerator = new CheckContextGenerator(this.punctSet);
        this.bprobs = new double[buildModel.getNumOutcomes()];
        this.aprobs = new double[attachModel.getNumOutcomes()];
        this.cprobs = new double[checkModel.getNumOutcomes()];
        this.doneIndex = buildModel.getIndex("d");
        this.sisterAttachIndex = attachModel.getIndex(ATTACH_SISTER);
        this.daughterAttachIndex = attachModel.getIndex("d");
        this.nonAttachIndex = attachModel.getIndex(NON_ATTACH);
        this.attachments = new int[]{this.daughterAttachIndex, this.sisterAttachIndex};
        this.completeIndex = checkModel.getIndex("c");
    }

    public static List<Parse> getRightFrontier(Parse root, Set<String> punctSet) {
        LinkedList<Parse> rf = new LinkedList<Parse>();
        Parse top = "TOP".equals(root.getType()) || "INC".equals(root.getType()) ? Parser.collapsePunctuation(root.getChildren(), punctSet)[0] : root;
        while (!top.isPosTag()) {
            rf.add(0, top);
            Parse[] kids = top.getChildren();
            top = kids[kids.length - 1];
        }
        return new ArrayList<Parse>(rf);
    }

    private void setBuilt(Parse p) {
        String l = p.getLabel();
        if (l == null) {
            p.setLabel(BUILT);
        } else if (this.isComplete(p)) {
            p.setLabel("built.c");
        } else {
            p.setLabel("built.i");
        }
    }

    private void setComplete(Parse p) {
        String l = p.getLabel();
        if (!this.isBuilt(p)) {
            p.setLabel("c");
        } else {
            p.setLabel("built.c");
        }
    }

    private void setIncomplete(Parse p) {
        if (!this.isBuilt(p)) {
            p.setLabel("i");
        } else {
            p.setLabel("built.i");
        }
    }

    private boolean isBuilt(Parse p) {
        String l = p.getLabel();
        return l != null && l.startsWith(BUILT);
    }

    private boolean isComplete(Parse p) {
        String l = p.getLabel();
        return l != null && l.endsWith("c");
    }

    @Override
    protected Parse[] advanceChunks(Parse p, double minChunkScore) {
        Parse[] parses;
        for (Parse parse : parses = super.advanceChunks(p, minChunkScore)) {
            Parse[] chunks;
            for (Parse chunk : chunks = parse.getChildren()) {
                this.setComplete(chunk);
            }
        }
        return parses;
    }

    @Override
    protected Parse[] advanceParses(Parse p, double probMass) {
        int advanceNodeIndex;
        double q = 1.0 - probMass;
        Parse advanceNode = null;
        Parse[] originalChildren = p.getChildren();
        Parse[] children = Parser.collapsePunctuation(originalChildren, this.punctSet);
        int numNodes = children.length;
        if (numNodes == 0) {
            return null;
        }
        if (numNodes == 1) {
            if (children[0].isPosTag()) {
                return null;
            }
            p.expandTopNode(children[0]);
            return new Parse[]{p};
        }
        for (advanceNodeIndex = 0; advanceNodeIndex < numNodes && this.isBuilt(advanceNode = children[advanceNodeIndex]); ++advanceNodeIndex) {
        }
        int originalZeroIndex = this.mapParseIndex(0, children, originalChildren);
        int originalAdvanceIndex = this.mapParseIndex(advanceNodeIndex, children, originalChildren);
        ArrayList<Parse> newParsesList = new ArrayList<Parse>();
        this.buildModel.eval(this.buildContextGenerator.getContext(children, advanceNodeIndex), this.bprobs);
        double doneProb = this.bprobs[this.doneIndex];
        if (logger.isDebugEnabled()) {
            logger.debug("adi={} {}.{} {} choose build={} attach={}", advanceNodeIndex, advanceNode.getType(), advanceNode.getLabel(), advanceNode, 1.0 - doneProb, doneProb);
        }
        if (1.0 - doneProb > q) {
            double bprobSum = 0.0;
            while (bprobSum < probMass) {
                int max = 0;
                for (int pi = 1; pi < this.bprobs.length; ++pi) {
                    if (!(this.bprobs[pi] > this.bprobs[max])) continue;
                    max = pi;
                }
                if (this.bprobs[max] == 0.0) break;
                double bprob = this.bprobs[max];
                this.bprobs[max] = 0.0;
                bprobSum += bprob;
                String tag = this.buildModel.getOutcome(max);
                if (tag.equals("d")) continue;
                Parse newParse1 = (Parse)p.clone();
                Parse newNode = new Parse(p.getText(), advanceNode.getSpan(), tag, bprob, advanceNode.getHead());
                newParse1.insert(newNode);
                newParse1.addProb(StrictMath.log(bprob));
                newParsesList.add(newParse1);
                if (checkComplete) {
                    this.cprobs = this.checkModel.eval(this.checkContextGenerator.getContext(newNode, children, advanceNodeIndex, false));
                    if (logger.isDebugEnabled()) {
                        logger.debug("building {} {} c={}", tag, bprob, this.cprobs[this.completeIndex]);
                    }
                    if (this.cprobs[this.completeIndex] > probMass) {
                        this.setComplete(newNode);
                        newParse1.addProb(StrictMath.log(this.cprobs[this.completeIndex]));
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("Only advancing complete node");
                        continue;
                    }
                    if (1.0 - this.cprobs[this.completeIndex] > probMass) {
                        this.setIncomplete(newNode);
                        newParse1.addProb(StrictMath.log(1.0 - this.cprobs[this.completeIndex]));
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("Only advancing incomplete node");
                        continue;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("Advancing both complete and incomplete nodes");
                    }
                    this.setComplete(newNode);
                    newParse1.addProb(StrictMath.log(this.cprobs[this.completeIndex]));
                    Parse newParse2 = (Parse)p.clone();
                    Parse newNode2 = new Parse(p.getText(), advanceNode.getSpan(), tag, bprob, advanceNode.getHead());
                    newParse2.insert(newNode2);
                    newParse2.addProb(StrictMath.log(bprob));
                    newParsesList.add(newParse2);
                    newParse2.addProb(StrictMath.log(1.0 - this.cprobs[this.completeIndex]));
                    this.setIncomplete(newNode2);
                    continue;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug("building {} {}", (Object)tag, (Object)bprob);
            }
        }
        if (doneProb > q) {
            Parse newParse1 = (Parse)p.clone();
            if (checkComplete) {
                if (this.isComplete(advanceNode)) {
                    newParse1.setChild(originalAdvanceIndex, "built.c");
                } else {
                    newParse1.setChild(originalAdvanceIndex, "built.i");
                }
            } else {
                newParse1.setChild(originalAdvanceIndex, BUILT);
            }
            newParse1.addProb(StrictMath.log(doneProb));
            if (advanceNodeIndex == 0) {
                newParsesList.add(newParse1);
            } else {
                List<Parse> rf = Parser.getRightFrontier(p, this.punctSet);
                int fs = rf.size();
                for (int fi = 0; fi < fs; ++fi) {
                    Parse fn = rf.get(fi);
                    this.attachModel.eval(this.attachContextGenerator.getContext(children, advanceNodeIndex, rf, fi), this.aprobs);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Frontier node({}): {}.{} {} <- {} {} d={} s={} ", fi, fn.getType(), fn.getLabel(), fn, advanceNode.getType(), advanceNode, this.aprobs[this.daughterAttachIndex], this.aprobs[this.sisterAttachIndex]);
                    }
                    for (int attachment : this.attachments) {
                        double prob = this.aprobs[attachment];
                        if (prob > q && (!checkComplete && (attachment != this.daughterAttachIndex || !this.isComplete(fn)) || checkComplete && (attachment == this.daughterAttachIndex && !this.isComplete(fn) || attachment == this.sisterAttachIndex && this.isComplete(fn)))) {
                            Parse updatedNode;
                            Parse newParse2 = newParse1.cloneRoot(fn, originalZeroIndex);
                            Parse[] newKids = Parser.collapsePunctuation(newParse2.getChildren(), this.punctSet);
                            for (int ri = originalZeroIndex + 1; ri <= originalAdvanceIndex; ++ri) {
                                if (logger.isTraceEnabled()) {
                                    logger.trace("{}-removing {} {}", ri, originalZeroIndex + 1, newParse2.getChildren()[originalZeroIndex + 1]);
                                }
                                newParse2.remove(originalZeroIndex + 1);
                            }
                            List<Parse> crf = Parser.getRightFrontier(newParse2, this.punctSet);
                            if (attachment == this.daughterAttachIndex) {
                                updatedNode = crf.get(fi);
                                updatedNode.add(advanceNode, this.headRules);
                            } else if (fi + 1 < crf.size()) {
                                Parse psite = crf.get(fi + 1);
                                updatedNode = psite.adjoin(advanceNode, this.headRules);
                            } else {
                                Parse psite = newParse2;
                                newKids[0] = updatedNode = psite.adjoinRoot(advanceNode, this.headRules, originalZeroIndex);
                            }
                            for (int ni = fi + 1; ni < crf.size(); ++ni) {
                                Parse node = crf.get(ni);
                                node.updateSpan();
                            }
                            newParse2.addProb(StrictMath.log(prob));
                            newParsesList.add(newParse2);
                            if (!checkComplete) continue;
                            this.cprobs = this.checkModel.eval(this.checkContextGenerator.getContext(updatedNode, newKids, advanceNodeIndex, true));
                            if (this.cprobs[this.completeIndex] > probMass) {
                                this.setComplete(updatedNode);
                                newParse2.addProb(StrictMath.log(this.cprobs[this.completeIndex]));
                                if (!logger.isDebugEnabled()) continue;
                                logger.debug("Only advancing complete node");
                                continue;
                            }
                            if (1.0 - this.cprobs[this.completeIndex] > probMass) {
                                this.setIncomplete(updatedNode);
                                newParse2.addProb(StrictMath.log(1.0 - this.cprobs[this.completeIndex]));
                                if (!logger.isDebugEnabled()) continue;
                                logger.debug("Only advancing incomplete node");
                                continue;
                            }
                            this.setComplete(updatedNode);
                            Parse newParse3 = newParse2.cloneRoot(updatedNode, originalZeroIndex);
                            newParse3.addProb(StrictMath.log(this.cprobs[this.completeIndex]));
                            newParsesList.add(newParse3);
                            this.setIncomplete(updatedNode);
                            newParse2.addProb(StrictMath.log(1.0 - this.cprobs[this.completeIndex]));
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug("Advancing both complete and incomplete nodes; c={}", (Object)this.cprobs[this.completeIndex]);
                            continue;
                        }
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("Skipping {}.{} {} daughter={} complete={} prob={}", fn.getType(), fn.getLabel(), fn, attachment == this.daughterAttachIndex, this.isComplete(fn), prob);
                    }
                    if (!checkComplete || this.isComplete(fn)) continue;
                    if (!logger.isDebugEnabled()) break;
                    logger.debug("Stopping at incomplete node({}): {} . {} {}", fi, fn.getType(), fn.getLabel(), fn);
                    break;
                }
            }
        }
        Parse[] newParses = new Parse[newParsesList.size()];
        newParsesList.toArray(newParses);
        return newParses;
    }

    @Override
    protected void advanceTop(Parse p) {
        p.setType("TOP");
    }

    public static ParserModel train(String languageCode, ObjectStream<Parse> parseSamples, HeadRules rules, TrainingParameters mlParams) throws IOException {
        HashMap<String, String> manifestInfoEntries = new HashMap<String, String>();
        logger.info("Building dictionary");
        Dictionary mdict = Parser.buildDictionary(parseSamples, rules, mlParams);
        parseSamples.reset();
        POSModel posModel = POSTaggerME.train(languageCode, new PosSampleStream(parseSamples), mlParams.getParameters("tagger"), new POSTaggerFactory());
        parseSamples.reset();
        ChunkerModel chunkModel = ChunkerME.train(languageCode, new ChunkSampleStream(parseSamples), mlParams.getParameters("chunker"), new ParserChunkerFactory());
        parseSamples.reset();
        logger.info("Training builder");
        ParserEventStream bes = new ParserEventStream(parseSamples, rules, ParserEventTypeEnum.BUILD, mdict);
        HashMap<String, String> buildReportMap = new HashMap<String, String>();
        EventTrainer buildTrainer = TrainerFactory.getEventTrainer(mlParams.getParameters("build"), buildReportMap);
        MaxentModel buildModel = buildTrainer.train(bes);
        opennlp.tools.parser.chunking.Parser.mergeReportIntoManifest(manifestInfoEntries, buildReportMap, "build");
        parseSamples.reset();
        logger.info("Training checker");
        ParserEventStream kes = new ParserEventStream(parseSamples, rules, ParserEventTypeEnum.CHECK);
        HashMap<String, String> checkReportMap = new HashMap<String, String>();
        EventTrainer checkTrainer = TrainerFactory.getEventTrainer(mlParams.getParameters("check"), checkReportMap);
        MaxentModel checkModel = checkTrainer.train(kes);
        opennlp.tools.parser.chunking.Parser.mergeReportIntoManifest(manifestInfoEntries, checkReportMap, "check");
        parseSamples.reset();
        logger.info("Training attacher");
        ParserEventStream attachEvents = new ParserEventStream(parseSamples, rules, ParserEventTypeEnum.ATTACH);
        HashMap<String, String> attachReportMap = new HashMap<String, String>();
        EventTrainer attachTrainer = TrainerFactory.getEventTrainer(mlParams.getParameters("attach"), attachReportMap);
        MaxentModel attachModel = attachTrainer.train(attachEvents);
        opennlp.tools.parser.chunking.Parser.mergeReportIntoManifest(manifestInfoEntries, attachReportMap, "attach");
        return new ParserModel(languageCode, buildModel, checkModel, attachModel, posModel, chunkModel, rules, ParserType.TREEINSERT, manifestInfoEntries);
    }

    public static ParserModel train(String languageCode, ObjectStream<Parse> parseSamples, HeadRules rules, int iterations, int cutoff) throws IOException {
        TrainingParameters params = new TrainingParameters();
        params.put("dict", "Cutoff", cutoff);
        params.put("tagger", "Cutoff", cutoff);
        params.put("tagger", "Iterations", iterations);
        params.put("chunker", "Cutoff", cutoff);
        params.put("chunker", "Iterations", iterations);
        params.put("check", "Cutoff", cutoff);
        params.put("check", "Iterations", iterations);
        params.put("build", "Cutoff", cutoff);
        params.put("build", "Iterations", iterations);
        return Parser.train(languageCode, parseSamples, rules, params);
    }
}

