/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.openwhisk.core.entity

import spray.json._
import spray.json.DefaultJsonProtocol._

protected[core] case class ActivationLogs(logs: Vector[String] = Vector.empty) extends AnyVal {
  def toJsonObject = JsObject("logs" -> toJson)
  def toJson = logs.toJson

  override def toString = logs.mkString("[", ", ", "]")
}

protected[core] object ActivationLogs {
  protected[core] implicit val serdes = new RootJsonFormat[ActivationLogs] {
    def write(l: ActivationLogs) = l.toJson
    def read(value: JsValue) = ActivationLogs(value.convertTo[Vector[String]])
  }
}
