<!--
#
# Licensed to the Apache Software Foundation (ASF) under one or more
# contributor license agreements.  See the NOTICE file distributed with
# this work for additional information regarding copyright ownership.
# The ASF licenses this file to You under the Apache License, Version 2.0
# (the "License"); you may not use this file except in compliance with
# the License.  You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
-->

### Building test artifacts

Some test artifacts should be build ahead of actually running the tests.
These test artifacts compile source code into binaries, generate JAR files,
install modules and package functions into zip files.

A `build.sh` script is available as a convenience and will run ahead of tests
when using `gradle`. However this script will not work on Windows as it currently
assumes Bash is available.

Some artifacts are not build because they require additional tooling.
Specifically, these are the unicode tests for the Ballerina and .NET runtimes.
These unicode tests are checked however in their corresponding runtime build.

For Java artifacts, Java 8 is required. If not found in your path, the build
script will skip those artifacts and corresponding tests will also be skipped.

