/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.server;

import java.util.HashMap;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.apache.calcite.avatica.remote.KerberosConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerKeytabJaasConf
extends Configuration {
    private static final Logger LOG = LoggerFactory.getLogger(ServerKeytabJaasConf.class);
    private final String principal;
    private final String keytab;

    public ServerKeytabJaasConf(String principal, String keytab) {
        this.principal = principal;
        this.keytab = keytab;
    }

    @Override
    public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("principal", this.principal);
        options.put("refreshKrb5Config", "true");
        if (KerberosConnection.isIbmJava()) {
            options.put("useKeytab", this.keytab);
            options.put("credsType", "both");
        } else {
            options.put("keyTab", this.keytab);
            options.put("useKeyTab", "true");
            options.put("isInitiator", "false");
            options.put("doNotPrompt", "true");
            options.put("storeKey", "true");
        }
        LOG.debug("JAAS Configuration for server keytab-based Kerberos login: {}", (Object)options);
        return new AppConfigurationEntry[]{new AppConfigurationEntry(KerberosConnection.getKrb5LoginModuleName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
    }
}

