/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.queryserver;

import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;

public class QueryServerOptions {
    public static final String DEFAULT_QUERY_SERVER_SERIALIZATION = "PROTOBUF";
    public static final int DEFAULT_QUERY_SERVER_HTTP_PORT = 8765;
    public static final long DEFAULT_QUERY_SERVER_UGI_CACHE_MAX_SIZE = 1000L;
    public static final int DEFAULT_QUERY_SERVER_UGI_CACHE_INITIAL_SIZE = 100;
    public static final int DEFAULT_QUERY_SERVER_UGI_CACHE_CONCURRENCY = 10;
    public static final boolean DEFAULT_QUERY_SERVER_SPNEGO_AUTH_DISABLED = false;
    public static final boolean DEFAULT_QUERY_SERVER_WITH_REMOTEUSEREXTRACTOR = false;
    public static final boolean DEFAULT_QUERY_SERVER_CUSTOM_AUTH_ENABLED = false;
    public static final String DEFAULT_QUERY_SERVER_REMOTEUSEREXTRACTOR_PARAM = "doAs";
    public static final boolean DEFAULT_QUERY_SERVER_DISABLE_KERBEROS_LOGIN = false;
    public static final boolean DEFAULT_QUERY_SERVER_JMXJSONENDPOINT_DISABLED = false;
    public static final boolean DEFAULT_QUERY_SERVER_TLS_ENABLED = false;
    public static final String DEFAULT_QUERY_SERVER_TLS_KEYSTORE_PASSWORD = "";
    public static final String DEFAULT_QUERY_SERVER_TLS_TRUSTSTORE_PASSWORD = "";
    public static final Set<String> DEFAULT_QUERY_SERVER_SKIP_WORDS = new HashSet<String>(){
        {
            this.add("secret");
            this.add("passwd");
            this.add("password");
            this.add("credential");
        }
    };
    public static final boolean DEFAULT_PHOENIX_QUERY_SERVER_LOADBALANCER_ENABLED = false;
    public static final String DEFAULT_PHOENIX_QUERY_SERVER_CLUSTER_BASE_PATH = "/phoenix";
    public static final String DEFAULT_PHOENIX_QUERY_SERVER_SERVICE_NAME = "queryserver";
    public static final String DEFAULT_PHOENIX_QUERY_SERVER_ZK_ACL_USERNAME = "phoenix";
    public static final String DEFAULT_PHOENIX_QUERY_SERVER_ZK_ACL_PASSWORD = "phoenix";
    public static final boolean DEFAULT_CLIENT_JARS_ENABLED = false;
    public static final String DEFAULT_CLIENT_JARS_REPO = "";
    public static final String DEFAULT_CLIENT_JARS_CONTEXT = "/maven";
    public static final String DEFAULT_EXTRA_JDBC_ARGUMENTS = "";
    private final Configuration config;

    private QueryServerOptions(Configuration config) {
        this.config = config;
    }

    public static QueryServerOptions withDefaults() {
        Configuration config = HBaseConfiguration.create();
        QueryServerOptions options = new QueryServerOptions(config).setIfUnset("phoenix.queryserver.loadbalancer.enabled", false).setIfUnset("phoenix.queryserver.base.path", DEFAULT_PHOENIX_QUERY_SERVER_CLUSTER_BASE_PATH).setIfUnset("phoenix.queryserver.service.name", DEFAULT_PHOENIX_QUERY_SERVER_SERVICE_NAME).setIfUnset("phoenix.queryserver.zookeeper.acl.username", "phoenix").setIfUnset("phoenix.queryserver.zookeeper.acl.password", "phoenix");
        return options;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    private QueryServerOptions setIfUnset(String name, int value) {
        this.config.setIfUnset(name, Integer.toString(value));
        return this;
    }

    private QueryServerOptions setIfUnset(String name, boolean value) {
        this.config.setIfUnset(name, Boolean.toString(value));
        return this;
    }

    private QueryServerOptions setIfUnset(String name, long value) {
        this.config.setIfUnset(name, Long.toString(value));
        return this;
    }

    private QueryServerOptions setIfUnset(String name, String value) {
        this.config.setIfUnset(name, value);
        return this;
    }
}

