/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.SchemaParseException;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.generic.GenericContainer;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.DatumReader;
import org.apache.avro.mapred.AvroInputFormat;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.pig.Expression;
import org.apache.pig.LoadFunc;
import org.apache.pig.LoadMetadata;
import org.apache.pig.LoadPushDown;
import org.apache.pig.PigWarning;
import org.apache.pig.ResourceSchema;
import org.apache.pig.ResourceStatistics;
import org.apache.pig.StoreFunc;
import org.apache.pig.StoreFuncInterface;
import org.apache.pig.StoreResources;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigFileInputFormat;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.builtin.FuncUtils;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.UDFContext;
import org.apache.pig.impl.util.Utils;
import org.apache.pig.impl.util.avro.AvroArrayReader;
import org.apache.pig.impl.util.avro.AvroRecordReader;
import org.apache.pig.impl.util.avro.AvroRecordWriter;
import org.apache.pig.impl.util.avro.AvroStorageSchemaConversionUtilities;
import org.apache.pig.impl.util.avro.AvroTupleWrapper;

public class AvroStorage
extends LoadFunc
implements StoreFuncInterface,
LoadMetadata,
LoadPushDown,
StoreResources {
    private String schemaName;
    private String schemaNameSpace;
    protected boolean allowRecursive;
    protected boolean doubleColonsToDoubleUnderscores;
    protected Schema schema;
    protected final Log log;
    protected String udfContextSignature;
    public static final String OUTPUT_AVRO_SCHEMA = "org.apache.pig.builtin.AvroStorage.output.schema";
    private RecordWriter<NullWritable, Object> writer;
    public static final String INPUT_AVRO_SCHEMA = "org.apache.pig.builtin.AvroStorage.input.schema";
    private RecordReader reader;
    PigSplit split;
    protected LoadPushDown.RequiredFieldList requiredFieldList;

    public AvroStorage() {
        this(null, null);
    }

    public AvroStorage(String sn) {
        this(sn, null);
    }

    public AvroStorage(String sn, String opts) {
        block16: {
            this.schemaName = "pig_output";
            this.schemaNameSpace = null;
            this.allowRecursive = false;
            this.doubleColonsToDoubleUnderscores = false;
            this.log = LogFactory.getLog(this.getClass());
            this.udfContextSignature = null;
            if (sn != null && sn.length() > 0) {
                try {
                    Schema s = new Schema.Parser().parse(sn);
                    this.setInputAvroSchema(s);
                    this.setOutputAvroSchema(s);
                }
                catch (SchemaParseException e) {
                    this.schemaName = sn;
                }
            }
            if (opts != null) {
                String[] optsArr = opts.split(" ");
                Options validOptions = new Options();
                try {
                    GnuParser parser = new GnuParser();
                    validOptions.addOption("n", "namespace", true, "Namespace for an automatically generated output schema");
                    validOptions.addOption("f", "schemafile", true, "Specifies URL for avro schema file from which to read the input or output schema");
                    validOptions.addOption("c", "schemaclass", true, "Specifies fully qualified class name for avro class in your classpath which implements GenericContainer.");
                    validOptions.addOption("e", "examplefile", true, "Specifies URL for avro data file from which to copy the output schema");
                    validOptions.addOption("r", "allowrecursive", false, "Option to allow recursive schema definitions (default is false)");
                    validOptions.addOption("d", "doublecolons", false, "Option to translate Pig schema names with double colons to names with double underscores (default is false)");
                    CommandLine configuredOptions = parser.parse(validOptions, optsArr);
                    this.schemaNameSpace = configuredOptions.getOptionValue("namespace", null);
                    this.allowRecursive = configuredOptions.hasOption('r');
                    this.doubleColonsToDoubleUnderscores = configuredOptions.hasOption('d');
                    if (configuredOptions.hasOption('f')) {
                        try {
                            Path p = new Path(configuredOptions.getOptionValue('f'));
                            Configuration conf = UDFContext.getUDFContext().getJobConf() == null ? new Configuration() : UDFContext.getUDFContext().getJobConf();
                            Schema s = new Schema.Parser().parse((InputStream)FileSystem.get((URI)p.toUri(), (Configuration)conf).open(p));
                            this.setInputAvroSchema(s);
                            this.setOutputAvroSchema(s);
                        }
                        catch (FileNotFoundException fnfe) {
                            System.err.printf("file not found exception\n", new Object[0]);
                            this.log.warn((Object)"Schema file not found when instantiating AvroStorage. (If the schema was described in a local file on the front end, and this message is in the back end log, you can ignore this mesasge.)", (Throwable)fnfe);
                        }
                        break block16;
                    }
                    if (configuredOptions.hasOption('c')) {
                        String schemaClass = configuredOptions.getOptionValue('c');
                        try {
                            Schema s = ((GenericContainer)Class.forName(schemaClass).newInstance()).getSchema();
                            this.setInputAvroSchema(s);
                            this.setOutputAvroSchema(s);
                            break block16;
                        }
                        catch (ClassNotFoundException | IllegalAccessException cnfe) {
                            System.err.printf("class not found exception\n", new Object[0]);
                            this.log.error((Object)("Schema class '" + schemaClass + "' was not found in the classpath."), (Throwable)cnfe);
                            throw new RuntimeException(cnfe);
                        }
                        catch (InstantiationException ie) {
                            System.err.printf("instantiation exception\n", new Object[0]);
                            this.log.error((Object)("Schema class '" + schemaClass + "' must have a public empty args constructor."), (Throwable)ie);
                            throw new RuntimeException(ie);
                        }
                        catch (ClassCastException cce) {
                            System.err.printf("class cast exception\n", new Object[0]);
                            this.log.error((Object)("Schema class '" + schemaClass + "' must implement org.apache.avro.generic.GenericContainer interface."), (Throwable)cce);
                            throw new RuntimeException(cce);
                        }
                    }
                    if (configuredOptions.hasOption('e')) {
                        this.setOutputAvroSchema(this.getAvroSchema(configuredOptions.getOptionValue('e'), new Job(new Configuration())));
                    }
                }
                catch (ParseException e) {
                    this.log.error((Object)"Exception in AvroStorage", (Throwable)e);
                    this.log.error((Object)("AvroStorage called with arguments " + sn + ", " + opts));
                    this.warn("ParseException in AvroStorage", PigWarning.UDF_WARNING_1);
                    HelpFormatter formatter = new HelpFormatter();
                    formatter.printHelp("AvroStorage(',', '[options]')", validOptions);
                    throw new RuntimeException(e);
                }
                catch (IOException e) {
                    this.log.warn((Object)"Exception in AvroStorage", (Throwable)e);
                    this.log.warn((Object)("AvroStorage called with arguments " + sn + ", " + opts));
                    this.warn("IOException in AvroStorage", PigWarning.UDF_WARNING_1);
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @Override
    public final void setUDFContextSignature(String signature) {
        this.udfContextSignature = signature;
        super.setUDFContextSignature(signature);
        this.updateSchemaFromInputAvroSchema();
    }

    protected final Properties getProperties() {
        if (this.udfContextSignature == null) {
            return this.getProperties(AvroStorage.class, null);
        }
        return this.getProperties(AvroStorage.class, this.udfContextSignature);
    }

    protected final Properties getProperties(Class c, String signature) {
        UDFContext context = UDFContext.getUDFContext();
        if (signature == null) {
            return context.getUDFProperties(c);
        }
        return context.getUDFProperties(c, new String[]{signature});
    }

    @Override
    public final ResourceSchema getSchema(String location, Job job) throws IOException {
        if (this.schema == null) {
            Schema s = this.getAvroSchema(location, job);
            this.setInputAvroSchema(s);
        }
        ResourceSchema rs = AvroStorageSchemaConversionUtilities.avroSchemaToResourceSchema(this.schema, this.allowRecursive);
        return rs;
    }

    protected final Schema getAvroSchema(String location, Job job) throws IOException {
        String[] locations = AvroStorage.getPathStrings(location);
        Path[] paths = new Path[locations.length];
        for (int i = 0; i < paths.length; ++i) {
            paths[i] = new Path(locations[i]);
        }
        return this.getAvroSchema(paths, job);
    }

    public Schema getAvroSchema(Path[] p, Job job) throws IOException {
        GenericDatumReader avroReader = new GenericDatumReader();
        ArrayList<FileStatus> statusList = new ArrayList<FileStatus>();
        FileSystem fs = FileSystem.get((URI)p[0].toUri(), (Configuration)job.getConfiguration());
        for (Path temp : p) {
            for (FileStatus tempf : fs.globStatus(temp)) {
                statusList.add(tempf);
            }
        }
        FileStatus[] statusArray = statusList.toArray(new FileStatus[statusList.size()]);
        if (statusArray == null) {
            throw new IOException("Path " + p.toString() + " does not exist.");
        }
        if (statusArray.length == 0) {
            throw new IOException("No path matches pattern " + p.toString());
        }
        Path filePath = Utils.depthFirstSearchForFile(statusArray, fs);
        if (filePath == null) {
            throw new IOException("No path matches pattern " + p.toString());
        }
        FSDataInputStream hdfsInputStream = fs.open(filePath);
        DataFileStream avroDataStream = new DataFileStream((InputStream)hdfsInputStream, (DatumReader)avroReader);
        Schema s = avroDataStream.getSchema();
        avroDataStream.close();
        return s;
    }

    @Override
    public final ResourceStatistics getStatistics(String location, Job job) throws IOException {
        return null;
    }

    @Override
    public final String[] getPartitionKeys(String location, Job job) throws IOException {
        return null;
    }

    @Override
    public void setPartitionFilter(Expression partitionFilter) throws IOException {
    }

    @Override
    public final String relToAbsPathForStoreLocation(String location, Path curDir) throws IOException {
        return LoadFunc.getAbsolutePath(location, curDir);
    }

    public OutputFormat<NullWritable, Object> getOutputFormat() throws IOException {
        class AvroStorageOutputFormat
        extends FileOutputFormat<NullWritable, Object> {
            AvroStorageOutputFormat() {
            }

            public RecordWriter<NullWritable, Object> getRecordWriter(TaskAttemptContext tc) throws IOException, InterruptedException {
                return new AvroRecordWriter(this.getDefaultWorkFile(tc, ".avro"), tc.getConfiguration());
            }
        }
        return new AvroStorageOutputFormat();
    }

    @Override
    public final void setStoreLocation(String location, Job job) throws IOException {
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(location));
    }

    @Override
    public final void checkSchema(ResourceSchema rs) throws IOException {
        if (rs == null) {
            throw new IOException("checkSchema: called with null ResourceSchema");
        }
        Schema avroSchema = AvroStorageSchemaConversionUtilities.resourceSchemaToAvroSchema(rs, this.schemaName == null || this.schemaName.length() == 0 ? "pig_output" : this.schemaName, this.schemaNameSpace, Maps.newHashMap(), this.doubleColonsToDoubleUnderscores);
        if (avroSchema == null) {
            throw new IOException("checkSchema: could not translate ResourceSchema to Avro Schema");
        }
        this.setOutputAvroSchema(avroSchema);
    }

    protected final void setOutputAvroSchema(Schema s) {
        this.schema = s;
        this.getProperties().setProperty(OUTPUT_AVRO_SCHEMA, s.toString());
    }

    protected final Schema getOutputAvroSchema() {
        String schemaString;
        if (this.schema == null && (schemaString = this.getProperties().getProperty(OUTPUT_AVRO_SCHEMA)) != null) {
            this.schema = new Schema.Parser().parse(schemaString);
        }
        return this.schema;
    }

    @Override
    public final void prepareToWrite(RecordWriter w) throws IOException {
        if (this.udfContextSignature == null) {
            throw new IOException(this.getClass().toString() + ".prepareToWrite called without setting udf context signature");
        }
        this.writer = w;
        ((AvroRecordWriter)this.writer).prepareToWrite(this.getOutputAvroSchema());
    }

    @Override
    public final void putNext(Tuple t) throws IOException {
        try {
            this.writer.write(null, (Object)t);
        }
        catch (InterruptedException e) {
            this.log.error((Object)"InterruptedException in putNext");
            throw new IOException(e);
        }
    }

    @Override
    public final void setStoreFuncUDFContextSignature(String signature) {
        this.udfContextSignature = signature;
        super.setUDFContextSignature(signature);
    }

    @Override
    public final void cleanupOnFailure(String location, Job job) throws IOException {
        StoreFunc.cleanupOnFailureImpl(location, job);
    }

    @Override
    public void setLocation(String location, Job job) throws IOException {
        FileInputFormat.setInputPaths((Job)job, (String)location);
        if (this.schema == null) {
            this.schema = this.getInputAvroSchema();
            if (this.schema == null) {
                this.schema = this.getAvroSchema(location, job);
                if (this.schema == null) {
                    throw new IOException("Could not determine avro schema for location " + location);
                }
                this.setInputAvroSchema(this.schema);
            }
        }
    }

    protected final void setInputAvroSchema(Schema s) {
        this.schema = s;
        this.getProperties().setProperty(INPUT_AVRO_SCHEMA, s.toString());
    }

    public final Schema getInputAvroSchema() {
        if (this.schema == null) {
            this.updateSchemaFromInputAvroSchema();
        }
        return this.schema;
    }

    private final void updateSchemaFromInputAvroSchema() {
        String schemaString = this.getProperties().getProperty(INPUT_AVRO_SCHEMA);
        if (schemaString != null) {
            Schema s;
            this.schema = s = new Schema.Parser().parse(schemaString);
        }
    }

    public InputFormat<NullWritable, GenericData.Record> getInputFormat() throws IOException {
        return new PigFileInputFormat<NullWritable, GenericData.Record>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public RecordReader<NullWritable, GenericData.Record> createRecordReader(InputSplit is, TaskAttemptContext tc) throws IOException, InterruptedException {
                Schema s = AvroStorage.this.getInputAvroSchema();
                RecordReader rr = null;
                rr = s.getType() == Schema.Type.ARRAY ? new AvroArrayReader(s) : new AvroRecordReader(s);
                try {
                    rr.initialize(is, tc);
                }
                finally {
                    rr.close();
                }
                tc.setStatus(is.toString());
                return rr;
            }
        };
    }

    @Override
    public final void prepareToRead(RecordReader r, PigSplit s) throws IOException {
        this.reader = r;
        this.split = s;
    }

    @Override
    public final Tuple getNext() throws IOException {
        try {
            if (this.reader.nextKeyValue()) {
                return new AvroTupleWrapper<GenericData.Record>((GenericData.Record)this.reader.getCurrentValue());
            }
            return null;
        }
        catch (InterruptedException e) {
            throw new IOException("Wrapped Interrupted Exception", e);
        }
    }

    @Override
    public void cleanupOnSuccess(String location, Job job) throws IOException {
    }

    @Override
    public List<LoadPushDown.OperatorSet> getFeatures() {
        return Lists.newArrayList(LoadPushDown.OperatorSet.PROJECTION);
    }

    @Override
    public LoadPushDown.RequiredFieldResponse pushProjection(LoadPushDown.RequiredFieldList rfl) throws FrontendException {
        this.requiredFieldList = rfl;
        Schema newSchema = AvroStorageSchemaConversionUtilities.newSchemaFromRequiredFieldList(this.schema, rfl);
        if (newSchema != null) {
            this.schema = newSchema;
            this.setInputAvroSchema(this.schema);
            return new LoadPushDown.RequiredFieldResponse(true);
        }
        this.log.warn((Object)("could not select fields subset " + rfl + "\n"));
        this.warn("could not select fields subset", PigWarning.UDF_WARNING_2);
        return new LoadPushDown.RequiredFieldResponse(false);
    }

    @Override
    public List<String> getShipFiles() {
        Class[] classList = new Class[]{Schema.class, AvroInputFormat.class};
        return FuncUtils.getShipFiles(classList);
    }
}

