/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.binarysortable.fast;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.serde2.binarysortable.BinarySortableSerDe;
import org.apache.hadoop.hive.serde2.binarysortable.InputByteBuffer;
import org.apache.hadoop.hive.serde2.fast.DeserializeRead;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.HiveCharWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalDayTimeWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalYearMonthWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.apache.hadoop.io.Text;

public class BinarySortableDeserializeRead
implements DeserializeRead {
    public static final Log LOG = LogFactory.getLog((String)BinarySortableDeserializeRead.class.getName());
    private PrimitiveTypeInfo[] primitiveTypeInfos;
    private boolean[] columnSortOrderIsDesc;
    private int fieldIndex;
    private int fieldCount;
    private int start;
    private DecimalTypeInfo saveDecimalTypeInfo;
    private HiveDecimal saveDecimal;
    private byte[] tempDecimalBuffer;
    private HiveDecimalWritable tempHiveDecimalWritable;
    private boolean readBeyondConfiguredFieldsWarned;
    private boolean readBeyondBufferRangeWarned;
    private boolean bufferRangeHasExtraDataWarned;
    private InputByteBuffer inputByteBuffer = new InputByteBuffer();

    public BinarySortableDeserializeRead(PrimitiveTypeInfo[] primitiveTypeInfos) {
        this(primitiveTypeInfos, null);
    }

    public BinarySortableDeserializeRead(PrimitiveTypeInfo[] primitiveTypeInfos, boolean[] columnSortOrderIsDesc) {
        this.primitiveTypeInfos = primitiveTypeInfos;
        this.fieldCount = primitiveTypeInfos.length;
        if (columnSortOrderIsDesc != null) {
            this.columnSortOrderIsDesc = columnSortOrderIsDesc;
        } else {
            this.columnSortOrderIsDesc = new boolean[primitiveTypeInfos.length];
            Arrays.fill(this.columnSortOrderIsDesc, false);
        }
        this.inputByteBuffer = new InputByteBuffer();
        this.readBeyondConfiguredFieldsWarned = false;
        this.readBeyondBufferRangeWarned = false;
        this.bufferRangeHasExtraDataWarned = false;
    }

    private BinarySortableDeserializeRead() {
    }

    @Override
    public PrimitiveTypeInfo[] primitiveTypeInfos() {
        return this.primitiveTypeInfos;
    }

    @Override
    public void set(byte[] bytes, int offset, int length) {
        this.fieldIndex = -1;
        this.inputByteBuffer.reset(bytes, offset, offset + length);
        this.start = offset;
    }

    @Override
    public boolean readCheckNull() throws IOException {
        ++this.fieldIndex;
        if (this.fieldIndex >= this.fieldCount) {
            if (!this.readBeyondConfiguredFieldsWarned) {
                LOG.info((Object)("Reading beyond configured fields! Configured " + this.fieldCount + " fields but " + " reading more (NULLs returned).  Ignoring similar problems."));
                this.readBeyondConfiguredFieldsWarned = true;
            }
            return true;
        }
        if (this.inputByteBuffer.isEof()) {
            if (!this.readBeyondBufferRangeWarned) {
                int length = this.inputByteBuffer.tell() - this.start;
                LOG.info((Object)("Reading beyond buffer range! Buffer range " + this.start + " for length " + length + " but reading more... " + "(total buffer length " + this.inputByteBuffer.getData().length + ")" + "  Ignoring similar problems."));
                this.readBeyondBufferRangeWarned = true;
            }
            return true;
        }
        byte isNull = this.inputByteBuffer.read(this.columnSortOrderIsDesc[this.fieldIndex]);
        if (isNull == 0) {
            return true;
        }
        if (this.primitiveTypeInfos[this.fieldIndex].getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.DECIMAL) {
            return false;
        }
        return this.earlyReadHiveDecimal();
    }

    @Override
    public void extraFieldsCheck() {
        if (!this.inputByteBuffer.isEof() && !this.bufferRangeHasExtraDataWarned) {
            int length = this.inputByteBuffer.getEnd() - this.start;
            int remaining = this.inputByteBuffer.getEnd() - this.inputByteBuffer.tell();
            LOG.info((Object)("Not all fields were read in the buffer range! Buffer range " + this.start + " for length " + length + " but " + remaining + " bytes remain. " + "(total buffer length " + this.inputByteBuffer.getData().length + ")" + "  Ignoring similar problems."));
            this.bufferRangeHasExtraDataWarned = true;
        }
    }

    @Override
    public boolean readBeyondConfiguredFieldsWarned() {
        return this.readBeyondConfiguredFieldsWarned;
    }

    @Override
    public boolean readBeyondBufferRangeWarned() {
        return this.readBeyondBufferRangeWarned;
    }

    @Override
    public boolean bufferRangeHasExtraDataWarned() {
        return this.bufferRangeHasExtraDataWarned;
    }

    @Override
    public boolean readBoolean() throws IOException {
        byte b = this.inputByteBuffer.read(this.columnSortOrderIsDesc[this.fieldIndex]);
        return b == 2;
    }

    @Override
    public byte readByte() throws IOException {
        return (byte)(this.inputByteBuffer.read(this.columnSortOrderIsDesc[this.fieldIndex]) ^ 0x80);
    }

    @Override
    public short readShort() throws IOException {
        boolean invert = this.columnSortOrderIsDesc[this.fieldIndex];
        int v = this.inputByteBuffer.read(invert) ^ 0x80;
        v = (v << 8) + (this.inputByteBuffer.read(invert) & 0xFF);
        return (short)v;
    }

    @Override
    public int readInt() throws IOException {
        boolean invert = this.columnSortOrderIsDesc[this.fieldIndex];
        int v = this.inputByteBuffer.read(invert) ^ 0x80;
        for (int i = 0; i < 3; ++i) {
            v = (v << 8) + (this.inputByteBuffer.read(invert) & 0xFF);
        }
        return v;
    }

    @Override
    public long readLong() throws IOException {
        boolean invert = this.columnSortOrderIsDesc[this.fieldIndex];
        long v = this.inputByteBuffer.read(invert) ^ 0x80;
        for (int i = 0; i < 7; ++i) {
            v = (v << 8) + (long)(this.inputByteBuffer.read(invert) & 0xFF);
        }
        return v;
    }

    @Override
    public float readFloat() throws IOException {
        boolean invert = this.columnSortOrderIsDesc[this.fieldIndex];
        int v = 0;
        for (int i = 0; i < 4; ++i) {
            v = (v << 8) + (this.inputByteBuffer.read(invert) & 0xFF);
        }
        v = (v & Integer.MIN_VALUE) == 0 ? (v ^= 0xFFFFFFFF) : (v ^= Integer.MIN_VALUE);
        return Float.intBitsToFloat(v);
    }

    @Override
    public double readDouble() throws IOException {
        boolean invert = this.columnSortOrderIsDesc[this.fieldIndex];
        long v = 0L;
        for (int i = 0; i < 8; ++i) {
            v = (v << 8) + (long)(this.inputByteBuffer.read(invert) & 0xFF);
        }
        v = (v & Long.MIN_VALUE) == 0L ? (v ^= 0xFFFFFFFFFFFFFFFFL) : (v ^= Long.MIN_VALUE);
        return Double.longBitsToDouble(v);
    }

    @Override
    public DeserializeRead.ReadStringResults createReadStringResults() {
        return new BinarySortableReadStringResults();
    }

    @Override
    public void readString(DeserializeRead.ReadStringResults readStringResults) throws IOException {
        BinarySortableReadStringResults binarySortableReadStringResults = (BinarySortableReadStringResults)readStringResults;
        BinarySortableSerDe.deserializeText(this.inputByteBuffer, this.columnSortOrderIsDesc[this.fieldIndex], binarySortableReadStringResults.text);
        readStringResults.bytes = binarySortableReadStringResults.text.getBytes();
        readStringResults.start = 0;
        readStringResults.length = binarySortableReadStringResults.text.getLength();
    }

    @Override
    public DeserializeRead.ReadHiveCharResults createReadHiveCharResults() {
        return new BinarySortableReadHiveCharResults();
    }

    @Override
    public void readHiveChar(DeserializeRead.ReadHiveCharResults readHiveCharResults) throws IOException {
        BinarySortableReadHiveCharResults binarySortableReadHiveCharResults = (BinarySortableReadHiveCharResults)readHiveCharResults;
        if (!binarySortableReadHiveCharResults.isInit()) {
            binarySortableReadHiveCharResults.init((CharTypeInfo)this.primitiveTypeInfos[this.fieldIndex]);
        }
        HiveCharWritable hiveCharWritable = binarySortableReadHiveCharResults.getHiveCharWritable();
        BinarySortableSerDe.deserializeText(this.inputByteBuffer, this.columnSortOrderIsDesc[this.fieldIndex], hiveCharWritable.getTextValue());
        hiveCharWritable.enforceMaxLength(binarySortableReadHiveCharResults.getMaxLength());
        readHiveCharResults.bytes = hiveCharWritable.getTextValue().getBytes();
        readHiveCharResults.start = 0;
        readHiveCharResults.length = hiveCharWritable.getTextValue().getLength();
    }

    @Override
    public DeserializeRead.ReadHiveVarcharResults createReadHiveVarcharResults() {
        return new BinarySortableReadHiveVarcharResults();
    }

    @Override
    public void readHiveVarchar(DeserializeRead.ReadHiveVarcharResults readHiveVarcharResults) throws IOException {
        BinarySortableReadHiveVarcharResults binarySortableReadHiveVarcharResults = (BinarySortableReadHiveVarcharResults)readHiveVarcharResults;
        if (!binarySortableReadHiveVarcharResults.isInit()) {
            binarySortableReadHiveVarcharResults.init((VarcharTypeInfo)this.primitiveTypeInfos[this.fieldIndex]);
        }
        HiveVarcharWritable hiveVarcharWritable = binarySortableReadHiveVarcharResults.getHiveVarcharWritable();
        BinarySortableSerDe.deserializeText(this.inputByteBuffer, this.columnSortOrderIsDesc[this.fieldIndex], hiveVarcharWritable.getTextValue());
        hiveVarcharWritable.enforceMaxLength(binarySortableReadHiveVarcharResults.getMaxLength());
        readHiveVarcharResults.bytes = hiveVarcharWritable.getTextValue().getBytes();
        readHiveVarcharResults.start = 0;
        readHiveVarcharResults.length = hiveVarcharWritable.getTextValue().getLength();
    }

    @Override
    public DeserializeRead.ReadBinaryResults createReadBinaryResults() {
        return new BinarySortableReadBinaryResults();
    }

    @Override
    public void readBinary(DeserializeRead.ReadBinaryResults readBinaryResults) throws IOException {
        BinarySortableReadBinaryResults binarySortableReadBinaryResults = (BinarySortableReadBinaryResults)readBinaryResults;
        BinarySortableSerDe.deserializeText(this.inputByteBuffer, this.columnSortOrderIsDesc[this.fieldIndex], binarySortableReadBinaryResults.text);
        readBinaryResults.bytes = binarySortableReadBinaryResults.text.getBytes();
        readBinaryResults.start = 0;
        readBinaryResults.length = binarySortableReadBinaryResults.text.getLength();
    }

    @Override
    public DeserializeRead.ReadDateResults createReadDateResults() {
        return new BinarySortableReadDateResults();
    }

    @Override
    public void readDate(DeserializeRead.ReadDateResults readDateResults) throws IOException {
        BinarySortableReadDateResults binarySortableReadDateResults = (BinarySortableReadDateResults)readDateResults;
        boolean invert = this.columnSortOrderIsDesc[this.fieldIndex];
        int v = this.inputByteBuffer.read(invert) ^ 0x80;
        for (int i = 0; i < 3; ++i) {
            v = (v << 8) + (this.inputByteBuffer.read(invert) & 0xFF);
        }
        DateWritable dateWritable = binarySortableReadDateResults.getDateWritable();
        dateWritable.set(v);
    }

    @Override
    public DeserializeRead.ReadTimestampResults createReadTimestampResults() {
        return new BinarySortableReadTimestampResults();
    }

    @Override
    public void readTimestamp(DeserializeRead.ReadTimestampResults readTimestampResults) throws IOException {
        BinarySortableReadTimestampResults binarySortableReadTimestampResults = (BinarySortableReadTimestampResults)readTimestampResults;
        boolean invert = this.columnSortOrderIsDesc[this.fieldIndex];
        byte[] timestampBytes = binarySortableReadTimestampResults.timestampBytes;
        for (int i = 0; i < timestampBytes.length; ++i) {
            timestampBytes[i] = this.inputByteBuffer.read(invert);
        }
        TimestampWritable timestampWritable = binarySortableReadTimestampResults.getTimestampWritable();
        timestampWritable.setBinarySortable(timestampBytes, 0);
    }

    @Override
    public DeserializeRead.ReadIntervalYearMonthResults createReadIntervalYearMonthResults() {
        return new BinarySortableReadIntervalYearMonthResults();
    }

    @Override
    public void readIntervalYearMonth(DeserializeRead.ReadIntervalYearMonthResults readIntervalYearMonthResults) throws IOException {
        BinarySortableReadIntervalYearMonthResults binarySortableReadIntervalYearMonthResults = (BinarySortableReadIntervalYearMonthResults)readIntervalYearMonthResults;
        boolean invert = this.columnSortOrderIsDesc[this.fieldIndex];
        int v = this.inputByteBuffer.read(invert) ^ 0x80;
        for (int i = 0; i < 3; ++i) {
            v = (v << 8) + (this.inputByteBuffer.read(invert) & 0xFF);
        }
        HiveIntervalYearMonthWritable hiveIntervalYearMonthWritable = binarySortableReadIntervalYearMonthResults.getHiveIntervalYearMonthWritable();
        hiveIntervalYearMonthWritable.set(v);
    }

    @Override
    public DeserializeRead.ReadIntervalDayTimeResults createReadIntervalDayTimeResults() {
        return new BinarySortableReadIntervalDayTimeResults();
    }

    @Override
    public void readIntervalDayTime(DeserializeRead.ReadIntervalDayTimeResults readIntervalDayTimeResults) throws IOException {
        BinarySortableReadIntervalDayTimeResults binarySortableReadIntervalDayTimeResults = (BinarySortableReadIntervalDayTimeResults)readIntervalDayTimeResults;
        boolean invert = this.columnSortOrderIsDesc[this.fieldIndex];
        long totalSecs = this.inputByteBuffer.read(invert) ^ 0x80;
        for (int i = 0; i < 7; ++i) {
            totalSecs = (totalSecs << 8) + (long)(this.inputByteBuffer.read(invert) & 0xFF);
        }
        int nanos = this.inputByteBuffer.read(invert) ^ 0x80;
        for (int i = 0; i < 3; ++i) {
            nanos = (nanos << 8) + (this.inputByteBuffer.read(invert) & 0xFF);
        }
        HiveIntervalDayTimeWritable hiveIntervalDayTimeWritable = binarySortableReadIntervalDayTimeResults.getHiveIntervalDayTimeWritable();
        hiveIntervalDayTimeWritable.set(totalSecs, nanos);
    }

    @Override
    public DeserializeRead.ReadDecimalResults createReadDecimalResults() {
        return new BinarySortableReadDecimalResults();
    }

    @Override
    public void readHiveDecimal(DeserializeRead.ReadDecimalResults readDecimalResults) throws IOException {
        BinarySortableReadDecimalResults binarySortableReadDecimalResults = (BinarySortableReadDecimalResults)readDecimalResults;
        if (!binarySortableReadDecimalResults.isInit()) {
            binarySortableReadDecimalResults.init(this.saveDecimalTypeInfo);
        }
        binarySortableReadDecimalResults.hiveDecimal = this.saveDecimal;
        this.saveDecimal = null;
        this.saveDecimalTypeInfo = null;
    }

    private boolean earlyReadHiveDecimal() throws IOException {
        boolean invert = this.columnSortOrderIsDesc[this.fieldIndex];
        int b = this.inputByteBuffer.read(invert) - 1;
        assert (b == 1 || b == -1 || b == 0);
        boolean positive = b != -1;
        int factor = this.inputByteBuffer.read(invert) ^ 0x80;
        for (int i = 0; i < 3; ++i) {
            factor = (factor << 8) + (this.inputByteBuffer.read(invert) & 0xFF);
        }
        if (!positive) {
            factor = -factor;
        }
        int start = this.inputByteBuffer.tell();
        int length = 0;
        while (true) {
            b = this.inputByteBuffer.read(positive ? invert : !invert);
            assert (b != 1);
            if (b == 0) break;
            ++length;
        }
        if (this.tempDecimalBuffer == null || this.tempDecimalBuffer.length < length) {
            this.tempDecimalBuffer = new byte[length];
        }
        this.inputByteBuffer.seek(start);
        for (int i = 0; i < length; ++i) {
            this.tempDecimalBuffer[i] = this.inputByteBuffer.read(positive ? invert : !invert);
        }
        this.inputByteBuffer.read(positive ? invert : !invert);
        String digits = new String(this.tempDecimalBuffer, 0, length, BinarySortableSerDe.decimalCharSet);
        BigInteger bi = new BigInteger(digits);
        HiveDecimal bd = HiveDecimal.create((BigInteger)bi).scaleByPowerOfTen(factor - length);
        if (!positive) {
            bd = bd.negate();
        }
        if (this.tempHiveDecimalWritable == null) {
            this.tempHiveDecimalWritable = new HiveDecimalWritable();
        }
        this.tempHiveDecimalWritable.set(bd);
        this.saveDecimalTypeInfo = (DecimalTypeInfo)this.primitiveTypeInfos[this.fieldIndex];
        int precision = this.saveDecimalTypeInfo.getPrecision();
        int scale = this.saveDecimalTypeInfo.getScale();
        this.saveDecimal = this.tempHiveDecimalWritable.getHiveDecimal(precision, scale);
        return this.saveDecimal == null;
    }

    private static class BinarySortableReadDecimalResults
    extends DeserializeRead.ReadDecimalResults {
        public HiveDecimal hiveDecimal;

        @Override
        public void init(DecimalTypeInfo decimalTypeInfo) {
            super.init(decimalTypeInfo);
        }

        @Override
        public HiveDecimal getHiveDecimal() {
            return this.hiveDecimal;
        }
    }

    private static class BinarySortableReadIntervalDayTimeResults
    extends DeserializeRead.ReadIntervalDayTimeResults {
        public HiveIntervalDayTimeWritable getHiveIntervalDayTimeWritable() {
            return this.hiveIntervalDayTimeWritable;
        }
    }

    private static class BinarySortableReadIntervalYearMonthResults
    extends DeserializeRead.ReadIntervalYearMonthResults {
        public HiveIntervalYearMonthWritable getHiveIntervalYearMonthWritable() {
            return this.hiveIntervalYearMonthWritable;
        }
    }

    private static class BinarySortableReadTimestampResults
    extends DeserializeRead.ReadTimestampResults {
        private byte[] timestampBytes = new byte[11];

        public TimestampWritable getTimestampWritable() {
            return this.timestampWritable;
        }
    }

    private static class BinarySortableReadDateResults
    extends DeserializeRead.ReadDateResults {
        public DateWritable getDateWritable() {
            return this.dateWritable;
        }
    }

    private static class BinarySortableReadBinaryResults
    extends DeserializeRead.ReadBinaryResults {
        private Text text = new Text();
    }

    private static class BinarySortableReadHiveVarcharResults
    extends DeserializeRead.ReadHiveVarcharResults {
        public HiveVarcharWritable getHiveVarcharWritable() {
            return this.hiveVarcharWritable;
        }
    }

    private static class BinarySortableReadHiveCharResults
    extends DeserializeRead.ReadHiveCharResults {
        public HiveCharWritable getHiveCharWritable() {
            return this.hiveCharWritable;
        }
    }

    private static class BinarySortableReadStringResults
    extends DeserializeRead.ReadStringResults {
        private Text text = new Text();
    }
}

