/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.util.ByteRange;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class SimpleByteRange
implements ByteRange {
    private static final int UNSET_HASH_VALUE = -1;
    protected byte[] bytes;
    protected int offset;
    protected int length;
    private int hash = -1;

    public SimpleByteRange() {
        this.unset();
    }

    public SimpleByteRange(int capacity) {
        this(new byte[capacity]);
    }

    public SimpleByteRange(byte[] bytes) {
        this.set(bytes);
    }

    public SimpleByteRange(byte[] bytes, int offset, int length) {
        this.set(bytes, offset, length);
    }

    @Override
    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public ByteRange unset() {
        this.clearHashCache();
        this.bytes = null;
        this.offset = 0;
        this.length = 0;
        return this;
    }

    @Override
    public ByteRange set(int capacity) {
        return this.set(new byte[capacity]);
    }

    @Override
    public ByteRange set(byte[] bytes) {
        if (null == bytes) {
            return this.unset();
        }
        this.clearHashCache();
        this.bytes = bytes;
        this.offset = 0;
        this.length = bytes.length;
        return this;
    }

    @Override
    public ByteRange set(byte[] bytes, int offset, int length) {
        if (null == bytes) {
            return this.unset();
        }
        this.clearHashCache();
        this.bytes = bytes;
        this.offset = offset;
        this.length = length;
        return this;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public ByteRange setOffset(int offset) {
        this.clearHashCache();
        this.offset = offset;
        return this;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public ByteRange setLength(int length) {
        this.clearHashCache();
        this.length = length;
        return this;
    }

    @Override
    public boolean isEmpty() {
        return SimpleByteRange.isEmpty(this);
    }

    public static boolean isEmpty(ByteRange range) {
        return range == null || range.getLength() == 0;
    }

    @Override
    public byte get(int index) {
        return this.bytes[this.offset + index];
    }

    @Override
    public ByteRange get(int index, byte[] dst) {
        if (0 == dst.length) {
            return this;
        }
        return this.get(index, dst, 0, dst.length);
    }

    @Override
    public ByteRange get(int index, byte[] dst, int offset, int length) {
        if (0 == length) {
            return this;
        }
        System.arraycopy(this.bytes, this.offset + index, dst, offset, length);
        return this;
    }

    @Override
    public ByteRange put(int index, byte val) {
        this.bytes[this.offset + index] = val;
        return this;
    }

    @Override
    public ByteRange put(int index, byte[] val) {
        if (0 == val.length) {
            return this;
        }
        return this.put(index, val, 0, val.length);
    }

    @Override
    public ByteRange put(int index, byte[] val, int offset, int length) {
        if (0 == length) {
            return this;
        }
        System.arraycopy(val, offset, this.bytes, this.offset + index, length);
        return this;
    }

    @Override
    public byte[] deepCopyToNewArray() {
        byte[] result = new byte[this.length];
        System.arraycopy(this.bytes, this.offset, result, 0, this.length);
        return result;
    }

    @Override
    public ByteRange deepCopy() {
        SimpleByteRange clone = new SimpleByteRange(this.deepCopyToNewArray());
        if (this.isHashCached()) {
            clone.hash = this.hash;
        }
        return clone;
    }

    @Override
    public void deepCopyTo(byte[] destination, int destinationOffset) {
        System.arraycopy(this.bytes, this.offset, destination, destinationOffset, this.length);
    }

    @Override
    public void deepCopySubRangeTo(int innerOffset, int copyLength, byte[] destination, int destinationOffset) {
        System.arraycopy(this.bytes, this.offset + innerOffset, destination, destinationOffset, copyLength);
    }

    @Override
    public ByteRange shallowCopy() {
        SimpleByteRange clone = new SimpleByteRange(this.bytes, this.offset, this.length);
        if (this.isHashCached()) {
            clone.hash = this.hash;
        }
        return clone;
    }

    @Override
    public ByteRange shallowCopySubRange(int innerOffset, int copyLength) {
        SimpleByteRange clone = new SimpleByteRange(this.bytes, this.offset + innerOffset, copyLength);
        if (this.isHashCached()) {
            clone.hash = this.hash;
        }
        return clone;
    }

    public boolean equals(Object thatObject) {
        if (thatObject == null) {
            return false;
        }
        if (this == thatObject) {
            return true;
        }
        if (this.hashCode() != thatObject.hashCode()) {
            return false;
        }
        if (!(thatObject instanceof SimpleByteRange)) {
            return false;
        }
        SimpleByteRange that = (SimpleByteRange)thatObject;
        return Bytes.equals(this.bytes, this.offset, this.length, that.bytes, that.offset, that.length);
    }

    public int hashCode() {
        if (this.isHashCached()) {
            return this.hash;
        }
        if (this.isEmpty()) {
            this.hash = 0;
            return this.hash;
        }
        int off = this.offset;
        this.hash = 0;
        for (int i = 0; i < this.length; ++i) {
            this.hash = 31 * this.hash + this.bytes[off++];
        }
        return this.hash;
    }

    private boolean isHashCached() {
        return this.hash != -1;
    }

    protected void clearHashCache() {
        this.hash = -1;
    }

    @Override
    public int compareTo(ByteRange other) {
        return Bytes.compareTo(this.bytes, this.offset, this.length, other.getBytes(), other.getOffset(), other.getLength());
    }

    public String toString() {
        return Bytes.toStringBinary(this.bytes, this.offset, this.length);
    }
}

