/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.events;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.recovery.records.RecoveryProtos;

public class TaskStartedEvent
implements HistoryEvent {
    private TezTaskID taskID;
    private String vertexName;
    private long scheduledTime;
    private long startTime;

    public TaskStartedEvent(TezTaskID taskId, String vertexName, long scheduledTime, long startTime) {
        this.vertexName = vertexName;
        this.taskID = taskId;
        this.scheduledTime = scheduledTime;
        this.startTime = startTime;
    }

    public TaskStartedEvent() {
    }

    @Override
    public HistoryEventType getEventType() {
        return HistoryEventType.TASK_STARTED;
    }

    @Override
    public boolean isRecoveryEvent() {
        return true;
    }

    @Override
    public boolean isHistoryEvent() {
        return true;
    }

    public RecoveryProtos.TaskStartedProto toProto() {
        return RecoveryProtos.TaskStartedProto.newBuilder().setTaskId(this.taskID.toString()).setLaunchTime(this.startTime).setScheduledTime(this.scheduledTime).build();
    }

    public void fromProto(RecoveryProtos.TaskStartedProto proto) {
        this.taskID = TezTaskID.fromString((String)proto.getTaskId());
        this.startTime = proto.getLaunchTime();
        this.scheduledTime = proto.getScheduledTime();
    }

    @Override
    public void toProtoStream(OutputStream outputStream) throws IOException {
        this.toProto().writeDelimitedTo(outputStream);
    }

    @Override
    public void fromProtoStream(InputStream inputStream) throws IOException {
        RecoveryProtos.TaskStartedProto proto = RecoveryProtos.TaskStartedProto.parseDelimitedFrom(inputStream);
        if (proto == null) {
            throw new IOException("No data found in stream");
        }
        this.fromProto(proto);
    }

    public String toString() {
        return "vertexName=" + this.vertexName + ", taskId=" + this.taskID.toString() + ", scheduledTime=" + this.scheduledTime + ", launchTime=" + this.startTime;
    }

    public TezTaskID getTaskID() {
        return this.taskID;
    }

    public long getScheduledTime() {
        return this.scheduledTime;
    }

    public long getStartTime() {
        return this.startTime;
    }
}

