/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.storage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.pig.Expression;
import org.apache.pig.PigWarning;
import org.apache.pig.ResourceSchema;
import org.apache.pig.ResourceStatistics;
import org.apache.pig.StoreFunc;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.util.UDFContext;
import org.apache.pig.impl.util.Utils;
import org.apache.pig.piggybank.storage.FixedWidthLoader;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class FixedWidthStorer
extends StoreFunc {
    private TupleFactory tupleFactory = TupleFactory.getInstance();
    private RecordWriter writer = null;
    private ArrayList<FixedWidthLoader.FixedWidthField> columns;
    private ResourceSchema schema = null;
    private ResourceSchema.ResourceFieldSchema[] fields;
    private boolean writingFirstRecord = true;
    private boolean writeHeader = false;
    private String udfContextSignature = null;
    private static final String SCHEMA_SIGNATURE = "pig.fixedwidthloader.schema";
    private static final Log log = LogFactory.getLog(FixedWidthStorer.class);

    public FixedWidthStorer() {
        throw new IllegalArgumentException("Usage: org.apache.pig.piggybank.storage.FixedWidthStorer('<column spec>'[, { 'WRITE_HEADER' | 'NO_HEADER' }])");
    }

    public FixedWidthStorer(String columnSpec) {
        this.columns = FixedWidthLoader.parseColumnSpec(columnSpec);
    }

    public FixedWidthStorer(String columnSpec, String headerStr) {
        this(columnSpec);
        if (headerStr.equalsIgnoreCase("WRITE_HEADER")) {
            this.writeHeader = true;
        }
    }

    public OutputFormat getOutputFormat() throws IOException {
        return new TextOutputFormat();
    }

    public void setStoreLocation(String location, Job job) throws IOException {
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(location));
    }

    public void setStoreFuncUDFContextSignature(String signature) {
        this.udfContextSignature = signature;
    }

    public void checkSchema(ResourceSchema s) throws IOException {
        UDFContext udfc = UDFContext.getUDFContext();
        Properties p = udfc.getUDFProperties(((Object)((Object)this)).getClass(), new String[]{this.udfContextSignature});
        p.setProperty(SCHEMA_SIGNATURE, s.toString());
    }

    public void prepareToWrite(RecordWriter writer) throws IOException {
        this.writer = writer;
        UDFContext udfc = UDFContext.getUDFContext();
        Properties p = udfc.getUDFProperties(((Object)((Object)this)).getClass(), new String[]{this.udfContextSignature});
        String strSchema = p.getProperty(SCHEMA_SIGNATURE);
        if (strSchema == null) {
            throw new IOException("Could not find schema in UDF context");
        }
        this.schema = new ResourceSchema(Utils.getSchemaFromString((String)strSchema));
        this.fields = this.schema.getFields();
    }

    public void putNext(Tuple t) throws IOException {
        FixedWidthLoader.FixedWidthField column;
        int i;
        StringBuilder sb = new StringBuilder();
        int offset = 0;
        if (this.writingFirstRecord && this.writeHeader) {
            for (i = 0; i < this.fields.length; ++i) {
                column = this.columns.get(i);
                sb.append(this.writeFieldAsString(this.fields[i], column, offset, this.fields[i].getName()));
                offset = column.end;
            }
            try {
                this.writer.write(null, (Object)new Text(sb.toString()));
            }
            catch (InterruptedException ie) {
                throw new IOException(ie);
            }
        }
        this.writingFirstRecord = false;
        sb = new StringBuilder();
        offset = 0;
        for (i = 0; i < this.fields.length; ++i) {
            column = this.columns.get(i);
            sb.append(this.writeFieldAsString(this.fields[i], column, offset, t.get(i)));
            offset = column.end;
        }
        try {
            this.writer.write(null, (Object)new Text(sb.toString()));
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    private String writeFieldAsString(ResourceSchema.ResourceFieldSchema field, FixedWidthLoader.FixedWidthField column, int offset, Object d) throws IOException {
        StringBuilder sb = new StringBuilder();
        if (offset < column.start) {
            int spaces = column.start - offset;
            for (int i = 0; i < spaces; ++i) {
                sb.append(' ');
            }
        }
        int width = column.end - column.start;
        String fieldStr = null;
        if (d != null) {
            fieldStr = DataType.findType((Object)d) == 30 ? ((DateTime)d).toDateTime(DateTimeZone.UTC).toString() : d.toString();
        }
        if (fieldStr == null) {
            for (int i = 0; i < width; ++i) {
                sb.append(' ');
            }
            return sb.toString();
        }
        if (fieldStr.length() > width) {
            byte fieldType = field.getType();
            if (fieldType == 20 || fieldType == 25) {
                double doubleVal = ((Number)d).doubleValue();
                int numDigitsLeftOfDecimal = (int)Math.ceil(Math.log10(Math.abs(doubleVal)));
                if (numDigitsLeftOfDecimal <= width + 2) {
                    int numDigitsRightOfDecimal = width - numDigitsLeftOfDecimal - 1;
                    String truncated = String.format("%." + numDigitsRightOfDecimal + "f", doubleVal);
                    this.warn("Cannot fit " + fieldStr + " in field starting at column " + column.start + " and ending at column " + (column.end - 1) + ". " + "Since the field is a decimal type, truncating it to " + truncated + " " + "to fit in the column.", (Enum)PigWarning.UDF_WARNING_1);
                    sb.append(truncated);
                } else {
                    this.warn("Cannot fit " + fieldStr + " in field starting at column " + column.start + " and ending at column " + (column.end - 1) + ". " + "Writing null (all spaces) instead.", (Enum)PigWarning.UDF_WARNING_2);
                    for (int i = 0; i < width; ++i) {
                        sb.append(' ');
                    }
                }
            } else {
                this.warn("Cannot fit " + fieldStr + " in field starting at column " + column.start + " and ending at column " + (column.end - 1) + ". " + "Writing null (all spaces) instead.", (Enum)PigWarning.UDF_WARNING_2);
                for (int i = 0; i < width; ++i) {
                    sb.append(' ');
                }
            }
        } else {
            int spaces = width - fieldStr.length();
            for (int i = 0; i < spaces; ++i) {
                sb.append(' ');
            }
            sb.append(fieldStr);
        }
        return sb.toString();
    }

    public ResourceStatistics getStatistics(String location, Job job) throws IOException {
        return null;
    }

    public void storeStatistics(ResourceStatistics stats, String location, Job job) throws IOException {
    }

    public String[] getPartitionKeys(String location, Job job) throws IOException {
        return null;
    }

    public void setPartitionFilter(Expression partitionFilter) throws IOException {
    }
}

