/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.client;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.thrift.ClientService;
import org.apache.accumulo.core.client.impl.thrift.ConfigurationType;
import org.apache.accumulo.core.client.impl.thrift.SecurityErrorCode;
import org.apache.accumulo.core.client.impl.thrift.TableOperation;
import org.apache.accumulo.core.client.impl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.client.impl.thrift.ThriftTableOperationException;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.CredentialHelper;
import org.apache.accumulo.core.security.SystemPermission;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.server.client.BulkImporter;
import org.apache.accumulo.server.conf.ServerConfiguration;
import org.apache.accumulo.server.security.AuditedSecurityOperation;
import org.apache.accumulo.server.security.SecurityOperation;
import org.apache.accumulo.server.zookeeper.TransactionWatcher;
import org.apache.accumulo.start.classloader.vfs.AccumuloVFSClassLoader;
import org.apache.accumulo.trace.thrift.TInfo;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;

public class ClientServiceHandler
implements ClientService.Iface {
    private static final Logger log = Logger.getLogger(ClientServiceHandler.class);
    private static SecurityOperation security = AuditedSecurityOperation.getInstance();
    protected final TransactionWatcher transactionWatcher;
    private final Instance instance;

    public ClientServiceHandler(Instance instance, TransactionWatcher transactionWatcher) {
        this.instance = instance;
        this.transactionWatcher = transactionWatcher;
    }

    protected String checkTableId(String tableName, TableOperation operation) throws ThriftTableOperationException {
        String tableId = (String)Tables.getNameToIdMap((Instance)this.instance).get(tableName);
        if (tableId == null) {
            Tables.clearCache((Instance)this.instance);
            tableId = (String)Tables.getNameToIdMap((Instance)this.instance).get(tableName);
            if (tableId == null) {
                throw new ThriftTableOperationException(null, tableName, operation, TableOperationExceptionType.NOTFOUND, null);
            }
        }
        return tableId;
    }

    public String getInstanceId() {
        return this.instance.getInstanceID();
    }

    public String getRootTabletLocation() {
        return this.instance.getRootTabletLocation();
    }

    public String getZooKeepers() {
        return this.instance.getZooKeepers();
    }

    public void ping(TCredentials credentials) {
        log.info((Object)"Master reports: I just got pinged!");
    }

    public boolean authenticate(TInfo tinfo, TCredentials credentials) throws ThriftSecurityException {
        try {
            return security.authenticateUser(credentials, credentials);
        }
        catch (ThriftSecurityException e) {
            log.error((Object)e);
            throw e;
        }
    }

    public boolean authenticateUser(TInfo tinfo, TCredentials credentials, TCredentials toAuth) throws ThriftSecurityException {
        try {
            return security.authenticateUser(credentials, toAuth);
        }
        catch (ThriftSecurityException e) {
            log.error((Object)e);
            throw e;
        }
    }

    public void changeAuthorizations(TInfo tinfo, TCredentials credentials, String user, List<ByteBuffer> authorizations) throws ThriftSecurityException {
        security.changeAuthorizations(credentials, user, new Authorizations(authorizations));
    }

    public void changeLocalUserPassword(TInfo tinfo, TCredentials credentials, String principal, ByteBuffer password) throws ThriftSecurityException {
        PasswordToken token = new PasswordToken(password);
        TCredentials toChange = CredentialHelper.createSquelchError((String)principal, (AuthenticationToken)token, (String)credentials.instanceId);
        security.changePassword(credentials, toChange);
    }

    public void createLocalUser(TInfo tinfo, TCredentials credentials, String principal, ByteBuffer password) throws ThriftSecurityException {
        PasswordToken token = new PasswordToken(password);
        TCredentials newUser = CredentialHelper.createSquelchError((String)principal, (AuthenticationToken)token, (String)credentials.instanceId);
        security.createUser(credentials, newUser, new Authorizations());
    }

    public void dropLocalUser(TInfo tinfo, TCredentials credentials, String user) throws ThriftSecurityException {
        security.dropUser(credentials, user);
    }

    public List<ByteBuffer> getUserAuthorizations(TInfo tinfo, TCredentials credentials, String user) throws ThriftSecurityException {
        return security.getUserAuthorizations(credentials, user).getAuthorizationsBB();
    }

    public void grantSystemPermission(TInfo tinfo, TCredentials credentials, String user, byte permission) throws ThriftSecurityException {
        security.grantSystemPermission(credentials, user, SystemPermission.getPermissionById((byte)permission));
    }

    public void grantTablePermission(TInfo tinfo, TCredentials credentials, String user, String tableName, byte permission) throws ThriftSecurityException, ThriftTableOperationException {
        String tableId = this.checkTableId(tableName, TableOperation.PERMISSION);
        security.grantTablePermission(credentials, user, tableId, TablePermission.getPermissionById((byte)permission));
    }

    public void revokeSystemPermission(TInfo tinfo, TCredentials credentials, String user, byte permission) throws ThriftSecurityException {
        security.revokeSystemPermission(credentials, user, SystemPermission.getPermissionById((byte)permission));
    }

    public void revokeTablePermission(TInfo tinfo, TCredentials credentials, String user, String tableName, byte permission) throws ThriftSecurityException, ThriftTableOperationException {
        String tableId = this.checkTableId(tableName, TableOperation.PERMISSION);
        security.revokeTablePermission(credentials, user, tableId, TablePermission.getPermissionById((byte)permission));
    }

    public boolean hasSystemPermission(TInfo tinfo, TCredentials credentials, String user, byte sysPerm) throws ThriftSecurityException {
        return security.hasSystemPermission(credentials, user, SystemPermission.getPermissionById((byte)sysPerm));
    }

    public boolean hasTablePermission(TInfo tinfo, TCredentials credentials, String user, String tableName, byte tblPerm) throws ThriftSecurityException, ThriftTableOperationException {
        String tableId = this.checkTableId(tableName, TableOperation.PERMISSION);
        return security.hasTablePermission(credentials, user, tableId, TablePermission.getPermissionById((byte)tblPerm));
    }

    public Set<String> listLocalUsers(TInfo tinfo, TCredentials credentials) throws ThriftSecurityException {
        return security.listUsers(credentials);
    }

    private static Map<String, String> conf(TCredentials credentials, AccumuloConfiguration conf) throws TException {
        security.authenticateUser(credentials, credentials);
        conf.invalidateCache();
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry entry : conf) {
            if (((String)entry.getKey()).equals(Property.INSTANCE_SECRET.getKey()) || ((String)entry.getKey()).toLowerCase().contains("password") || ((String)entry.getKey()).startsWith(Property.TRACE_TOKEN_PROPERTY_PREFIX.getKey())) continue;
            result.put((String)entry.getKey(), (String)entry.getValue());
        }
        return result;
    }

    public Map<String, String> getConfiguration(TInfo tinfo, TCredentials credentials, ConfigurationType type) throws TException {
        switch (type) {
            case CURRENT: {
                return ClientServiceHandler.conf(credentials, new ServerConfiguration(this.instance).getConfiguration());
            }
            case SITE: {
                return ClientServiceHandler.conf(credentials, (AccumuloConfiguration)ServerConfiguration.getSiteConfiguration());
            }
            case DEFAULT: {
                return ClientServiceHandler.conf(credentials, (AccumuloConfiguration)AccumuloConfiguration.getDefaultConfiguration());
            }
        }
        throw new RuntimeException("Unexpected configuration type " + type);
    }

    public Map<String, String> getTableConfiguration(TInfo tinfo, TCredentials credentials, String tableName) throws TException, ThriftTableOperationException {
        String tableId = this.checkTableId(tableName, null);
        return ClientServiceHandler.conf(credentials, new ServerConfiguration(this.instance).getTableConfiguration(tableId));
    }

    public List<String> bulkImportFiles(TInfo tinfo, TCredentials tikw, final long tid, final String tableId, final List<String> files, final String errorDir, final boolean setTime) throws ThriftSecurityException, ThriftTableOperationException, TException {
        try {
            final TCredentials credentials = new TCredentials(tikw);
            if (!security.hasSystemPermission(credentials, credentials.getPrincipal(), SystemPermission.SYSTEM)) {
                throw new AccumuloSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
            }
            return (List)this.transactionWatcher.run("bulkTx", tid, new Callable<List<String>>(){

                @Override
                public List<String> call() throws Exception {
                    return BulkImporter.bulkLoad(new ServerConfiguration(ClientServiceHandler.this.instance).getConfiguration(), ClientServiceHandler.this.instance, credentials, tid, tableId, files, errorDir, setTime);
                }
            });
        }
        catch (AccumuloSecurityException e) {
            throw e.asThriftException();
        }
        catch (Exception ex) {
            throw new TException((Throwable)ex);
        }
    }

    public boolean isActive(TInfo tinfo, long tid) throws TException {
        return this.transactionWatcher.isActive(tid);
    }

    public boolean checkClass(TInfo tinfo, TCredentials credentials, String className, String interfaceMatch) throws TException {
        security.authenticateUser(credentials, credentials);
        ClassLoader loader = this.getClass().getClassLoader();
        try {
            Class<?> shouldMatch = loader.loadClass(interfaceMatch);
            Class test = AccumuloVFSClassLoader.loadClass((String)className, shouldMatch);
            test.newInstance();
            return true;
        }
        catch (ClassCastException e) {
            log.warn((Object)"Error checking object types", (Throwable)e);
            return false;
        }
        catch (ClassNotFoundException e) {
            log.warn((Object)"Error checking object types", (Throwable)e);
            return false;
        }
        catch (InstantiationException e) {
            log.warn((Object)"Error checking object types", (Throwable)e);
            return false;
        }
        catch (IllegalAccessException e) {
            log.warn((Object)"Error checking object types", (Throwable)e);
            return false;
        }
    }

    public boolean checkTableClass(TInfo tinfo, TCredentials credentials, String tableName, String className, String interfaceMatch) throws TException, ThriftTableOperationException, ThriftSecurityException {
        security.authenticateUser(credentials, credentials);
        String tableId = this.checkTableId(tableName, null);
        ClassLoader loader = this.getClass().getClassLoader();
        try {
            Class<?> shouldMatch = loader.loadClass(interfaceMatch);
            new ServerConfiguration(this.instance).getTableConfiguration(tableId);
            String context = new ServerConfiguration(this.instance).getTableConfiguration(tableId).get(Property.TABLE_CLASSPATH);
            ClassLoader currentLoader = context != null && !context.equals("") ? AccumuloVFSClassLoader.getContextManager().getClassLoader(context) : AccumuloVFSClassLoader.getClassLoader();
            Class<?> test = currentLoader.loadClass(className).asSubclass(shouldMatch);
            test.newInstance();
            return true;
        }
        catch (Exception e) {
            log.warn((Object)"Error checking object types", (Throwable)e);
            return false;
        }
    }
}

