/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.recovery;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.server.master.Master;
import org.apache.accumulo.server.master.recovery.LogCloser;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.log4j.Logger;

public class HadoopLogCloser
implements LogCloser {
    private static Logger log = Logger.getLogger(HadoopLogCloser.class);

    @Override
    public long close(Master master, FileSystem fs, Path source) throws IOException {
        if (fs instanceof DistributedFileSystem) {
            DistributedFileSystem dfs = (DistributedFileSystem)fs;
            try {
                if (!dfs.recoverLease(source)) {
                    log.info((Object)("Waiting for file to be closed " + source.toString()));
                    return master.getConfiguration().getConfiguration().getTimeInMillis(Property.MASTER_LEASE_RECOVERY_WAITING_PERIOD);
                }
                log.info((Object)("Recovered lease on " + source.toString()));
                return 0L;
            }
            catch (FileNotFoundException ex) {
                throw ex;
            }
            catch (Exception ex) {
                log.warn((Object)("Error recovery lease on " + source.toString()), (Throwable)ex);
            }
        } else if (!(fs instanceof LocalFileSystem)) {
            throw new IllegalStateException("Don't know how to recover a lease for " + fs.getClass().getName());
        }
        fs.append(source).close();
        log.info((Object)("Recovered lease on " + source.toString() + " using append"));
        return 0L;
    }
}

