/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.state;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SkippingIterator;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.util.StringUtil;
import org.apache.accumulo.server.master.state.MergeInfo;
import org.apache.accumulo.server.master.state.MergeState;
import org.apache.accumulo.server.master.state.MetaDataTableScanner;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.accumulo.server.master.state.TabletLocationState;
import org.apache.accumulo.server.util.AddressUtil;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Text;

public class TabletStateChangeIterator
extends SkippingIterator {
    private static final String SERVERS_OPTION = "servers";
    private static final String TABLES_OPTION = "tables";
    private static final String MERGES_OPTION = "merges";
    Set<TServerInstance> current;
    Set<String> onlineTables;
    Map<Text, MergeInfo> merges;

    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        super.init(source, options, env);
        this.current = this.parseServers(options.get(SERVERS_OPTION));
        this.onlineTables = this.parseTables(options.get(TABLES_OPTION));
        this.merges = this.parseMerges(options.get(MERGES_OPTION));
    }

    private Set<String> parseTables(String tables) {
        if (tables == null) {
            return null;
        }
        HashSet<String> result = new HashSet<String>();
        for (String table : tables.split(",")) {
            result.add(table);
        }
        return result;
    }

    private Set<TServerInstance> parseServers(String servers) {
        if (servers == null) {
            return null;
        }
        HashSet<TServerInstance> result = new HashSet<TServerInstance>();
        if (servers.length() > 0) {
            for (String part : servers.split(",")) {
                String[] parts = part.split("\\[", 2);
                String hostport = parts[0];
                String instance = parts[1];
                if (instance != null && instance.endsWith("]")) {
                    instance = instance.substring(0, instance.length() - 1);
                }
                result.add(new TServerInstance(AddressUtil.parseAddress(hostport, Property.TSERV_CLIENTPORT), instance));
            }
        }
        return result;
    }

    private Map<Text, MergeInfo> parseMerges(String merges) {
        if (merges == null) {
            return null;
        }
        try {
            HashMap<Text, MergeInfo> result = new HashMap<Text, MergeInfo>();
            DataInputBuffer buffer = new DataInputBuffer();
            byte[] data = Base64.decodeBase64((byte[])merges.getBytes());
            buffer.reset(data, data.length);
            while (buffer.available() > 0) {
                MergeInfo mergeInfo = new MergeInfo();
                mergeInfo.readFields((DataInput)buffer);
                result.put(mergeInfo.range.getTableId(), mergeInfo);
            }
            return result;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void consume() throws IOException {
        while (this.getSource().hasTop()) {
            TabletLocationState tls;
            Key k = (Key)this.getSource().getTopKey();
            Value v = (Value)this.getSource().getTopValue();
            if (this.onlineTables == null || this.current == null) {
                return;
            }
            try {
                tls = MetaDataTableScanner.createTabletLocationState(k, v);
                if (tls == null) {
                    return;
                }
            }
            catch (TabletLocationState.BadLocationStateException e) {
                return;
            }
            MergeInfo merge = this.merges.get(tls.extent.getTableId());
            if (merge != null && merge.getRange() != null && merge.getRange().overlaps(tls.extent)) {
                return;
            }
            boolean shouldBeOnline = this.onlineTables.contains(tls.extent.getTableId().toString());
            switch (tls.getState(this.current)) {
                case ASSIGNED: {
                    return;
                }
                case HOSTED: {
                    if (!shouldBeOnline) {
                        return;
                    }
                }
                case ASSIGNED_TO_DEAD_SERVER: {
                    return;
                }
                case UNASSIGNED: {
                    if (!shouldBeOnline) break;
                    return;
                }
            }
            this.getSource().next();
        }
    }

    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        throw new UnsupportedOperationException();
    }

    public static void setCurrentServers(IteratorSetting cfg, Set<TServerInstance> goodServers) {
        if (goodServers != null) {
            ArrayList<String> servers = new ArrayList<String>();
            for (TServerInstance server : goodServers) {
                servers.add(server.toString());
            }
            cfg.addOption(SERVERS_OPTION, StringUtil.join(servers, (String)","));
        }
    }

    public static void setOnlineTables(IteratorSetting cfg, Set<String> onlineTables) {
        if (onlineTables != null) {
            cfg.addOption(TABLES_OPTION, StringUtil.join(onlineTables, (String)","));
        }
    }

    public static void setMerges(IteratorSetting cfg, Collection<MergeInfo> merges) {
        DataOutputBuffer buffer = new DataOutputBuffer();
        try {
            for (MergeInfo info : merges) {
                KeyExtent extent = info.getRange();
                if (extent == null || info.getState().equals((Object)MergeState.NONE)) continue;
                info.write((DataOutput)buffer);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        String encoded = new String(Base64.encodeBase64((byte[])Arrays.copyOf(buffer.getData(), buffer.getLength())));
        cfg.addOption(MERGES_OPTION, encoded);
    }
}

