/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.tableOps;

import java.io.IOException;
import java.util.Map;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.admin.TableOperationsImpl;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.thrift.TableOperation;
import org.apache.accumulo.core.client.impl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.client.impl.thrift.ThriftTableOperationException;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.master.Master;
import org.apache.accumulo.server.master.state.tables.TableManager;
import org.apache.accumulo.server.master.tableOps.CreateImportDir;
import org.apache.accumulo.server.master.tableOps.ImportedTableInfo;
import org.apache.accumulo.server.master.tableOps.MasterRepo;
import org.apache.accumulo.server.master.tableOps.Utils;
import org.apache.accumulo.server.util.TablePropUtil;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

class ImportPopulateZookeeper
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private ImportedTableInfo tableInfo;

    ImportPopulateZookeeper(ImportedTableInfo ti) {
        this.tableInfo = ti;
    }

    @Override
    public long isReady(long tid, Master environment) throws Exception {
        return Utils.reserveTable(this.tableInfo.tableId, tid, true, false, TableOperation.IMPORT);
    }

    private Map<String, String> getExportedProps(FileSystem fs) throws Exception {
        Path path = new Path(this.tableInfo.exportDir, "exportMetadata.zip");
        try {
            return TableOperationsImpl.getExportedProps((FileSystem)fs, (Path)path);
        }
        catch (IOException ioe) {
            throw new ThriftTableOperationException(this.tableInfo.tableId, this.tableInfo.tableName, TableOperation.IMPORT, TableOperationExceptionType.OTHER, "Error reading table props from " + path + " " + ioe.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Repo<Master> call(long tid, Master env) throws Exception {
        Utils.tableNameLock.lock();
        try {
            Instance instance = HdfsZooInstance.getInstance();
            Utils.checkTableDoesNotExist(instance, this.tableInfo.tableName, this.tableInfo.tableId, TableOperation.CREATE);
            TableManager.getInstance().addTable(this.tableInfo.tableId, this.tableInfo.tableName, ZooUtil.NodeExistsPolicy.OVERWRITE);
            Tables.clearCache((Instance)instance);
        }
        finally {
            Utils.tableNameLock.unlock();
        }
        for (Map.Entry<String, String> entry : this.getExportedProps(env.getFileSystem()).entrySet()) {
            if (TablePropUtil.setTableProperty(this.tableInfo.tableId, entry.getKey(), entry.getValue())) continue;
            throw new ThriftTableOperationException(this.tableInfo.tableId, this.tableInfo.tableName, TableOperation.IMPORT, TableOperationExceptionType.OTHER, "Invalid table property " + entry.getKey());
        }
        return new CreateImportDir(this.tableInfo);
    }

    @Override
    public void undo(long tid, Master env) throws Exception {
        Instance instance = HdfsZooInstance.getInstance();
        TableManager.getInstance().removeTable(this.tableInfo.tableId);
        Utils.unreserveTable(this.tableInfo.tableId, tid, true);
        Tables.clearCache((Instance)instance);
    }
}

