/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.monitor;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.util.TTimeoutTransport;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.server.conf.ServerConfiguration;
import org.apache.log4j.Logger;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class ZooKeeperStatus
implements Runnable {
    private static final Logger log = Logger.getLogger(ZooKeeperStatus.class);
    private volatile boolean stop = false;
    private static SortedSet<ZooKeeperState> status = new TreeSet<ZooKeeperState>();

    public static Collection<ZooKeeperState> getZooKeeperStatus() {
        return status;
    }

    public void stop() {
        this.stop = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.stop) {
            String[] zookeepers;
            TreeSet<ZooKeeperState> update = new TreeSet<ZooKeeperState>();
            for (String keeper : zookeepers = ServerConfiguration.getSiteConfiguration().get(Property.INSTANCE_ZK_HOST).split(",")) {
                int clients = 0;
                String mode = "unknown";
                String[] parts = keeper.split(":");
                TTransport transport = null;
                try {
                    InetSocketAddress addr = parts.length > 1 ? new InetSocketAddress(parts[0], Integer.parseInt(parts[1])) : new InetSocketAddress(parts[0], 2181);
                    transport = TTimeoutTransport.create((SocketAddress)addr, (long)10000L);
                    transport.write("stat\n".getBytes(), 0, 5);
                    StringBuilder response = new StringBuilder();
                    try {
                        transport.flush();
                        byte[] buffer = new byte[102400];
                        int n = 0;
                        while ((n = transport.read(buffer, 0, buffer.length)) > 0) {
                            response.append(new String(buffer, 0, n));
                        }
                    }
                    catch (TTransportException ex) {
                        // empty catch block
                    }
                    for (String line : response.toString().split("\n")) {
                        if (line.startsWith(" ")) {
                            ++clients;
                        }
                        if (!line.startsWith("Mode")) continue;
                        mode = line.split(":")[1];
                    }
                    update.add(new ZooKeeperState(keeper, mode, clients));
                }
                catch (Exception ex) {
                    log.info((Object)("Exception talking to zookeeper " + keeper), (Throwable)ex);
                    update.add(new ZooKeeperState(keeper, "Down", -1));
                }
                finally {
                    if (transport != null) {
                        try {
                            transport.close();
                        }
                        catch (Exception ex) {
                            log.error((Object)ex, (Throwable)ex);
                        }
                    }
                }
            }
            status = update;
            UtilWaitThread.sleep((long)1000L);
        }
    }

    public static class ZooKeeperState
    implements Comparable<ZooKeeperState> {
        public final String keeper;
        public final String mode;
        public final int clients;

        public ZooKeeperState(String keeper, String mode, int clients) {
            this.keeper = keeper;
            this.mode = mode;
            this.clients = clients;
        }

        @Override
        public int compareTo(ZooKeeperState other) {
            if (this == other) {
                return 0;
            }
            if (other == null) {
                return 1;
            }
            if (this.keeper == other.keeper) {
                return 0;
            }
            if (null == this.keeper) {
                return -1;
            }
            if (null == other.keeper) {
                return 1;
            }
            return this.keeper.compareTo(other.keeper);
        }
    }
}

