/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.tabletserver;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.accumulo.core.data.Value;

public class MemValue
extends Value {
    int kvCount;
    boolean merged = false;

    public MemValue(byte[] value, int kv) {
        super(value);
        this.kvCount = kv;
    }

    public MemValue() {
        this.kvCount = Integer.MAX_VALUE;
    }

    public MemValue(Value value, int kv) {
        super(value);
        this.kvCount = kv;
    }

    public void write(DataOutput out) throws IOException {
        if (!this.merged) {
            byte[] combinedBytes = new byte[this.getSize() + 4];
            System.arraycopy(this.value, 0, combinedBytes, 4, this.getSize());
            combinedBytes[0] = (byte)(this.kvCount >>> 24);
            combinedBytes[1] = (byte)(this.kvCount >>> 16);
            combinedBytes[2] = (byte)(this.kvCount >>> 8);
            combinedBytes[3] = (byte)this.kvCount;
            this.value = combinedBytes;
            this.merged = true;
        }
        super.write(out);
    }

    public void set(byte[] b) {
        super.set(b);
        this.merged = false;
    }

    public void copy(byte[] b) {
        super.copy(b);
        this.merged = false;
    }

    public static int splitKVCount(Value v) {
        if (v instanceof MemValue) {
            return ((MemValue)v).kvCount;
        }
        byte[] originalBytes = new byte[v.getSize() - 4];
        byte[] combined = v.get();
        System.arraycopy(combined, 4, originalBytes, 0, originalBytes.length);
        v.set(originalBytes);
        return (combined[0] << 24) + ((combined[1] & 0xFF) << 16) + ((combined[2] & 0xFF) << 8) + (combined[3] & 0xFF);
    }
}

