/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.tabletserver;

import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.accumulo.core.client.admin.TimeType;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.server.data.ServerMutation;
import org.apache.accumulo.server.util.time.RelativeTime;

public abstract class TabletTime {
    public static final char LOGICAL_TIME_ID = 'L';
    public static final char MILLIS_TIME_ID = 'M';

    public static char getTimeID(TimeType timeType) {
        switch (timeType) {
            case LOGICAL: {
                return 'L';
            }
            case MILLIS: {
                return 'M';
            }
        }
        throw new IllegalArgumentException("Unknown time type " + timeType);
    }

    abstract void useMaxTimeFromWALog(long var1);

    abstract String getMetadataValue(long var1);

    abstract String getMetadataValue();

    abstract long setUpdateTimes(List<Mutation> var1);

    abstract long getTime();

    abstract long getAndUpdateTime();

    protected void setSystemTimes(Mutation mutation, long lastCommitTime) {
        ServerMutation m = (ServerMutation)mutation;
        m.setSystemTimestamp(lastCommitTime);
    }

    static TabletTime getInstance(String metadataValue) {
        if (metadataValue.charAt(0) == 'L') {
            return new LogicalTime(Long.parseLong(metadataValue.substring(1)));
        }
        if (metadataValue.charAt(0) == 'M') {
            return new MillisTime(Long.parseLong(metadataValue.substring(1)));
        }
        throw new IllegalArgumentException("Time type unknown : " + metadataValue);
    }

    public static String maxMetadataTime(String mv1, String mv2) {
        if (mv1 == null) {
            TabletTime.checkType(mv2);
            return mv2;
        }
        if (mv2 == null) {
            TabletTime.checkType(mv1);
            return mv1;
        }
        if (mv1.charAt(0) != mv2.charAt(0)) {
            throw new IllegalArgumentException("Time types differ " + mv1 + " " + mv2);
        }
        TabletTime.checkType(mv1);
        long t1 = Long.parseLong(mv1.substring(1));
        long t2 = Long.parseLong(mv2.substring(1));
        if (t1 < t2) {
            return mv2;
        }
        return mv1;
    }

    private static void checkType(String mv1) {
        if (mv1.charAt(0) != 'L' && mv1.charAt(0) != 'M') {
            throw new IllegalArgumentException("Invalid time type " + mv1);
        }
    }

    static class LogicalTime
    extends TabletTime {
        AtomicLong nextTime;

        private LogicalTime(Long time) {
            this.nextTime = new AtomicLong(time + 1L);
        }

        @Override
        void useMaxTimeFromWALog(long time) {
            if (this.nextTime.get() < ++time) {
                this.nextTime.set(time);
            }
        }

        @Override
        public String getMetadataValue() {
            return this.getMetadataValue(this.getTime());
        }

        @Override
        public String getMetadataValue(long time) {
            return "L" + time;
        }

        @Override
        long setUpdateTimes(List<Mutation> mutations) {
            if (mutations.size() == 0) {
                return this.getTime();
            }
            long time = this.nextTime.getAndAdd(mutations.size());
            for (Mutation mutation : mutations) {
                this.setSystemTimes(mutation, time++);
            }
            return time - 1L;
        }

        @Override
        long getTime() {
            return this.nextTime.get() - 1L;
        }

        @Override
        long getAndUpdateTime() {
            return this.nextTime.getAndIncrement();
        }
    }

    static class MillisTime
    extends TabletTime {
        private long lastTime;
        private long lastUpdateTime = 0L;

        public MillisTime(long time) {
            this.lastTime = time;
        }

        @Override
        String getMetadataValue(long time) {
            return "M" + time;
        }

        @Override
        public String getMetadataValue() {
            return this.getMetadataValue(this.lastTime);
        }

        @Override
        void useMaxTimeFromWALog(long time) {
            if (time > this.lastTime) {
                this.lastTime = time;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        long setUpdateTimes(List<Mutation> mutations) {
            long currTime = RelativeTime.currentTimeMillis();
            MillisTime millisTime = this;
            synchronized (millisTime) {
                if (mutations.size() == 0) {
                    return this.lastTime;
                }
                currTime = this.updateTime(currTime);
            }
            for (Mutation mutation : mutations) {
                this.setSystemTimes(mutation, currTime);
            }
            return currTime;
        }

        private long updateTime(long currTime) {
            if (currTime < this.lastTime) {
                if (currTime - this.lastUpdateTime > 0L) {
                    ++this.lastTime;
                }
                this.lastUpdateTime = currTime;
                currTime = this.lastTime;
            } else {
                this.lastTime = currTime;
            }
            return currTime;
        }

        @Override
        long getTime() {
            return this.lastTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        long getAndUpdateTime() {
            long currTime = RelativeTime.currentTimeMillis();
            MillisTime millisTime = this;
            synchronized (millisTime) {
                currTime = this.updateTime(currTime);
            }
            return currTime;
        }
    }
}

