/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.server.ServerConstants;
import org.apache.accumulo.server.cli.ClientOpts;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;

public class LocalityCheck {
    public int run(String[] args) throws Exception {
        ClientOpts opts = new ClientOpts();
        opts.parseArgs(LocalityCheck.class.getName(), args, new Object[0]);
        FileSystem fs = FileSystem.get((Configuration)CachedConfiguration.getInstance());
        Connector connector = opts.getConnector();
        Scanner scanner = connector.createScanner("!METADATA", Constants.NO_AUTHS);
        scanner.fetchColumnFamily(Constants.METADATA_CURRENT_LOCATION_COLUMN_FAMILY);
        scanner.fetchColumnFamily(Constants.METADATA_DATAFILE_COLUMN_FAMILY);
        scanner.setRange(Constants.METADATA_KEYSPACE);
        HashMap<String, Long> totalBlocks = new HashMap<String, Long>();
        HashMap<String, Long> localBlocks = new HashMap<String, Long>();
        ArrayList<String> files = new ArrayList<String>();
        for (Map.Entry entry : scanner) {
            Key key = (Key)entry.getKey();
            if (key.compareColumnFamily(Constants.METADATA_CURRENT_LOCATION_COLUMN_FAMILY) == 0) {
                String location = ((Value)entry.getValue()).toString();
                String[] parts = location.split(":");
                String host = parts[0];
                this.addBlocks(fs, host, files, totalBlocks, localBlocks);
                files.clear();
                continue;
            }
            if (key.compareColumnFamily(Constants.METADATA_DATAFILE_COLUMN_FAMILY) != 0) continue;
            files.add(new String(KeyExtent.tableOfMetadataRow((Text)key.getRow())) + LocalityCheck.slash(key.getColumnQualifier().toString()));
        }
        System.out.println(" Server         %local  total blocks");
        for (String host : totalBlocks.keySet()) {
            System.out.println(String.format("%15s %5.1f %8d", host, (double)((Long)localBlocks.get(host)).longValue() * 100.0 / (double)((Long)totalBlocks.get(host)).longValue(), totalBlocks.get(host)));
        }
        return 0;
    }

    private static String slash(String path) {
        if (path.startsWith("/")) {
            return path;
        }
        return "/" + path;
    }

    private void addBlocks(FileSystem fs, String host, ArrayList<String> files, Map<String, Long> totalBlocks, Map<String, Long> localBlocks) throws Exception {
        long allBlocks = 0L;
        long matchingBlocks = 0L;
        if (!totalBlocks.containsKey(host)) {
            totalBlocks.put(host, 0L);
            localBlocks.put(host, 0L);
        }
        for (String file : files) {
            BlockLocation[] fileBlockLocations;
            Path filePath = new Path(ServerConstants.getTablesDir() + "/" + file);
            FileStatus fileStatus = fs.getFileStatus(filePath);
            block1: for (BlockLocation blockLocation : fileBlockLocations = fs.getFileBlockLocations(fileStatus, 0L, fileStatus.getLen())) {
                ++allBlocks;
                for (String location : blockLocation.getHosts()) {
                    InetSocketAddress inetSocketAddress = new InetSocketAddress(location, 0);
                    if (!inetSocketAddress.getAddress().getHostAddress().equals(host)) continue;
                    ++matchingBlocks;
                    continue block1;
                }
            }
        }
        totalBlocks.put(host, allBlocks + totalBlocks.get(host));
        localBlocks.put(host, matchingBlocks + localBlocks.get(host));
    }

    public static void main(String[] args) throws Exception {
        LocalityCheck check = new LocalityCheck();
        System.exit(check.run(args));
    }
}

