/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import java.io.IOException;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.server.tabletserver.UniqueNameAllocator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;

public class TabletOperations {
    private static final Logger log = Logger.getLogger(TabletOperations.class);

    public static String createTabletDirectory(FileSystem fs, String tableDir, Text endRow) {
        UniqueNameAllocator namer = UniqueNameAllocator.getInstance();
        while (true) {
            try {
                Path lowDirectoryPath;
                String lowDirectory;
                if (endRow == null) {
                    lowDirectory = "/default_tablet";
                    lowDirectoryPath = new Path(tableDir + lowDirectory);
                    if (fs.exists(lowDirectoryPath) || fs.mkdirs(lowDirectoryPath)) {
                        return lowDirectory;
                    }
                    log.warn((Object)("Failed to create " + lowDirectoryPath + " for unknown reason"));
                } else {
                    lowDirectory = "/t-" + namer.getNextName();
                    lowDirectoryPath = new Path(tableDir + lowDirectory);
                    if (fs.exists(lowDirectoryPath)) {
                        throw new IllegalStateException("Dir exist when it should not " + lowDirectoryPath);
                    }
                    if (fs.mkdirs(lowDirectoryPath)) {
                        return lowDirectory;
                    }
                }
            }
            catch (IOException e) {
                log.warn((Object)e);
            }
            log.warn((Object)("Failed to create dir for tablet in table " + tableDir + " will retry ..."));
            UtilWaitThread.sleep((long)3000L);
        }
    }

    public static String createTabletDirectory(String tableDir, Text endRow) {
        while (true) {
            try {
                FileSystem fs = FileSystem.get((Configuration)CachedConfiguration.getInstance());
                return TabletOperations.createTabletDirectory(fs, tableDir, endRow);
            }
            catch (IOException e) {
                log.warn((Object)e);
                UtilWaitThread.sleep((long)3000L);
                continue;
            }
            break;
        }
    }
}

