/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;

public class NotCol
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum;
    private int outputColumn;

    public NotCol(int colNum, int outputColumn) {
        this();
        this.colNum = colNum;
        this.outputColumn = outputColumn;
    }

    public NotCol() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector inputColVector = (LongColumnVector)batch.cols[this.colNum];
        int[] sel = batch.selected;
        int n = batch.size;
        long[] vector = inputColVector.vector;
        LongColumnVector outV = (LongColumnVector)batch.cols[this.outputColumn];
        long[] outputVector = outV.vector;
        if (n <= 0) {
            return;
        }
        if (inputColVector.noNulls) {
            outV.noNulls = true;
            if (inputColVector.isRepeating) {
                outV.isRepeating = true;
                outputVector[0] = (vector[0] ^ 0xFFFFFFFFFFFFFFFFL) & 1L;
            } else if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputVector[i] = (vector[i] ^ 0xFFFFFFFFFFFFFFFFL) & 1L;
                }
                outV.isRepeating = false;
            } else {
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = (vector[i] ^ 0xFFFFFFFFFFFFFFFFL) & 1L;
                }
                outV.isRepeating = false;
            }
        } else {
            outV.noNulls = false;
            if (inputColVector.isRepeating) {
                outV.isRepeating = true;
                outputVector[0] = (vector[0] ^ 0xFFFFFFFFFFFFFFFFL) & 1L;
                outV.isNull[0] = inputColVector.isNull[0];
            } else if (batch.selectedInUse) {
                outV.isRepeating = false;
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputVector[i] = (vector[i] ^ 0xFFFFFFFFFFFFFFFFL) & 1L;
                    outV.isNull[i] = inputColVector.isNull[i];
                }
            } else {
                outV.isRepeating = false;
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = (vector[i] ^ 0xFFFFFFFFFFFFFFFFL) & 1L;
                    outV.isNull[i] = inputColVector.isNull[i];
                }
            }
        }
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    @Override
    public String getOutputType() {
        return "boolean";
    }

    public int getColNum() {
        return this.colNum;
    }

    public void setColNum(int colNum) {
        this.colNum = colNum;
    }

    public void setOutputColumn(int outputColumn) {
        this.outputColumn = outputColumn;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(1).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.INT_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

