/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen;

import java.util.ArrayList;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorAggregationBufferRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorAggregateExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.util.JavaDataModel;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.LongWritable;

@Description(name="avg", value="_FUNC_(expr) - Returns the average value of expr (vectorized, type: double)")
public class VectorUDAFAvgDouble
extends VectorAggregateExpression {
    private static final long serialVersionUID = 1L;
    private VectorExpression inputExpression;
    private transient Object[] partialResult = new Object[2];
    private transient LongWritable resultCount = new LongWritable();
    private transient DoubleWritable resultSum = new DoubleWritable();
    private transient StructObjectInspector soi;

    public VectorUDAFAvgDouble(VectorExpression inputExpression) {
        this();
        this.inputExpression = inputExpression;
    }

    public VectorUDAFAvgDouble() {
        this.partialResult[0] = this.resultCount;
        this.partialResult[1] = this.resultSum;
        this.initPartialResultInspector();
    }

    private void initPartialResultInspector() {
        ArrayList<Object> foi = new ArrayList<Object>();
        foi.add(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
        foi.add(PrimitiveObjectInspectorFactory.writableDoubleObjectInspector);
        ArrayList<String> fname = new ArrayList<String>();
        fname.add("count");
        fname.add("sum");
        this.soi = ObjectInspectorFactory.getStandardStructObjectInspector(fname, foi);
    }

    private Aggregation getCurrentAggregationBuffer(VectorAggregationBufferRow[] aggregationBufferSets, int bufferIndex, int row) {
        VectorAggregationBufferRow mySet = aggregationBufferSets[row];
        Aggregation myagg = (Aggregation)mySet.getAggregationBuffer(bufferIndex);
        return myagg;
    }

    @Override
    public void aggregateInputSelection(VectorAggregationBufferRow[] aggregationBufferSets, int bufferIndex, VectorizedRowBatch batch) throws HiveException {
        int batchSize = batch.size;
        if (batchSize == 0) {
            return;
        }
        this.inputExpression.evaluate(batch);
        DoubleColumnVector inputVector = (DoubleColumnVector)batch.cols[this.inputExpression.getOutputColumn()];
        double[] vector = inputVector.vector;
        if (inputVector.noNulls) {
            if (inputVector.isRepeating) {
                this.iterateNoNullsRepeatingWithAggregationSelection(aggregationBufferSets, bufferIndex, vector[0], batchSize);
            } else if (batch.selectedInUse) {
                this.iterateNoNullsSelectionWithAggregationSelection(aggregationBufferSets, bufferIndex, vector, batch.selected, batchSize);
            } else {
                this.iterateNoNullsWithAggregationSelection(aggregationBufferSets, bufferIndex, vector, batchSize);
            }
        } else if (inputVector.isRepeating) {
            if (batch.selectedInUse) {
                this.iterateHasNullsRepeatingSelectionWithAggregationSelection(aggregationBufferSets, bufferIndex, vector[0], batchSize, batch.selected, inputVector.isNull);
            } else {
                this.iterateHasNullsRepeatingWithAggregationSelection(aggregationBufferSets, bufferIndex, vector[0], batchSize, inputVector.isNull);
            }
        } else if (batch.selectedInUse) {
            this.iterateHasNullsSelectionWithAggregationSelection(aggregationBufferSets, bufferIndex, vector, batchSize, batch.selected, inputVector.isNull);
        } else {
            this.iterateHasNullsWithAggregationSelection(aggregationBufferSets, bufferIndex, vector, batchSize, inputVector.isNull);
        }
    }

    private void iterateNoNullsRepeatingWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int bufferIndex, double value, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, bufferIndex, i);
            myagg.sumValue(value);
        }
    }

    private void iterateNoNullsSelectionWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int bufferIndex, double[] values, int[] selection, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, bufferIndex, i);
            myagg.sumValue(values[selection[i]]);
        }
    }

    private void iterateNoNullsWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int bufferIndex, double[] values, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, bufferIndex, i);
            myagg.sumValue(values[i]);
        }
    }

    private void iterateHasNullsRepeatingSelectionWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int bufferIndex, double value, int batchSize, int[] selection, boolean[] isNull) {
        for (int i = 0; i < batchSize; ++i) {
            if (isNull[selection[i]]) continue;
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, bufferIndex, i);
            myagg.sumValue(value);
        }
    }

    private void iterateHasNullsRepeatingWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int bufferIndex, double value, int batchSize, boolean[] isNull) {
        for (int i = 0; i < batchSize; ++i) {
            if (isNull[i]) continue;
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, bufferIndex, i);
            myagg.sumValue(value);
        }
    }

    private void iterateHasNullsSelectionWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int bufferIndex, double[] values, int batchSize, int[] selection, boolean[] isNull) {
        for (int j = 0; j < batchSize; ++j) {
            int i = selection[j];
            if (isNull[i]) continue;
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, bufferIndex, j);
            myagg.sumValue(values[i]);
        }
    }

    private void iterateHasNullsWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int bufferIndex, double[] values, int batchSize, boolean[] isNull) {
        for (int i = 0; i < batchSize; ++i) {
            if (isNull[i]) continue;
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, bufferIndex, i);
            myagg.sumValue(values[i]);
        }
    }

    @Override
    public void aggregateInput(VectorAggregateExpression.AggregationBuffer agg, VectorizedRowBatch batch) throws HiveException {
        this.inputExpression.evaluate(batch);
        DoubleColumnVector inputVector = (DoubleColumnVector)batch.cols[this.inputExpression.getOutputColumn()];
        int batchSize = batch.size;
        if (batchSize == 0) {
            return;
        }
        Aggregation myagg = (Aggregation)agg;
        double[] vector = inputVector.vector;
        if (inputVector.isRepeating) {
            if (inputVector.noNulls) {
                if (myagg.isNull) {
                    myagg.isNull = false;
                    myagg.sum = 0.0;
                    myagg.count = 0L;
                }
                myagg.sum += vector[0] * (double)batchSize;
                myagg.count += batchSize;
            }
            return;
        }
        if (!batch.selectedInUse && inputVector.noNulls) {
            this.iterateNoSelectionNoNulls(myagg, vector, batchSize);
        } else if (!batch.selectedInUse) {
            this.iterateNoSelectionHasNulls(myagg, vector, batchSize, inputVector.isNull);
        } else if (inputVector.noNulls) {
            this.iterateSelectionNoNulls(myagg, vector, batchSize, batch.selected);
        } else {
            this.iterateSelectionHasNulls(myagg, vector, batchSize, inputVector.isNull, batch.selected);
        }
    }

    private void iterateSelectionHasNulls(Aggregation myagg, double[] vector, int batchSize, boolean[] isNull, int[] selected) {
        for (int j = 0; j < batchSize; ++j) {
            int i = selected[j];
            if (isNull[i]) continue;
            double value = vector[i];
            if (myagg.isNull) {
                myagg.isNull = false;
                myagg.sum = 0.0;
                myagg.count = 0L;
            }
            myagg.sum += value;
            myagg.count += 1L;
        }
    }

    private void iterateSelectionNoNulls(Aggregation myagg, double[] vector, int batchSize, int[] selected) {
        if (myagg.isNull) {
            myagg.isNull = false;
            myagg.sum = 0.0;
            myagg.count = 0L;
        }
        for (int i = 0; i < batchSize; ++i) {
            double value = vector[selected[i]];
            myagg.sum += value;
            myagg.count += 1L;
        }
    }

    private void iterateNoSelectionHasNulls(Aggregation myagg, double[] vector, int batchSize, boolean[] isNull) {
        for (int i = 0; i < batchSize; ++i) {
            if (isNull[i]) continue;
            double value = vector[i];
            if (myagg.isNull) {
                myagg.isNull = false;
                myagg.sum = 0.0;
                myagg.count = 0L;
            }
            myagg.sum += value;
            myagg.count += 1L;
        }
    }

    private void iterateNoSelectionNoNulls(Aggregation myagg, double[] vector, int batchSize) {
        if (myagg.isNull) {
            myagg.isNull = false;
            myagg.sum = 0.0;
            myagg.count = 0L;
        }
        for (int i = 0; i < batchSize; ++i) {
            double value = vector[i];
            myagg.sum += value;
            myagg.count += 1L;
        }
    }

    @Override
    public VectorAggregateExpression.AggregationBuffer getNewAggregationBuffer() throws HiveException {
        return new Aggregation();
    }

    @Override
    public void reset(VectorAggregateExpression.AggregationBuffer agg) throws HiveException {
        Aggregation myAgg = (Aggregation)agg;
        myAgg.reset();
    }

    @Override
    public Object evaluateOutput(VectorAggregateExpression.AggregationBuffer agg) throws HiveException {
        Aggregation myagg = (Aggregation)agg;
        if (myagg.isNull) {
            return null;
        }
        assert (0L < myagg.count);
        this.resultCount.set(myagg.count);
        this.resultSum.set(myagg.sum);
        return this.partialResult;
    }

    @Override
    public ObjectInspector getOutputObjectInspector() {
        return this.soi;
    }

    @Override
    public int getAggregationBufferFixedSize() {
        JavaDataModel model = JavaDataModel.get();
        return JavaDataModel.alignUp(model.object() + model.primitive2() * 2, model.memoryAlign());
    }

    @Override
    public void init(AggregationDesc desc) throws HiveException {
    }

    public VectorExpression getInputExpression() {
        return this.inputExpression;
    }

    public void setInputExpression(VectorExpression inputExpression) {
        this.inputExpression = inputExpression;
    }

    static class Aggregation
    implements VectorAggregateExpression.AggregationBuffer {
        private static final long serialVersionUID = 1L;
        private transient double sum;
        private transient long count;
        private transient boolean isNull = true;

        Aggregation() {
        }

        public void sumValue(double value) {
            if (this.isNull) {
                this.sum = value;
                this.count = 1L;
                this.isNull = false;
            } else {
                this.sum += value;
                ++this.count;
            }
        }

        @Override
        public int getVariableSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reset() {
            this.isNull = true;
            this.sum = 0.0;
            this.count = 0L;
        }
    }
}

