/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveCharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorConverter;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableBinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.VoidObjectInspector;

@Description(name="binary", value="_FUNC_(a) - cast a to binary", extended="Currently only string, char, varchar or binary can be cast into binary")
public class GenericUDFToBinary
extends GenericUDF {
    private transient PrimitiveObjectInspector argumentOI;
    private transient PrimitiveObjectInspectorConverter.BinaryConverter baConverter;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length < 1) {
            throw new UDFArgumentLengthException("The function BINARY requires at least one argument, got " + arguments.length);
        }
        try {
            this.argumentOI = (PrimitiveObjectInspector)arguments[0];
        }
        catch (ClassCastException e) {
            throw new UDFArgumentException("The function BINARY takes only primitive types");
        }
        if (!(this.argumentOI instanceof BinaryObjectInspector || this.argumentOI instanceof HiveCharObjectInspector || this.argumentOI instanceof HiveVarcharObjectInspector || this.argumentOI instanceof StringObjectInspector || this.argumentOI instanceof VoidObjectInspector)) {
            throw new UDFArgumentException("Only string, char, varchar or binary data can be cast into binary data types.");
        }
        this.baConverter = new PrimitiveObjectInspectorConverter.BinaryConverter(this.argumentOI, (SettableBinaryObjectInspector)PrimitiveObjectInspectorFactory.writableBinaryObjectInspector);
        return PrimitiveObjectInspectorFactory.writableBinaryObjectInspector;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object o0 = arguments[0].get();
        if (o0 == null) {
            return null;
        }
        return this.baConverter.convert(o0);
    }

    @Override
    public String getDisplayString(String[] children) {
        assert (children.length == 1);
        StringBuilder sb = new StringBuilder();
        sb.append("CAST( ");
        sb.append(children[0]);
        sb.append(" AS BINARY)");
        return sb.toString();
    }
}

