/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import com.google.protobuf.InvalidProtocolBufferException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.protobuf.generated.ComparatorProtos;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class BitComparator
extends ByteArrayComparable {
    protected BitwiseOp bitOperator;

    public BitComparator(byte[] value, BitwiseOp bitOperator) {
        super(value);
        this.bitOperator = bitOperator;
    }

    public BitwiseOp getOperator() {
        return this.bitOperator;
    }

    @Override
    public byte[] toByteArray() {
        ComparatorProtos.BitComparator.Builder builder = ComparatorProtos.BitComparator.newBuilder();
        builder.setComparable(super.convert());
        ComparatorProtos.BitComparator.BitwiseOp bitwiseOpPb = ComparatorProtos.BitComparator.BitwiseOp.valueOf((String)this.bitOperator.name());
        builder.setBitwiseOp(bitwiseOpPb);
        return builder.build().toByteArray();
    }

    public static BitComparator parseFrom(byte[] pbBytes) throws DeserializationException {
        ComparatorProtos.BitComparator proto;
        try {
            proto = ComparatorProtos.BitComparator.parseFrom((byte[])pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        BitwiseOp bitwiseOp = BitwiseOp.valueOf(proto.getBitwiseOp().name());
        return new BitComparator(proto.getComparable().getValue().toByteArray(), bitwiseOp);
    }

    @Override
    boolean areSerializedFieldsEqual(ByteArrayComparable other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof BitComparator)) {
            return false;
        }
        BitComparator comparator = (BitComparator)other;
        return super.areSerializedFieldsEqual(other) && this.getOperator().equals((Object)comparator.getOperator());
    }

    @Override
    public int compareTo(byte[] value, int offset, int length) {
        if (length != this.value.length) {
            return 1;
        }
        int b = 0;
        block5: for (int i = length - 1; i >= 0 && b == 0; --i) {
            switch (this.bitOperator) {
                case AND: {
                    b = this.value[i] & value[i + offset] & 0xFF;
                    continue block5;
                }
                case OR: {
                    b = (this.value[i] | value[i + offset]) & 0xFF;
                    continue block5;
                }
                case XOR: {
                    b = (this.value[i] ^ value[i + offset]) & 0xFF;
                }
            }
        }
        return b == 0 ? 1 : 0;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static enum BitwiseOp {
        AND,
        OR,
        XOR;

    }
}

