/*
 * Decompiled with CFR 0.152.
 */
package sdsu.io;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class ChunkReader
implements Enumeration {
    protected Reader input;
    protected char[] inputBuffer;
    protected int[] shiftTable;
    protected int bufferCharCount;
    protected char[] dataSeparator = null;
    protected boolean reachedEOF = false;
    protected static int EOFIndicator = -1;
    protected static int DEFAULT_BUFFER_SIZE = 256;

    public ChunkReader(Reader reader, String string) {
        this.input = reader;
        this.setSeparator(string);
    }

    public ChunkReader(String string, String string2) {
        this(new StringReader(string), string2);
    }

    public boolean eof() {
        return this.hasMoreElements();
    }

    protected final void fillInputBuffer() throws IOException {
        int n = this.inputBuffer.length - this.bufferCharCount;
        while (n > 0 && !this.reachedEOF) {
            int n2 = this.bufferCharCount;
            int n3 = this.input.read(this.inputBuffer, n2, n);
            if (n3 == EOFIndicator) {
                this.reachedEOF = true;
                this.input.close();
                continue;
            }
            if (n3 > 0) {
                this.bufferCharCount += n3;
                n -= n3;
                continue;
            }
            throw new IOException("Read attempted. Did not reach EOF and  no chars were read");
        }
    }

    public static ChunkReader fromFile(String string, String string2) throws FileNotFoundException {
        FileReader fileReader = new FileReader(string);
        BufferedReader bufferedReader = new BufferedReader(fileReader, 8000);
        return new ChunkReader(bufferedReader, string2);
    }

    protected int getShift(char c) {
        if (c >= this.shiftTable.length) {
            return 1;
        }
        return this.shiftTable[c];
    }

    public boolean hasMoreElements() {
        return !this.reachedEOF || this.bufferCharCount != 0;
    }

    private void initializeQuickSearch() {
        this.inputBuffer = new char[Math.max(this.dataSeparator.length + 1, DEFAULT_BUFFER_SIZE)];
        this.bufferCharCount = 0;
        this.shiftTable = new int[126];
        int n = 0;
        while (n < this.shiftTable.length) {
            this.shiftTable[n] = this.dataSeparator.length + 1;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.dataSeparator.length) {
            if (this.dataSeparator[n2] < this.shiftTable.length) {
                this.shiftTable[this.dataSeparator[n2]] = this.dataSeparator.length - n2;
            }
            ++n2;
        }
    }

    public Object nextElement() {
        StringBuffer stringBuffer = new StringBuffer(126);
        try {
            boolean bl = false;
            while (!bl) {
                this.fillInputBuffer();
                bl = this.searchInputBuffer(stringBuffer);
            }
        }
        catch (IOException iOException) {
            throw new NoSuchElementException("IO error in tring to find next element: " + iOException.getMessage());
        }
        return stringBuffer.toString();
    }

    public Object readChunk() {
        return this.nextElement();
    }

    protected boolean searchInputBuffer(StringBuffer stringBuffer) {
        int n = 0;
        int n2 = 0;
        int n3 = this.dataSeparator.length;
        while (n < this.bufferCharCount - n3 + 1) {
            int n4;
            boolean bl = true;
            int n5 = 0;
            while (n5 < n3) {
                if (this.dataSeparator[n5] != this.inputBuffer[n5 + n]) {
                    bl = false;
                    break;
                }
                ++n5;
            }
            if (bl) {
                stringBuffer.append(this.inputBuffer, n2, n - n2);
                n4 = n + n3;
                System.arraycopy(this.inputBuffer, n4, this.inputBuffer, 0, this.bufferCharCount - n4);
                this.bufferCharCount -= n4;
                return true;
            }
            n4 = n + n3;
            if (n4 >= this.bufferCharCount) {
                ++n;
                continue;
            }
            if ((n += this.getShift(this.inputBuffer[n4])) <= this.bufferCharCount) continue;
            n = this.bufferCharCount;
        }
        if (this.reachedEOF) {
            stringBuffer.append(this.inputBuffer, n2, this.bufferCharCount - n2);
            this.bufferCharCount = 0;
            return true;
        }
        stringBuffer.append(this.inputBuffer, n2, n - n2);
        System.arraycopy(this.inputBuffer, n, this.inputBuffer, 0, this.bufferCharCount - n);
        this.bufferCharCount -= n;
        return false;
    }

    public void setSeparator(String string) {
        this.dataSeparator = string.toCharArray();
        this.initializeQuickSearch();
    }
}

